
// import React, { useState, useEffect } from 'react';
// import { Search, UserPlus, Users, DollarSign, Calendar, RefreshCw, CheckCircle, Clock, XCircle } from 'lucide-react';

// interface User {
//   id: string;
//   name: string;
// }

// interface RedeemBonus {
//   userid: string;
//   code: string;
//   amount: number;
//   status: string;
//   createdat: string;
//   updatedat: string;
// }

// const ROLE_KEY = "3c95e1f2a6b8d740c9e3812f5d7694b0a2c8157e943fd6802b5e9c71m4a3h8p9";
// const API_BASE = "https://api.air1bet.com/bonus";

// const BonusRedemption: React.FC = () => {
//   const [users, setUsers] = useState<User[]>([]);
//   const [redeemList, setRedeemList] = useState<RedeemBonus[]>([]);
//   const [selectedUser, setSelectedUser] = useState<User | null>(null);
//   const [searchTerm, setSearchTerm] = useState<string>('');
//   const [amount, setAmount] = useState<string>('');
//   const [loading, setLoading] = useState<boolean>(false);
//   const [createLoading, setCreateLoading] = useState<boolean>(false);
//   const [error, setError] = useState<string | null>(null);
//   const [success, setSuccess] = useState<string | null>(null);
//   const [showDropdown, setShowDropdown] = useState<boolean>(false);

//   const headers = {
//     "role-key": ROLE_KEY,
//     "Content-Type": "application/json"
//   };

//   const fetchUsers = async (): Promise<void> => {
//     try {
//       const response = await fetch(`${API_BASE}/users`, { headers });
//       const data: User[] = await response.json();
//       setUsers(data);
//     } catch (error) {
//       console.error('Error fetching users:', error);
//       setError('Failed to load users. Please try again.');
//     }
//   };

//   const fetchRedeemList = async (): Promise<void> => {
//     setLoading(true);
//     setError(null);
//     try {
//       const response = await fetch(`${API_BASE}/redeem-bonus`, { headers });
//       const data: RedeemBonus[] = await response.json();
//       const sortedData = [...data].sort((a, b) => 
//         new Date(b.createdat).getTime() - new Date(a.createdat).getTime()
//       );
//       setRedeemList(sortedData);
//     } catch (error) {
//       console.error('Error fetching redeem list:', error);
//       setError('Failed to load redemption list. Please try again.');
//     } finally {
//       setLoading(false);
//     }
//   };

//   const handleSubmit = async (e: React.FormEvent): Promise<void> => {
//     e.preventDefault();
//     if (!selectedUser) return;
    
//     setCreateLoading(true);
//     setError(null);
//     setSuccess(null);
    
//     try {
//       await fetch(`${API_BASE}/redeem-bonus/create`, {
//         method: 'POST',
//         headers,
//         body: JSON.stringify({
//           userid: selectedUser.id,
//           amount: Number(amount)
//         })
//       });
//       setAmount('');
//       setSelectedUser(null);
//       setSearchTerm('');
//       setShowDropdown(false);
//       setSuccess('Bonus redemption created successfully!');
//       fetchRedeemList();
//     } catch (error) {
//       console.error('Error creating bonus:', error);
//       setError('Failed to create bonus redemption. Please try again.');
//     } finally {
//       setCreateLoading(false);
//     }
//   };

//   const filteredUsers = users.filter(user => 
//     user.name.toLowerCase().includes(searchTerm.toLowerCase())
//   );

//   useEffect(() => {
//     fetchUsers();
//     fetchRedeemList();
//   }, []);

//   const handleUserSelect = (user: User) => {
//     setSelectedUser(user);
//     setSearchTerm(user.name);
//     setShowDropdown(false);
//   };

//   const handleSearchChange = (e: React.ChangeEvent<HTMLInputElement>) => {
//     setSearchTerm(e.target.value);
//     setSelectedUser(null);
//     setShowDropdown(e.target.value.length > 0);
//   };

//   const getStatusIcon = (status: string) => {
//     switch(status.toLowerCase()) {
//       case 'pending':
//         return <Clock size={16} className="text-yellow-500" />;
//       case 'completed':
//         return <CheckCircle size={16} className="text-green-500" />;
//       case 'failed':
//         return <XCircle size={16} className="text-red-500" />;
//       default:
//         return <Clock size={16} className="text-gray-500" />;
//     }
//   };

//   const getStatusBadge = (status: string) => {
//     const baseClasses = "inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium gap-1";
//     switch(status.toLowerCase()) {
//       case 'pending':
//         return `${baseClasses} bg-yellow-100 text-yellow-800`;
//       case 'completed':
//         return `${baseClasses} bg-green-100 text-green-800`;
//       case 'failed':
//         return `${baseClasses} bg-red-100 text-red-800`;
//       default:
//         return `${baseClasses} bg-gray-100 text-gray-800`;
//     }
//   };

//   const formatDate = (dateString: string) => {
//     const date = new Date(dateString);
//     return date.toLocaleString('en-US', { 
//       year: 'numeric', 
//       month: 'short', 
//       day: 'numeric',
//       hour: '2-digit',
//       minute: '2-digit'
//     });
//   };

//   return (
//     <div className='ml-0 lg:ml-[256px]'>
//           <div className="min-h-screen bg-gray-50 p-4">
//       <div className="mx-auto max-w-7xl space-y-6">
//         {/* Header */}
//         <div className="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
//           <div className="flex items-center space-x-3">
//             <div className="flex items-center justify-center w-10 h-10 bg-blue-100 rounded-lg">
//               <DollarSign className="w-5 h-5 text-blue-600" />
//             </div>
//             <div>
//               <h1 className="text-2xl font-bold text-gray-900">Bonus Redemption</h1>
//               <p className="text-gray-600">Manage user bonus redemptions</p>
//             </div>
//           </div>
//         </div>

//         {/* Create Form */}
//         <div className="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
//           <div className="border-b border-gray-200 bg-gray-50 px-6 py-4">
//             <div className="flex items-center space-x-3">
//               <UserPlus className="w-5 h-5 text-gray-600" />
//               <h2 className="text-lg font-semibold text-gray-900">Create New Redemption</h2>
//             </div>
//           </div>

//           <div className="p-6">
//             <div className="space-y-6">
//               {error && (
//                 <div className="bg-red-50 border border-red-200 rounded-lg p-4">
//                   <div className="flex items-center space-x-2">
//                     <XCircle className="w-5 h-5 text-red-500" />
//                     <p className="text-red-800 text-sm font-medium">{error}</p>
//                   </div>
//                 </div>
//               )}
              
//               {success && (
//                 <div className="bg-green-50 border border-green-200 rounded-lg p-4">
//                   <div className="flex items-center space-x-2">
//                     <CheckCircle className="w-5 h-5 text-green-500" />
//                     <p className="text-green-800 text-sm font-medium">{success}</p>
//                   </div>
//                 </div>
//               )}

//               <div className="grid grid-cols-1 lg:grid-cols-12 gap-6">
//                 {/* User Search */}
//                 <div className="lg:col-span-5 relative">
//                   <label className="block text-sm font-medium text-gray-700 mb-2">
//                     Select User
//                   </label>
//                   <div className="relative">
//                     <div className="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
//                       <Search className="h-5 w-5 text-gray-400" />
//                     </div>
//                     <input
//                       type="text"
//                       value={searchTerm}
//                       onChange={handleSearchChange}
//                       className="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
//                       placeholder="Search users..."
//                     />
                    
//                     {/* Dropdown with proper z-index */}
//                     {showDropdown && filteredUsers.length > 0 && (
//                       <div className="absolute z-50 mt-1 w-full bg-white border border-gray-200 rounded-lg shadow-lg max-h-60 overflow-auto">
//                         {filteredUsers.map((user) => (
//                           <div
//                             key={user.id}
//                             className="px-4 py-3 hover:bg-gray-50 cursor-pointer border-b border-gray-100 last:border-b-0"
//                             onClick={() => handleUserSelect(user)}
//                           >
//                             <div className="font-medium text-gray-900">{user.name}</div>
//                             <div className="text-sm text-gray-500">ID: {user.id}</div>
//                           </div>
//                         ))}
//                       </div>
//                     )}
//                   </div>
                  
//                   {selectedUser && (
//                     <div className="mt-3 p-3 bg-blue-50 border border-blue-200 rounded-lg">
//                       <div className="flex items-center space-x-2">
//                         <div className="w-2 h-2 bg-blue-500 rounded-full"></div>
//                         <span className="text-sm font-medium text-blue-900">
//                           {selectedUser.name}
//                         </span>
//                       </div>
//                       <p className="text-xs text-blue-600 mt-1">ID: {selectedUser.id}</p>
//                     </div>
//                   )}
//                 </div>

//                 {/* Amount */}
//                 <div className="lg:col-span-4">
//                   <label className="block text-sm font-medium text-gray-700 mb-2">
//                     Amount
//                   </label>
//                   <div className="relative">
//                     <div className="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
//                       <DollarSign className="h-5 w-5 text-gray-400" />
//                     </div>
//                     <input
//                       type="number"
//                       value={amount}
//                       onChange={(e) => setAmount(e.target.value)}
//                       className="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
//                       placeholder="0.00"
//                     />
//                   </div>
//                 </div>

//                 {/* Submit Button */}
//                 <div className="lg:col-span-3 flex items-end">
//                   <button
//                     onClick={handleSubmit}
//                     disabled={!selectedUser || !amount || createLoading}
//                     className="w-full bg-blue-600 hover:bg-blue-700 disabled:bg-gray-300 disabled:cursor-not-allowed text-white py-3 px-6 rounded-lg font-medium transition-colors duration-200 flex items-center justify-center space-x-2"
//                   >
//                     {createLoading ? (
//                       <div className="animate-spin rounded-full h-5 w-5 border-2 border-white border-t-transparent"></div>
//                     ) : (
//                       <>
//                         <UserPlus className="w-5 h-5" />
//                         <span>Create</span>
//                       </>
//                     )}
//                   </button>
//                 </div>
//               </div>
//             </div>
//           </div>
//         </div>

//         {/* Redemption List */}
//         <div className="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
//           <div className="border-b border-gray-200 bg-gray-50 px-6 py-4">
//             <div className="flex items-center justify-between">
//               <div className="flex items-center space-x-3">
//                 <Users className="w-5 h-5 text-gray-600" />
//                 <h2 className="text-lg font-semibold text-gray-900">Redemption History</h2>
//                 <span className="bg-gray-200 text-gray-700 px-2 py-1 rounded-full text-xs font-medium">
//                   {redeemList.length} records
//                 </span>
//               </div>
//               <button
//                 onClick={fetchRedeemList}
//                 disabled={loading}
//                 className="flex items-center space-x-2 px-4 py-2 border border-gray-300 rounded-lg text-sm font-medium text-gray-700 hover:bg-gray-50 transition-colors duration-200"
//               >
//                 <RefreshCw className={`w-4 h-4 ${loading ? 'animate-spin' : ''}`} />
//                 <span>Refresh</span>
//               </button>
//             </div>
//           </div>

//           <div className="overflow-hidden">
//             {loading ? (
//               <div className="flex justify-center items-center py-12">
//                 <div className="animate-spin rounded-full h-8 w-8 border-2 border-blue-600 border-t-transparent"></div>
//               </div>
//             ) : redeemList.length === 0 ? (
//               <div className="text-center py-12">
//                 <Users className="w-12 h-12 text-gray-300 mx-auto mb-4" />
//                 <p className="text-gray-500 text-lg">No redemption records found</p>
//               </div>
//             ) : (
//               <div className="overflow-x-auto">
//                 <table className="min-w-full divide-y divide-gray-200">
//                   <thead className="bg-gray-50">
//                     <tr>
//                       <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
//                         User ID
//                       </th>
//                       <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
//                         Code
//                       </th>
//                       <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
//                         Amount
//                       </th>
//                       <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
//                         Status
//                       </th>
//                       <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
//                         Created
//                       </th>
//                       <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
//                         Updated
//                       </th>
//                     </tr>
//                   </thead>
//                   <tbody className="bg-white divide-y divide-gray-200">
//                     {redeemList.map((item, index) => (
//                       <tr key={index} className="hover:bg-gray-50 transition-colors duration-200">
//                         <td className="px-6 py-4 whitespace-nowrap">
//                           <span className="text-sm font-mono text-gray-900 bg-gray-100 px-2 py-1 rounded">
//                             {item.userid}
//                           </span>
//                         </td>
//                         <td className="px-6 py-4 whitespace-nowrap">
//                           <span className="text-sm font-mono text-gray-900 bg-gray-100 px-2 py-1 rounded">
//                             {item.code}
//                           </span>
//                         </td>
//                         <td className="px-6 py-4 whitespace-nowrap">
//                           <span className="text-sm font-semibold text-gray-900">
//                             ${item.amount}
//                           </span>
//                         </td>
//                         <td className="px-6 py-4 whitespace-nowrap">
//                           <span className={getStatusBadge(item.status)}>
//                             {getStatusIcon(item.status)}
//                             {item.status}
//                           </span>
//                         </td>
//                         <td className="px-6 py-4 whitespace-nowrap">
//                           <div className="flex items-center space-x-2 text-sm text-gray-600">
//                             <Calendar className="w-4 h-4" />
//                             <span>{formatDate(item.createdat)}</span>
//                           </div>
//                         </td>
//                         <td className="px-6 py-4 whitespace-nowrap">
//                           <div className="flex items-center space-x-2 text-sm text-gray-600">
//                             <Calendar className="w-4 h-4" />
//                             <span>{formatDate(item.updatedat)}</span>
//                           </div>
//                         </td>
//                       </tr>
//                     ))}
//                   </tbody>
//                 </table>
//               </div>
//             )}
//           </div>
//         </div>
//       </div>
//     </div>
//       </div>

//   );
// };

// export default BonusRedemption;
import React, { useState, useEffect } from 'react';
import { Search, UserPlus, Users, DollarSign, Calendar, RefreshCw, CheckCircle, Clock, XCircle } from 'lucide-react';

interface User {
  id: string;
  name: string;
}

interface RedeemBonus {
  userid: string;
  code: string;
  amount: number;
  status: string;
  createdat: string;
  updatedat: string;
}

const ROLE_KEY = "3c95e1f2a6b8d740c9e3812f5d7694b0a2c8157e943fd6802b5e9c71m4a3h8p9";
const API_BASE = "https://api.air1bet.com/bonus";

const BonusRedemption: React.FC = () => {
  const [users, setUsers] = useState<User[]>([]);
  const [redeemList, setRedeemList] = useState<RedeemBonus[]>([]);
  const [selectedUser, setSelectedUser] = useState<User | null>(null);
  const [searchTerm, setSearchTerm] = useState<string>('');
  const [amount, setAmount] = useState<string>('');
  const [loading, setLoading] = useState<boolean>(false);
  const [createLoading, setCreateLoading] = useState<boolean>(false);
  const [error, setError] = useState<string | null>(null);
  const [success, setSuccess] = useState<string | null>(null);
  const [showDropdown, setShowDropdown] = useState<boolean>(false);

  const headers = {
    "role-key": ROLE_KEY,
    "Content-Type": "application/json",
    'Authorization': `Bearer ${localStorage.getItem('token')}`
  };

  const fetchUsers = async (): Promise<void> => {
    try {
      const response = await fetch(`${API_BASE}/users`, { headers });
      const data: User[] = await response.json();
      setUsers(data);
    } catch (error) {
      console.error('Error fetching users:', error);
      setError('Failed to load users. Please try again.');
    }
  };

  const fetchRedeemList = async (): Promise<void> => {
    setLoading(true);
    setError(null);
    try {
      const response = await fetch(`${API_BASE}/redeem-bonus`, { headers });
      const data: RedeemBonus[] = await response.json();
      const sortedData = [...data].sort((a, b) => 
        new Date(b.createdat).getTime() - new Date(a.createdat).getTime()
      );
      setRedeemList(sortedData);
    } catch (error) {
      console.error('Error fetching redeem list:', error);
      setError('Failed to load redemption list. Please try again.');
    } finally {
      setLoading(false);
    }
  };

  const handleSubmit = async (e: React.FormEvent): Promise<void> => {
    e.preventDefault();
    if (!selectedUser) return;
    
    setCreateLoading(true);
    setError(null);
    setSuccess(null);
    
    try {
      await fetch(`${API_BASE}/redeem-bonus/create`, {
        method: 'POST',
        headers,
        body: JSON.stringify({
          userid: selectedUser.id,
          amount: Number(amount)
        })
      });
      setAmount('');
      setSelectedUser(null);
      setSearchTerm('');
      setShowDropdown(false);
      setSuccess('Bonus redemption created successfully!');
      fetchRedeemList();
    } catch (error) {
      console.error('Error creating bonus:', error);
      setError('Failed to create bonus redemption. Please try again.');
    } finally {
      setCreateLoading(false);
    }
  };

  const filteredUsers = users.filter(user => 
    user.name.toLowerCase().includes(searchTerm.toLowerCase())
  );

  useEffect(() => {
    fetchUsers();
    fetchRedeemList();
  }, []);

  const handleUserSelect = (user: User) => {
    setSelectedUser(user);
    setSearchTerm(user.name);
    setShowDropdown(false);
  };

  const handleSearchChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    setSearchTerm(e.target.value);
    setSelectedUser(null);
    setShowDropdown(e.target.value.length > 0);
  };

  const getStatusIcon = (status: string) => {
    switch(status.toLowerCase()) {
      case 'pending':
        return <Clock size={16} className="text-yellow-500" />;
      case 'completed':
        return <CheckCircle size={16} className="text-green-500" />;
      case 'failed':
        return <XCircle size={16} className="text-red-500" />;
      default:
        return <Clock size={16} className="text-gray-500" />;
    }
  };

  const getStatusBadge = (status: string) => {
    const baseClasses = "inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium gap-1";
    switch(status.toLowerCase()) {
      case 'pending':
        return `${baseClasses} bg-yellow-100 text-yellow-800`;
      case 'completed':
        return `${baseClasses} bg-green-100 text-green-800`;
      case 'failed':
        return `${baseClasses} bg-red-100 text-red-800`;
      default:
        return `${baseClasses} bg-gray-100 text-gray-800`;
    }
  };

  const formatDate = (dateString: string) => {
    const date = new Date(dateString);
    return date.toLocaleString('en-US', { 
      year: 'numeric', 
      month: 'short', 
      day: 'numeric',
      hour: '2-digit',
      minute: '2-digit'
    });
  };

  return (
      <div className='ml-0 lg:ml-[256px]'>
 <div className="min-h-screen bg-gray-50 p-4">
      <div className="mx-auto max-w-7xl space-y-6">
        {/* Header */}
        <div className="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
          <div className="flex items-center space-x-3">
            <div className="flex items-center justify-center w-10 h-10 bg-blue-100 rounded-lg">
              <DollarSign className="w-5 h-5 text-blue-600" />
            </div>
            <div>
              <h1 className="text-2xl font-bold text-gray-900">Bonus Redemption</h1>
              <p className="text-gray-600">Manage user bonus redemptions</p>
            </div>
          </div>
        </div>

        {/* Create Form */}
        <div className="bg-white rounded-xl shadow-sm border border-gray-200 overflow-visible relative z-10">
          <div className="border-b border-gray-200 bg-gray-50 px-6 py-4">
            <div className="flex items-center space-x-3">
              <UserPlus className="w-5 h-5 text-gray-600" />
              <h2 className="text-lg font-semibold text-gray-900">Create New Redemption</h2>
            </div>
          </div>

          <div className="p-6">
            <div className="space-y-6">
              {error && (
                <div className="bg-red-50 border border-red-200 rounded-lg p-4">
                  <div className="flex items-center space-x-2">
                    <XCircle className="w-5 h-5 text-red-500" />
                    <p className="text-red-800 text-sm font-medium">{error}</p>
                  </div>
                </div>
              )}
              
              {success && (
                <div className="bg-green-50 border border-green-200 rounded-lg p-4">
                  <div className="flex items-center space-x-2">
                    <CheckCircle className="w-5 h-5 text-green-500" />
                    <p className="text-green-800 text-sm font-medium">{success}</p>
                  </div>
                </div>
              )}

              <div className="grid grid-cols-1 lg:grid-cols-12 gap-6">
                {/* User Search */}
                <div className="lg:col-span-5 relative z-20">
                  <label className="block text-sm font-medium text-gray-700 mb-2">
                    Select User
                  </label>
                  <div className="relative">
                    <div className="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                      <Search className="h-5 w-5 text-gray-400" />
                    </div>
                    <input
                      type="text"
                      value={searchTerm}
                      onChange={handleSearchChange}
                      className="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                      placeholder="Search users..."
                    />
                    
                    {/* Dropdown with proper z-index */}
                    {showDropdown && filteredUsers.length > 0 && (
                      <div className="absolute z-50 mt-1 w-full bg-white border border-gray-200 rounded-lg shadow-xl max-h-60 overflow-auto">
                        {filteredUsers.map((user) => (
                          <div
                            key={user.id}
                            className="px-4 py-3 hover:bg-gray-50 cursor-pointer border-b border-gray-100 last:border-b-0"
                            onClick={() => handleUserSelect(user)}
                          >
                            <div className="font-medium text-gray-900">{user.name}</div>
                            <div className="text-sm text-gray-500">ID: {user.id}</div>
                          </div>
                        ))}
                      </div>
                    )}
                  </div>
                  
                  {selectedUser && (
                    <div className="mt-3 p-3 bg-blue-50 border border-blue-200 rounded-lg">
                      <div className="flex items-center space-x-2">
                        <div className="w-2 h-2 bg-blue-500 rounded-full"></div>
                        <span className="text-sm font-medium text-blue-900">
                          {selectedUser.name}
                        </span>
                      </div>
                      <p className="text-xs text-blue-600 mt-1">ID: {selectedUser.id}</p>
                    </div>
                  )}
                </div>

                {/* Amount */}
                <div className="lg:col-span-4">
                  <label className="block text-sm font-medium text-gray-700 mb-2">
                    Amount
                  </label>
                  <div className="relative">
                    <div className="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                      <DollarSign className="h-5 w-5 text-gray-400" />
                    </div>
                    <input
                      type="number"
                      value={amount}
                      onChange={(e) => setAmount(e.target.value)}
                      className="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                      placeholder="0.00"
                    />
                  </div>
                </div>

                {/* Submit Button */}
                <div className="lg:col-span-3 flex items-end">
                  <button
                    onClick={handleSubmit}
                    disabled={!selectedUser || !amount || createLoading}
                    className="w-full bg-blue-600 hover:bg-blue-700 disabled:bg-gray-300 disabled:cursor-not-allowed text-white py-3 px-6 rounded-lg font-medium transition-colors duration-200 flex items-center justify-center space-x-2"
                  >
                    {createLoading ? (
                      <div className="animate-spin rounded-full h-5 w-5 border-2 border-white border-t-transparent"></div>
                    ) : (
                      <>
                        <UserPlus className="w-5 h-5" />
                        <span>Create</span>
                      </>
                    )}
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>

        {/* Redemption List */}
        <div className="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden relative z-0">
          <div className="border-b border-gray-200 bg-gray-50 px-6 py-4">
            <div className="flex items-center justify-between">
              <div className="flex items-center space-x-3">
                <Users className="w-5 h-5 text-gray-600" />
                <h2 className="text-lg font-semibold text-gray-900">Redemption History</h2>
                <span className="bg-gray-200 text-gray-700 px-2 py-1 rounded-full text-xs font-medium">
                  {redeemList.length} records
                </span>
              </div>
              <button
                onClick={fetchRedeemList}
                disabled={loading}
                className="flex items-center space-x-2 px-4 py-2 border border-gray-300 rounded-lg text-sm font-medium text-gray-700 hover:bg-gray-50 transition-colors duration-200"
              >
                <RefreshCw className={`w-4 h-4 ${loading ? 'animate-spin' : ''}`} />
                <span>Refresh</span>
              </button>
            </div>
          </div>

          <div className="overflow-hidden">
            {loading ? (
              <div className="flex justify-center items-center py-12">
                <div className="animate-spin rounded-full h-8 w-8 border-2 border-blue-600 border-t-transparent"></div>
              </div>
            ) : redeemList.length === 0 ? (
              <div className="text-center py-12">
                <Users className="w-12 h-12 text-gray-300 mx-auto mb-4" />
                <p className="text-gray-500 text-lg">No redemption records found</p>
              </div>
            ) : (
              <div className="overflow-x-auto">
                <table className="min-w-full divide-y divide-gray-200">
                  <thead className="bg-gray-50">
                    <tr>
                      <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        User ID
                      </th>
                      <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Code
                      </th>
                      <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Amount
                      </th>
                      <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Status
                      </th>
                      <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Created
                      </th>
                      <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Updated
                      </th>
                    </tr>
                  </thead>
                  <tbody className="bg-white divide-y divide-gray-200">
                    {redeemList.map((item, index) => (
                      <tr key={index} className="hover:bg-gray-50 transition-colors duration-200">
                        <td className="px-6 py-4 whitespace-nowrap">
                          <span className="text-sm font-mono text-gray-900 bg-gray-100 px-2 py-1 rounded">
                            {item.userid}
                          </span>
                        </td>
                        <td className="px-6 py-4 whitespace-nowrap">
                          <span className="text-sm font-mono text-gray-900 bg-gray-100 px-2 py-1 rounded">
                            {item.code}
                          </span>
                        </td>
                        <td className="px-6 py-4 whitespace-nowrap">
                          <span className="text-sm font-semibold text-gray-900">
                            ${item.amount}
                          </span>
                        </td>
                        <td className="px-6 py-4 whitespace-nowrap">
                          <span className={getStatusBadge(item.status)}>
                            {getStatusIcon(item.status)}
                            {item.status}
                          </span>
                        </td>
                        <td className="px-6 py-4 whitespace-nowrap">
                          <div className="flex items-center space-x-2 text-sm text-gray-600">
                            <Calendar className="w-4 h-4" />
                            <span>{formatDate(item.createdat)}</span>
                          </div>
                        </td>
                        <td className="px-6 py-4 whitespace-nowrap">
                          <div className="flex items-center space-x-2 text-sm text-gray-600">
                            <Calendar className="w-4 h-4" />
                            <span>{formatDate(item.updatedat)}</span>
                          </div>
                        </td>
                      </tr>
                    ))}
                  </tbody>
                </table>
              </div>
            )}
          </div>
        </div>
      </div>
    </div>
      </div>
   
  );
};

export default BonusRedemption;