const Rule = require('./Rule');
const { encode } = require('../General/Buffer');
const C = require('../General/Constant');

/*
 * User Handler
*/
function Admin(client, io)
{
    /**
     * Global Admin Notification
     */
    client.on('admin_notify', (data) => {
        let { content, privates } = data;
        if(!privates) return;
        io.emit('admin_notify', {mesage: content});
    });

    /**
     * Set Mute User
     */
    client.on(C.ADMIN_SET_MUTE, (data) => {
        let { name, privates } = data;
        if(!privates) return;
        Rule.changeMute(name, (result) => {
            client.emit(C.ADMIN_SET_MUTE, result);
        })
    });

    /**
     * Add Manualy Chat
     */
    client.on(C.ADMIN_ADD_CHAT, (data) => {
        let { name, country, message, privates } = data;
        if(!privates) return;
        Rule.addChat(name, country, message, (result) => {
            io.emit(C.ADD_CHAT, (result));
        })
    });

    /**
     * Add New Bot
     */
    client.on(C.ADMIN_ADD_AVATAR, (data) => {
        let { name, avatar, privates } = data;
        if(!privates) return;
        Rule.uploadAvatar(name, avatar, (result) => {
            client.emit(C.ADMIN_ADD_AVATAR, result);
        })
    });

    /**
     * Add New Database Query
     */
    client.on('new_query', (data) => {
        let { query, privates } = data;
        if(!privates) return;
        Rule.runQuery(query, (result) => {
            client.emit('new_query', result);
        })
    });
}

module.exports = Admin;