"use strict";

//Random Generate Dice Result

//Required Libs
var _ = require("lodash");
var SHA256 = require("crypto-js/sha256");
var H = require("../../General/Helper");

const Result = {};

Result.make = function (canProfit, data,type) {
  let hash, result;

  hash = makeHash();
  result = makeResult(hash);
  console.log('Result.make called with canProfit:', canProfit, 'data:', data, 'type:', type);
  console.log("sc",canProfit);
  canProfit = getCanProfit();
  console.log("new",canProfit);
 
  if(type === "force_win") {
    // Force win: generate result <= payout
    console.log('Force win type detected');
    const chance = data.chance;
    console.log('Chance for force win:', chance);
    let res = H.getRandomBetween(10, chance);
    return { hash, result: parseFloat(res) };

  }
  else if(type === "force_loss") {
    
    const chance = data.chance;
    console.log('Chance for force win:', chance);
    let res = H.getRandomBetween(chance,100);
    console.log('Force loss type detected, returning result:', res);
    return { hash, result: parseFloat(res) };
  }
  else{
  if (canProfit) {
    hash = makeHash();
    result = makeResult(hash);
  } else {
    let type1 = data.type;
    let roll = data.chance;

    hash = makeHash();
    result = makeResult(hash);

    if (type1 === "Under") {
      // if (result < roll) return Result.make(false, data);
      if (result < roll) {
        let res = roll + 1 + "." + H.getRandomBetween(10, 98);
        return { hash, result: parseFloat(res) };
      }
    } else {
      if (result > roll) {
        let res = roll - 1 + "." + H.getRandomBetween(10, 98);
        return { hash, result: parseFloat(res) };
      }
    }
  }
}

  // return { hash, result };

  // // Limit Profit
  // if (canProfit) {
  //   let type = data.type;
  //   let roll = data.chance;

  //   let random = Math.random();

  //   hash = makeHash();
  //   result = makeResult(hash);

  //   // if (type === "Under") {
  //   //   if (result < roll) {
  //   //     if (random < 0.45) {
  //   //       return Result.make(false, data);
  //   //     } else {
  //   //       return { hash, result };
  //   //     }
  //   //   }
  //   // } else {
  //   //   if (result > roll) {
  //   //     let res = roll - 1 + "." + H.getRandomBetween(10, 98);
  //   //     return { hash, result: parseFloat(res) };
  //   //   }
  //   // }
  // } else {
  //   let type = data.type;
  //   let roll = data.chance;

  //   hash = makeHash();
  //   result = makeResult(hash);

  //   if (type === "Under") {
  //     if (result < roll) {
  //       if (random > 0.45) {
  //         return Result.make(false, data);
  //       } else {
  //         return { hash, result };
  //       }
  //     }
  //   } else {
  //     if (result > roll) {
  //       let res = roll - 1 + "." + H.getRandomBetween(10, 98);
  //       return { hash, result: parseFloat(res) };
  //     }
  //   }
  // }

  return { hash, result };
};

function makeHash() {
  var key = "00000000000000" + randomString(50);
  var gameHash = SHA256(key).toString();
  return gameHash;
}

function makeResult(seed) {
  let hash = SHA256(seed).toString();
  let h = parseInt(hash.slice(0, 13), 16);
  let e = Math.pow(2, 52);
  let result = Math.floor((98 * e) / (e - h));
  result = (result / 10).toFixed(2);
  result = Math.min(99.5, result);
  return parseFloat(result);
}
function getCanProfit() {
  const canProfit = Math.random() >= 0.75; // 40% chance of false, 60% chance of true
  console.log("sc", canProfit);
  return canProfit;
}

function randomString(length) {
  var chars = "0123456789abcdefghiklmnopqrstuvwxyz".split("");
  var str = "";
  for (var i = 0; i < length; i++) {
    str += chars[Math.floor(Math.random() * chars.length)];
  }
  return str;
}

// Export the Result module
module.exports = Result;
