'use strict';

//Random Generate Hash/Result for all games.

//Required Libs
var SHA256 = require("crypto-js/sha256");

const Hash = {}

Hash.make = function(normal = true, type = null) {
	let hash = makeHash();
    let result = makeResult(hash);

    if(!normal)
    {
        if(type === null){
            if(result > 2.00){
                return Hash.make(normal);
            }
        }
    }

	return { hash, result };
}

function makeHash() {
    var key = "00000000000000" + randomString(50);
    var gameHash = SHA256(key).toString()
    return gameHash;
}

function makeResult(seed) {
    let hash =  SHA256(seed).toString();
    let h = parseInt(hash.slice(0, 13), 16);
    let e = Math.pow(2, 52);
    let result = Math.floor((98 * e) / (e - h));
    return (result / 100).toFixed(2);
}

function randomString(length) {
    var chars = '0123456789abcdefghiklmnopqrstuvwxyz'.split('');
    var str = '';
    for (var i = 0; i < length; i++) {
        str += chars[Math.floor(Math.random() * chars.length)];
    }
    return str;
}

// Export the Hash module
module.exports = Hash;