const _ = require('lodash');
const md5 = require('md5');
const Result = require('./Result');
const Rule = require('../Rule');
const UserRule = require('../../Users/Rule');
const Model = require('../../General/Model');
const Socket = require('../../General/Socket');
const { encode } = require('../../General/Buffer');
const H = require('../../General/Helper');
const C = require('../../General/Constant');
const Player = require("./players");
const config = require('../../config')

const houseEdge = config.house;

//Game Object
const Keno = {};

//Required Variables
var gameHash = H.randomString(64), roundTime = 5000,
    gameHistory = [],
    roundNumbers = [],
    gid,
    kenoNum,
    waitingStart,
    startedTime,
    status,
    sha256,
    timeout;

// Players
var player_playing = Player.playerPlaying;
var winner = Player.winner;

/*
 * Waiting Keno
 */
Keno.IdleGame = function (io) {
    sha256 = md5(gameHash);
    gid = H.makeGameID(2);

    //Set Game Status
    status = "waiting";

    //Play Bots
    let currentHour = new Date().getHours();

    UserRule.getBots('keno', currentHour, (result) => {
        if (!result) return;

        if (_.isUndefined(result)) return;

        result.forEach((bot, i) => {
            let id = _.toNumber(bot.id);
            let coin = _.lowerCase(bot.coin);
            let amount = H.getRandomInt(2000) / 100000000;

            if (coin === 'doge')
                amount = H.getRandomInt(10000000000) / 100000000;

            if (coin === 'trx')
                amount = H.getRandomInt(1000000000) / 10000000;

            if (coin === 'usdt' && coin === 'usdp' && coin === 'usdc' && coin === 'tusd' && coin === 'busd')
                amount = H.getRandomInt(1000000000) / 100000000;

            var arr = [];
            for (var i = 0; i < 10; i++) {
                var n = H.getRandomBetween(1, 40);
                arr.push(n)
            }

            let data = {
                numbers: arr,
                coin: coin,
                amount: H.CryptoSet(amount, coin),
                isB: true
            }

            H.wait(H.getRandomBetween(500, 3200)).then(() => {
                Keno.Play(null, io, id, data)
            })
        })
    })

    //Define Starting Time
    waitingStart = new Date();

    //BroadCast Data to Clients
    io.emit(C.WAITING_KENO, encode({
        time: roundTime,
        status: status,
        game_id: gid,
        players: player_playing
    }));

    //Start Game
    H.wait(roundTime).then(() => {
        StartGame(io);
    })
}

/*
 * Starting Game
 */
StartGame = function (io) {
    //Set Game Status
    status = "started";

    //Empty Winners
    winner = [];

    //Boardcast Data to Clients
    io.emit(C.STARTED_KENO, encode({ players: player_playing }));

    startedTime = new Date();

    var result = Result.generateResult(gameHash);

    gameHash = result.hash;
    kenoNum = result.crash;

    //Make a Crash Record     
    Model.query('INSERT INTO crashs(hash, gid) VALUES($1, $2)', [gameHash, gid], function (err, result) {
        if (err) {
            console.log('KENO RECORD ERROR: 39', err)
            return;
        }
    });

    SendNumbers(io, kenoNum);
}

/*
 * Send Numbers
*/
SendNumbers = function (io, res) {
    var JustNum = [];

    var i = 0;
    for (i in res) {
        var n = res[i].num;
        roundNumbers.push(n);
        JustNum.push(n)
    }

    io.emit(C.KENO_AMOUNT, encode({ amount: JustNum }));

    //Bust Game
    H.wait(3000).then(() => {
        numbers = [];
        BustGame(io);
    })
}

/*
 * Busted Game
 */
BustGame = function (io, kenoNum, timeout) {

    //Calculate Winners
    calcWinners();

    var message = {
        winners: winner,
        players: player_playing,
        crash: roundNumbers,
        game_id: gid,
        md5: sha256,
        hash: gameHash
    };

    io.emit(C.BUSTED_KENO, encode(message));

    status = "busted";

    var allPlayers = player_playing.concat(winner);

    var record = message;
    record.time = new Date();
    record.players = allPlayers;
    gameHistory.push(record);

    if (gameHistory.length >= 10)
        gameHistory = _.drop(gameHistory, gameHistory.length - 10);

    /**
     * Update Crash Record
     */
    Model.query("UPDATE crashs SET numbers = $1 WHERE gid = $2", [JSON.stringify(roundNumbers), gid], function (err) {
        if (err) {
            console.log('Error on keno: 168', err);
            return false
        };
    })

    //Clear Players from Queue
    player_playing = [];
    roundNumbers = [];

    //Start Game
    H.wait(roundTime).then(() => {
        Keno.IdleGame(io);
    })
}

/*
 * Calculate User Winners
*/
calcWinners = function () {
    var i = 0;

    for (i in player_playing) {
        var player = player_playing[i];
        var calcWin = [];

        if (_.isUndefined(player.numbers)) return;

        player.numbers.forEach((number, i) => {

            if (_.isUndefined(roundNumbers)) return;

            roundNumbers.forEach((numb, i) => {
                if (parseFloat(number) === parseFloat(numb)) {
                    calcWin.push(numb.numb);
                }
            });
        });

        if (calcWin.length === 0)
            return;

        if (player.numbers.length >= 3) {
            if (calcWin.length !== 3) {
                if (calcWin.length < 3)
                    return;
            }
        }

        let uid = _.toNumber(player.uid);

        // Calculate User profit
        var profit = _.toNumber(player.amount) * parseFloat(calcWin.length) / 3;

        var data = player;
        data.won = profit;
        data.name = player.name;
        winner.push(data);

        //Update Bet Record
        Model.query("UPDATE bets SET profit = $1, result = $2, hash = $3 WHERE gid = $4 AND uid = $5", [H.CryptoSet(profit, player.coin),
        JSON.stringify(roundNumbers), gameHash, gid, uid],
            function (err) {
                if (err) {
                    console.log('Error on updateBetAfterFinish from KENO: 245', err);
                    return false
                };

                //Calculate HouseEdge
                var amount = _.toNumber(player.amount);
                var percent = (houseEdge / 100) * H.CryptoSet(amount, player.coin);
                var calculateHouse = H.CryptoSet(amount - percent);

                var amountAndProfit = profit + _.toNumber(calculateHouse);
                amountAndProfit = H.CryptoSet(amountAndProfit, player.coin);

                UserRule.addBalance(uid, amountAndProfit, player.coin, (newBalance, error) => {
                    if (error) {
                        console.log('Error Ading Balance: 209')
                        return;
                    }

                    let client = Socket.get(uid);

                    // If is bot, return from here
                    if (player.isB === true) {
                        return UserRule.updateProfit(true, true, uid, amountAndProfit, player.coin, (isOk) => { })
                    }

                    UserRule.reduceBankRoll('keno', amountAndProfit, player.coin, (status, err) => {
                        if (err) {
                            console.log('Error reduceBankRoll: 231 keno')
                            return;
                        }

                        UserRule.updateProfit(false, true, uid, amountAndProfit, player.coin, (isOk) => {
                            if (!isOk) {
                                console.log('Error updateProfit: 121 keno')
                                return;
                            }
                            //Send Credit Change to Client
                            H.wait(250).then(() => {
                                if (client) {
                                    client.emit(C.UPDATE_CREDIT, encode({ coin: player.coin, value: newBalance }))
                                }
                            })
                        })
                    })
                })
            });
    }
}

/*
 * Game Status
 */
Keno.Status = function (client) {
    var now = new Date();

    if (status == "waiting") {
        time = roundTime - (now - waitingStart);
    }
    else {
        time = now - startedTime;
    }

    if (status == "waiting") {
        winner = [];
    }

    client.emit(C.STATUS_KENO,
        encode({
            time: time,
            players: player_playing,
            winners: winner,
            crashes: gameHistory,
            status: status,
            md5: sha256
        }));
}

/*
 * Play Game
 */
Keno.Play = function (client, io, id, data) {
    if (status !== 'waiting') {
        if (client !== null) {
            client.emit(C.ERORR_KENO, encode({ uid: id, message: 'Game is Running' }))
        }
        return;
    }

    id = _.toNumber(id);

    //Check if user has in queue ( Security )
    for (var i = 0; i < player_playing.length; i++) {
        var player = player_playing[i];
        if (_.toNumber(player.uid) === id) {
            return console.log('security');
        }
    }

    Rule.CanPlay(id, data, client, 'keno', (status, err) => {
        if (status !== true) {
            if (client !== null)
                return client.emit(C.ERORR_KENO, encode({ uid: id, message: status, code: err }))
        }

        let { token, amount, coin, numbers } = data;

        amount = H.CryptoSet(amount, coin);
        coin = _.lowerCase(coin);

        UserRule.getUserInfo(id, (user) => {
            if (!user) return;

            Model.query('INSERT INTO bets(game, gid, name, uid, coin, amount) VALUES($1, $2, $3, $4, $5, $6)',
                ['keno', gid, user.name, id, coin, amount], function (err, result) {
                    if (err) {
                        console.log('ERROR ON KENO: 335', err);
                        return;
                    }

                    //Reduce Credit
                    UserRule.reduceBalance(id, amount, coin, (newBalance, err) => {

                        //Send Credit Change to Client
                        if (client !== null)
                            client.emit(C.UPDATE_CREDIT, encode({ coin: coin, value: newBalance }));

                        let isBot = false;
                        if (client === null || _.isUndefined(client))
                            isBot = true;

                        UserRule.updateProfit(isBot, false, id, amount, coin, (isOk) => {
                            if (!isOk) {
                                console.log('Error updateProfit: 121')
                                return;
                            }
                            else {
                                var index = findPlayerPlaying(id);

                                var temp = {
                                    session: 'keno',
                                    status: 'playing',
                                    hash: gameHash,
                                    uid: id,
                                    coin: coin,
                                    name: user.name,
                                    amount: amount,
                                    numbers: numbers,
                                    crash: numbers,
                                    index: index,
                                    in: true
                                };

                                player_playing.push(temp);
                                io.emit(C.PLAY_KENO, encode(temp));
                            }
                        })
                    })
                });
        })
    })
}

function findPlayerPlaying(id) {
    var length = player_playing.length, i;
    for (i = 0; i < length; i++) {
        if (player_playing[i].uid == id) {
            return i;
        }
    }
    return -1;
}

/**
 * Export Keno Module
 */
module.exports = Keno;