'use strict';

const _ = require('lodash');
const CryptoJS = require("crypto-js");

//Generate Random Result

const Result = {};

/*
 * Generate Result
*/
Result.generateMines = function (hash, mines) {
    const salt = 'salt waiting to be generated';

    let allNums = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
        19, 20, 21, 22, 23, 24
    ];

    allNums = _.shuffle(allNums)

    var rand = _.drop(allNums, allNums.length - mines)

    const seed = seedGenerator(hash, salt);
    let finalNums = createNums(rand, seed);
    finalNums = createNums(finalNums, seed);
    finalNums = finalNums.map(m => m.num);

    return finalNums;
}

/*
 * Seed Genertator
*/
function seedGenerator(hash, salt) {
    const hmac = CryptoJS.HmacSHA256(CryptoJS.enc.Hex.parse(hash), salt);
    return hmac.toString(CryptoJS.enc.Hex);
}

/*
 * Create Numbers
*/
function createNums(allNums, hash) {
    const nums = [];
    let h = CryptoJS.SHA256(hash).toString(CryptoJS.enc.Hex);
    allNums.forEach((c) => {
        nums.push({
            num: c,
            hash: h
        });
        h = h.substring(1) + h.charAt(0);
    });
    nums.sort(function (o1, o2) {
        if (o1.hash < o2.hash) {
            return -1;
        } else if (o1.hash === o2.hash) {
            return 0;
        } else {
            return 1;
        }
    });
    return nums;
}

// Export the Result module
module.exports = Result;