const _ = require('lodash');
const Rule = require('../Rule');
const Hash = require('../Hash');
const Queue = require('../../General/Queue');
const { encode } = require('../../General/Buffer');
const H = require('../../General/Helper');
const C = require('../../General/Constant');
const { decide } = require('../../gameEngine/GameOutcomeEngine');
class Plinko {
	constructor(io, client, data, id) {
		this.io = io
		this.client = client
		this.data = data
		this.id = _.toNumber(id);
	}

	/*
	   * Send Data To Client
	*/
	emit(data) {
		this.client.emit(C.PLAY_PLINKO, encode(data))
	}

	/*
	 * Intialize Game
	*/
	init() {

		let { command, auto } = this.data;

		switch (command) {
			case 'play':
				return this.play();
			case 'busted':
				return this.busted();
		}
	}

	/*
	 * Play Game
	*/
	play() {
		let self = this;
        console.log('Plinko Play Data:', self.data);
		Rule.CanPlay(self.id, self.data, self.client, 'plinko', (status, err) => {
			if (status !== true) {
				return this.emit({ command: 'error', uid: self.id, message: status, code: err })
			}
        
			Rule.preparePlay(self.client, self.id, 'plinko', self.data, (isOk) => {
				if (!isOk) {
					console.log('Error Plinko Playing: 21');
					return false;
				}

				//Generate Random Hash and Result
				let randomResult = Hash.make();
				let hash = randomResult.hash;

				//Update Queue and Save Result and Hash
				Queue.update(self.id, 'uid', 'hash', hash);

				//Send Play Game
				this.emit({ command: 'play', hash: hash });
			})
		})
	}

	/*
	 * End / Busted Game
	*/
	async busted() {
		let self = this;

		let { bonus } = self.data;

		bonus = parseFloat(bonus);
        
		//Get The Client Game Info
		let info = Queue.getAllBy('uid', self.id)
		console.log(

			'Plinko Busted Info:', info);


		if (!info) {
			console.log('Client Not Playing!', self.id)
			return false;
		}
  
		if (Array.isArray(info)) {
  for (let i = 0; i < info.length; i++) {
    const entry = info[i];

    const hash = entry.hash;
    const amount = _.toNumber(entry.data.amount);
    const result = parseFloat(bonus).toFixed(2);
    console.log('plinko result', result, 'amount', amount);
     const type = await decide(self.id, 'plinko', entry.data.coin);
     console.log('Engine:', type);
    if (result === NaN || result === 'NaN' || _.isNaN(result)) {
      console.log('error on nan bonus');
      continue;
    }

    let profit = 0.00000000;
    let isWinner = false;

    const resultValue = parseFloat(result);
    isWinner = false;
    profit = -amount; // Default: loss

    // 🧮 Game-specific rules
    if (resultValue <= 0.50) {
      isWinner = false;
      profit = -amount / 2;
    } else if (resultValue > 0.50 && resultValue < 1.00) {
      isWinner = false;
      profit = -amount;
    } else if (resultValue == 1.00 ) {
      isWinner = true;
      profit = -amount;
    } else {
      isWinner = true;
      profit = (resultValue* amount) -amount;
	}

    profit = H.CryptoSet(profit, entry.data.coin);
    console.log('Plinko Profit:', profit, 'isWinner:', isWinner);

    Rule.prepareBusted(
      self.client,
      self.io,
      self.id,
      'plinko',
      entry.data,
      profit,
      result,
      hash,
      isWinner,
      (res) => {
        if (res) {
          self.emit({ command: 'busted', profit: profit });
        }
      }
    );
  }
}
	}
}

module.exports = Plinko;