'use strict';

//Random Generate Hash/Result for Roulette.

//Required Libs
var SHA256 = require("crypto-js/sha256");

const Result = {}

Result.make = function () {
    let hash = makeHash();
    let result;
    result = makeResult(hash);
    return { hash, result };
}

function makeHash() {
    var seed = "00000000000000" + randomString(50);
    return SHA256(seed).toString();
}

function makeResult(hash) {
    let numbers = [31, 33, 10, 6, 36, 11, 5, 15, 24, 28, 23, 19, 1, 9, 17, 26, 22, 35, 21, 18, 3, 27, 14, 8, 16, 0, 20, 2, 4, 13, 7, 34, 29, 30, 32, 25, 12];
    return numbers[getRandomInt(numbers.length)];
}

function randomString(length) {
    var chars = '0123456789abcdefghiklmnopqrstuvwxyz'.split('');
    var str = '';
    for (var i = 0; i < length; i++) {
        str += chars[Math.floor(Math.random() * chars.length)];
    }
    return str;
}

function getRandomInt(length) {
    return Math.floor(Math.random() * length);
}

// Export the Result module
module.exports = Result;