"use strict";

//Required Libs
var SHA256 = require("crypto-js/sha256");
var _ = require("lodash");

// Declare Result object
const Result = {};

/*
 * Generate Dice
 */
Result.generateDice = function (canProfit, currentLand) {
  var lastHash = makeHash();
  var gameHash = lastHash != "" ? genGameHash(lastHash) : hash;
  var gameCrash = crashPointFromSeed(
    lastHash != "" ? genGameHash(lastHash) : hash
  );
  lastHash = gameHash;

  //Limit Profit
  // if(!canProfit)
  // {
  //     const danger = [66, 62, 44, 28, 26, 80, 22, 11, 45, 84];
  //     var i = 0, c = [];
  //     for(var i in danger){
  //         let target = danger[i];
  //         let diffrent = currentLand - target;
  //         c.push(diffrent)
  //     }
  //     gameCrash = _.min(c);
  // }

  return { hash: gameHash, result: gameCrash };
};

/*
 * Make Result
 */
function crashPointFromSeed(seed) {
  let hash = genGameHash(seed);
  let h = parseInt(hash.slice(0, 13), 16);
  let e = Math.pow(2, 52);
  let result = Math.floor((98 * e) / (e - h));
  result = (result / 100).toFixed(0);
  var min = Math.min(result, 6);
  return min;
}

/*
 * Make Hash
 */
function makeHash() {
  var key = "00000000000000" + randomString(50);
  var gameHash = SHA256(key).toString();
  return gameHash;
}

/*
 * Ranndom String
 */
function randomString(length) {
  var chars = "0123456789abcdefghiklmnopqrstuvwxyz".split("");
  var str = "";
  for (var i = 0; i < length; i++) {
    str += chars[Math.floor(Math.random() * chars.length)];
  }
  return str;
}

/*
 * Make SHA256
 */
function genGameHash(serverSeed) {
  return SHA256(serverSeed).toString();
}

// Export the Result module
module.exports = Result;
