const _ = require('lodash');
const axios = require('axios');
const pg = require("../Model");
const config = require("../../config");

const Helper = {};

/*
 * Get Settings
 */
Helper.setting = function (key, callback) {
    pg.query(`
        SELECT 
            bots,
            id
        FROM settings 
        WHERE ID = 1
    `, function (err, result) {
        if (err) return console.log('error on getting settings: 15', err);
        if (!_.isUndefined(result.rows)) {
            callback(result.rows[0][key]);
        }
    })
}

/*
 * Get the max int from array
 */
Helper.arrayMax = function (arr) {
    return arr.reduce(function (p, v) {
        return (p > v ? p : v);
    });
}

/*
 * Get the Max string from Array
 */
Helper.arrayMaxString = function (arr) {
    function sortByHigh(input) {
        function r(c) {
            return c ? -c : null;
        }
        return _.sortBy(input, r);
    }

    var add = [], i = 0;

    var count = _.countBy(arr);
    for (i in count) {
        add.push(count[i])
    }
    var sort = sortByHigh(add);
    return sort;
}

/*
 * Write Log
 * @param type : info | debug | error
 */
Helper.log = function (type, data) {
    console.log('LOG:', { type, data })
}

/*
 * Fix 1.5e-7 format number to crypto format
 */
Helper.cryptoFormat = function (x) {
    if (Math.abs(x) < 1.0) {
        var e = parseInt(x.toString().split('e-')[1]);
        if (e) {
            x *= Math.pow(10, e - 1);
            x = '0.' + (new Array(e)).join('0') + x.toString().substring(2);
        }
    } else {
        var e = parseInt(x.toString().split('+')[1]);
        if (e > 20) {
            e -= 20;
            x /= Math.pow(10, e);
            x += (new Array(e + 1)).join('0');
        }
    }
    return parseFloat(x).toFixed(8);
}

// New Method
Helper.CryptoSet = function (val, coin = "BTC") {
    Number.prototype.format = function (n, x, s, c) {
        var re = '\\d(?=(\\d{' + (x || 3) + '})+' + (n > 0 ? '\\D' : '$') + ')',
            num = this.toFixed(Math.max(0, ~~n));

        return (c ? num.replace('.', c) : num).replace(
            new RegExp(re, 'g'),
            '$&' + (s || ',')
        );
    };

    var amount = parseFloat(val);

    if (isNaN(amount))
        return val;
    else
        return Number(amount.format(8, 30, '.', '.')).toFixed(8);
}

/*
 * Make Random String
 */
Helper.randomString = function (length) {
    var chars = '0123456789abcdefghiklmnopqrstuvwxyz'.split('');
    var str = '';
    for (var i = 0; i < length; i++) {
        str += chars[Math.floor(Math.random() * chars.length)];
    }
    return str;
}

/*
 * Make Random Integer
 */
Helper.randomIntger = function (length) {
    var chars = '123456789'.split('');
    var str = '';
    for (var i = 0; i < length; i++) {
        str += chars[Math.floor(Math.random() * chars.length)];
    }
    return str;
}

/*
 * Get Random Int
 */
Helper.getRandomInt = function (length) {
    return Math.floor(Math.random() * length);
}

/*
 * Get Random Integer Between
 */
Helper.getRandomBetween = function (min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

/*
 * Up First Word
 */
Helper.capFirst = function (string) {
    if (string === undefined) return;
    return string.charAt(0).toUpperCase() + string.slice(1);
}

/*
 * Get Current Time
 */
Helper.getCurrentTime = function (now) {
    var hr = now.getHours();
    var min = now.getMinutes();
    hr = (hr < 10) ? '0' + hr : '' + hr;
    min = (min < 10) ? '0' + min : '' + min;
    return hr + ':' + min;
}

/*
 * Get Current Date
 */
Helper.getCurrentDate = function (now) {
    var y = now.getUTCFullYear();
    var m = (now.getUTCMonth() + 1);
    var d = now.getUTCDate();
    return y + "-" + m + "-" + d
}

/*
 * Validate Number
 */
Helper.isValidNumber = function (val) {
    if (_.isUndefined(val)) return false;
    if (val === '') return false;

    if (_.toNumber(val) <= 0) return false;
    if (_.toNumber(val) === 0) return false;
    if (_.toNumber(val) === 0.00000000) return false;

    if (!isNaN(val)) {
        var check = /^[-]?\d+|\d+.$/.test(val);
        if (check) {
            return true;
        }
    }
    return false;
}

/*
 * Make Unique Game ID by Date
 */
Helper.makeGameID = function (add = 0) {
    let current = new Date();
    let date = current.getYear().toString() + current.getUTCMonth().toString() + current.getUTCDay().toString() +
        current.getUTCHours().toString() + current.getUTCMinutes().toString() + current.getUTCSeconds().toString();
    var c = date.substr(5).toString() + Math.floor(Math.random() * 100);
    return parseFloat(c) + add;
}

/*
 * Get Only Name from String
 */
Helper.baseName = function (str) {
    return _.toString(_.reverse(_.split(str, '.'))[0]);
}

/*
 * Set TimeOut with Promise
 */
Helper.wait = (ms) => new Promise(resolve => setTimeout(resolve, ms))

module.exports = Helper;