const _ = require("lodash");
const axios = require("axios");
const config = require("../../config");

const Market = {};

const Rate = Object.create(null);

/**
 * Get the price rate from market object
 */
Market.rate = function () {
  return Rate;
};

/**
 * Update from market price rate
 */
// Market.update = function () {
//   axios({  headers:{
//     "Access-Control-Allow-Origin": "*",
//     "Access-Control-Allow-Methods":"*"
//   },
   
//     url: "https://pro-api.coinmarketcap.com/v1/cryptocurrency/listings/latest",
//     method: "GET",
//     headers: {
//       "X-CMC_PRO_API_KEY": config.COIN_MARKET_API,
//     },
//   }).then(function (req) {
//     var res = req.data;
//     var i = 0;
//     var data = res.data;
//     for (i in data) {
//       var b = data[i];
//       var coin = b.symbol;
//       if (
//         coin === "INR"||
//         coin === "BTC" ||
//         coin === "ETH" ||
//         coin === "LTC" ||
//         coin === "DOGE" ||
//         coin === "XRP" ||
//         coin === "USDT" ||
//         coin === "BNB" ||
//         coin === "BCH" ||
//         coin === "TRX" ||
//         coin === "ADA" ||
//         coin === "TUSD" ||
//         coin === "NEXO" ||
//         coin === "BUSD" ||
//         coin === "USDC" ||
//         coin === "MKR" ||
//         coin === "USDP" ||
//         coin === "MATIC" ||
//         coin === "SHIB"
        
//       ) {
//         var price = b["quote"]["USD"]["price"];
//         Rate[coin] = price;
//       }
//     }
//   });
// };
/**
 * Update from market price rate using CoinGecko API
 */
Market.update = function () {
  const coinIds = {
    'BTC': 'bitcoin',
    'ETH': 'ethereum', 
    'LTC': 'litecoin',
    'DOGE': 'dogecoin',
    'XRP': 'ripple',
    'USDT': 'tether',
    'BNB': 'binancecoin',
    'BCH': 'bitcoin-cash',
    'TRX': 'tron',
    'ADA': 'cardano',
    'TUSD': 'true-usd',
    'NEXO': 'nexo',
    'BUSD': 'binance-usd',
    'USDC': 'usd-coin',
    'MKR': 'maker',
    'USDP': 'paxos-standard',
    'MATIC': 'matic-network',
    'SHIB': 'shiba-inu'
  };

  const ids = Object.values(coinIds).join(',');
  
  axios({
    url: `https://api.coingecko.com/api/v3/simple/price?ids=${ids}&vs_currencies=usd`,
    method: "GET",
    timeout: 10000
  })
  .then(function (req) {
    const data = req.data;
     console.log(data);
    Object.keys(coinIds).forEach(symbol => {
      const coinId = coinIds[symbol];
      if (data[coinId] && data[coinId].usd) {
        Rate[symbol] = data[coinId].usd;
      }
    });
    
    console.log('[INFO] Exchange rates updated successfully from CoinGecko');
  })
  .catch(function (error) {
    console.error('[ERROR] Failed to fetch conversion rates:', error.message);
  });
};
/**
 * Update from market price rate For Development Mode
 */
Market.dummyUpdate = function () {
  let api = "http://localhost:3000/ticker.json";
  axios({  headers:{
    "Access-Control-Allow-Origin": "*",
    "Access-Control-Allow-Methods":"*"
  },
    url: api,
    method: "GET",
  }).then(function (req) {
    var res = req.data;
    Object.keys(res).forEach(function (coin, key) {
      let val = res[coin];
      Rate[coin] = parseFloat(val);
    });
  });
};

module.exports = Market;
