const PostgresConnector = require( '@deepstream/storage-postgres' );

const settings = {
  user: 'postgres',
  database: 'test',
  password: '',
  host: 'localhost',
  port: 5432
}

const connector = new PostgresConnector( settings )

// start connector
connector.init()

connector.on( 'ready', ()=>{
    console.log('ready')
    connector.subscribe( event =>{
        //event will be a map of event and table for CREATE_TABLE and DESTROY_TABLE
        // { event: 'CREATE_TABLE', table: 'some-table' })
        // or of event, table and key for INSERT, UPDATE AND DELETE, e.g.
        // { event: 'INSERT', table: 'some-table', key: 'some-key' }
    }, err => { if( err ) throw err; })

    //subscriptions can be removed
    connector.unsubscribe(( err )=>{ /* done */ })

    // the connector also comes with a facility to get a map of all tables and the numbers of items within
    connector.getSchemaOverview(( err, result ) => {
        /* result will be e.g.
        {
            'some-table': 2,
            'some-other-table': 1,
            'new-table': 1,
            'table-a': 2,
            'table-b': 2
        }
        */
    })
})


module.exports = connector;