const _ = require('lodash');
const crypto = require('crypto');
const RedisMiddleware = require('../Model/RedisMiddleware');

const Queue = {

    q: [],

    /*
     * Get All Queue Jobs
    */
    get: function () {
        return this.q;
    },

    /*
     * Add a Job
    */
    add: function (key, obj) {
        key = crypto.createHash('sha1').update(key.toString()).digest('hex');
        RedisMiddleware.set(key, 1 * 60, obj, (result) => { })
        return true;
    },

    /*
     * Get All Target Queue Jobs
    */
    getAll: function (key) {
        let uniqueArray = [];

        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i][key] !== undefined) {
                uniqueArray.push(this.q[i]);
            }
        }
        return uniqueArray;
    },

    /*
     * Get All Target Queue Jobs with key and val
    */
    getAllBy: function (key, val) {
        let uniqueArray = [];

        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i][key] === val) {
                uniqueArray.push(this.q[i]);
            }
        }
        return uniqueArray;
    },

    /*
     * Get a Target Queue Job
    */
    getOne: function (key, callback) {
        key = crypto.createHash('sha1').update(key.toString()).digest('hex');
        RedisMiddleware.get(key, (result) => {
            if (!_.isNull(result)) {
                callback(result)
            }
            else {
                callback(false)
            }
        })
    },

    /*
     * Update a Key of Target Job
    */
    update: function (search, key, index, val) {
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i][key] === search) {
                this.q[i][index] = val;
            }
        }
    },

    /*
     * Add a Key to Target Job
    */
    addTo: function (key, search, newKey, val) {
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i][key] === search) {
                this.q[i][newKey] = val;
            }
        }
    },

    /*
     * Remove a Job
    */
    remove: function (key) {
        key = crypto.createHash('sha1').update(key.toString()).digest('hex');
        RedisMiddleware.del(key, (result) => { })
    },

    /*
     * Clear All Target Jobs in Session
    */
    clearSession: function (session) {
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i].session === session) {
                this.q.splice(i, 1); i--;
            }
        }
    },

    /*
     * Exists Job by Uid
    */
    exists: function (key, callback) {
        key = crypto.createHash('sha1').update(key.toString()).digest('hex');
        RedisMiddleware.get(key, (result) => {
            if (!_.isNull(result)) {
                callback(true)
            }
            else {
                callback(false)
            }
        })
    }
};

/* Export Queue Module */
module.exports = Queue;