const Queue = {

    q: [],

    /*
     * Start Queue
    */
    Idle: function () {
        // this.q.start();
        // this.q.emit('start')
    },

    /*
     * Get All Queue Jobs
    */
    get: function () {
        return this.q;
    },

    /*
     * Add a Job
    */
    add: function (obj) {
        this.q.push(obj);
    },

    /*
     * Clear a Job
    */
    clear: function (id) {
    },

    /*
     * Get All Target Queue Jobs
    */
    getAll: function (key) {
        let uniqueArray = [];

        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i][key] !== undefined) {
                uniqueArray.push(this.q[i]);
            }
        }
        return uniqueArray;
    },

    /*
     * Get All Target Queue Jobs with key and val
    */
    getAllBy: function (key, val) {
        let uniqueArray = [];

        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i][key] === val) {
                uniqueArray.push(this.q[i]);
            }
        }
        return uniqueArray;
    },

    /*
     * Get a Target Queue Job
    */
    getOne: function (key, val) {
        console.log('Queue Get One:', key, val);
        
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i][key] === val) {
                console.log('Checking:', this.q[i][key], '===', val);
                return this.q[i];
            }
        }
        return false;
    },

    /*
     * Update a Key of Target Job
    */
    update: function (search, key, index, val) {
        console.log('Queue Update:', search, key, index, val);
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i][key] === search) {
                this.q[i][index] = val;
            }
        }
    },

    /*
     * Add a Key to Target Job
    */
    addTo: function (key, search, newKey, val) {
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i][key] === search) {
                this.q[i][newKey] = val;
            }
        }
    },

    /*
     * Remove a Job
    */
    remove: function (name, val) {
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i][name] === val) {
                this.q.splice(i, 1); i--;
            }
        }
    },

    /*
     * Clear All Target Jobs in Session
    */
    clearSession: function (session) {
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i].session === session) {
                this.q.splice(i, 1); i--;
            }
        }
    },

    /*
     * Exists Job by Uid
    */
    exists: function (uid) {
        let has = false;
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i].uid === parseFloat(uid)) {
                has = true;
            }
        }
        return has;
    }
};

/* Export QueueManager Module */
module.exports = Queue;