const _ = require("lodash");
const Queue = require("../General/Queue");
const C = require("../General/Constant");
const H = require("../General/Helper");
const { encode } = require("../General/Buffer");
const UserRule = require("../Users/Rule");
const Exchange = require("./Exchange");
const Evo = require("./API/evo");
const config = require("../config");

const houseEdge = config.house;

const Rule = {};

/*
 * Prepare Play Game
 * @param id | user id
 * @pram game | game id
 */
Rule.preparePlay = function (id, game, coin, client, callback) {
  UserRule.getNameById(id, (name, err) => {
    if (err) {
      return console.log("Error ON Slots Rule: preparePlay");
    }
    Evo.register(name, "USD", (user_id) => {
      if (!user_id) return;

      user_id = _.toNumber(user_id);

      UserRule.updateUserSlot(id, user_id, coin, (err) => {
        if (err === null) return console.log("updateUserSlot Error");

        UserRule.getClientCoinCredit(id, coin, (amount) => {
          Exchange.cryptoToUsd_OLD(amount, coin, false, (usd) => {
            if (_.isNaN(usd)) {
              H.log("info", `cryptoToUsd error is nan usd: ${usd}`);
              console.log(`cryptoToUsd error is nan usd: ${usd}`);
              return;
            }

            if (usd === null) {
              H.log("info", `cryptoToUsd error is null usd: ${usd}`);
              console.log(`cryptoToUsd error is null usd: ${usd}`);
              return;
            }

            Evo.deposit(user_id, usd, "USD", () => {
              Evo.getLink(user_id, game, (link) => {
                Queue.remove("user_id", user_id);
                // Add Client To Queue
                Queue.add({ user_id, client });
                return callback(link);
              });
            });
          });
        });
      });
    });
  });
};

/*
 * Player Winner
 */
Rule.winner = function (user_id, betUsd, winUsd, roundInfo, game, gid) {
  UserRule.getUserBySlotId(user_id, (user) => {
    if (user === null) return console.log("error on winner: 1", user);

    let { id, slot_coin, name } = user;
    if (!id && !slot_coin && !name) return;

    slot_coin = _.lowerCase(slot_coin);

    Exchange.usdToCrypto(betUsd, slot_coin, (bet) => {
      if (bet === null) return;

      Exchange.usdToCrypto(winUsd, slot_coin, (win) => {
        if (win === null) return;

        bet = _.toNumber(bet);
        win = _.toNumber(win);

        let profit = win;

        var percent = (houseEdge / 100) * H.CryptoSet(bet);
        var calculateHouse = H.CryptoSet(bet - percent);

        var amountAndProfit = profit + _.toNumber(calculateHouse);
        amountAndProfit = H.CryptoSet(amountAndProfit);

        UserRule.addBalance(id, amountAndProfit, slot_coin, (res, error) => {
          if (error) {
            return console.log("Error ON Slots Rule: winner 1");
          } else {
            //Update User Profit
            UserRule.updateProfit(false, true, id, win, slot_coin, (ress) => {
              let queue = Queue.getOne("user_id", user_id);
              var client = queue.client;

              if (queue) {
                var newBalance = H.CryptoSet(res);

                //Send Credit Change to Client
                client.emit(
                  C.UPDATE_CREDIT,
                  encode({ coin: slot_coin, value: newBalance })
                );
              }

              //Add round info
              UserRule.addSlotInfo(
                id,
                roundInfo,
                game,
                gid,
                slot_coin,
                bet,
                win,
                (err) => {
                  let data = {
                    profit: H.CryptoSet(profit),
                    amount: H.CryptoSet(bet),
                    name: name,
                    direct: true,
                    gid: gid,
                    uid: id,
                    created: Date.now(),
                    coin: slot_coin,
                    game: game,
                  };
                  H.wait(1000).then(() => {
                    if (queue) client.emit(C.ADD_SLOT_BET, encode(data));
                  });
                }
              );
            });
          }
        });
      });
    });
  });
};

/*
 * Player Lost
 */
Rule.lost = function (user_id, betUsd, roundInfo, game, gid) {
  console.log("lost", betUsd);
  UserRule.getUserBySlotId(user_id, (user) => {
    if (user === null) return console.log("error on lost: 1", user);

    let { id, slot_coin, name } = user;

    if (!id && !slot_coin && !name) return;

    slot_coin = _.lowerCase(slot_coin);

    Exchange.usdToCrypto(betUsd, slot_coin, (bet) => {
      if (bet === null) return;

      bet = _.toNumber(bet);

      UserRule.reduceBalance(id, bet, slot_coin, (res, error) => {
        if (error) {
          return console.log("Error ON Slots Rule: player lost 1");
        } else {
          //Update User Profit
          UserRule.updateProfit(false, false, id, bet, slot_coin, (ress) => {
            let queue = Queue.getOne("user_id", user_id);

            var client = queue.client;
            var newBalance = H.CryptoSet(res);

            if (queue) {
              //Send Credit Change to Client
              client.emit(
                C.UPDATE_CREDIT,
                encode({ coin: slot_coin, value: newBalance })
              );
            }

            //Add round info
            UserRule.addSlotInfo(
              id,
              roundInfo,
              game,
              gid,
              slot_coin,
              bet,
              0,
              (err) => {
                let data = {
                  profit: H.CryptoSet(0),
                  amount: H.CryptoSet(bet),
                  name: name,
                  direct: true,
                  gid: gid,
                  created: Date.now(),
                  coin: slot_coin,
                  uid: id,
                  game: game,
                };
                H.wait(1000).then(() => {
                  if (queue) client.emit(C.ADD_SLOT_BET, encode(data));
                });
              }
            );
          });
        }
      });
    });
  });
};

//Export Rule Module
module.exports = Rule;
