const crypto = require('crypto');

class IDGenerator {
  generateUniqueId(length = 6) {
    return crypto.randomBytes(length).toString('hex').toUpperCase();
  }

  generateClubId() {
    return this.generateUniqueId(5);
  }

  generateAgentCode() {
    return this.generateUniqueId(4);
  }
}

module.exports = new IDGenerator();