const express = require('express');
const router = express.Router();
const pg = require('../General/Model');

// Get crypto deposits with pagination
router.get('/crypto/deposits', async (req, res) => {
    try {
        const {
            page = 1,
            limit = 10,
            status,
            startDate,
            endDate,
            userid,
            chain
        } = req.query;

        let countQuery = `
            SELECT COUNT(*) 
            FROM ccdeposit cd 
            LEFT JOIN users u ON cd.userid = u.id::text 
            WHERE 1=1
        `;
        
        const values = [];
        let valueIndex = 1;

        if (status) {
            countQuery += ` AND cd.status = $${valueIndex}`;
            values.push(status);
            valueIndex++;
        }

        if (startDate) {
            countQuery += ` AND cd.created_at >= $${valueIndex}`;
            values.push(startDate);
            valueIndex++;
        }

        if (endDate) {
            countQuery += ` AND cd.created_at <= $${valueIndex}`;
            values.push(endDate);
            valueIndex++;
        }

        if (userid) {
            countQuery += ` AND cd.userid = $${valueIndex}`;
            values.push(userid);
            valueIndex++;
        }

        if (chain) {
            countQuery += ` AND cd.chain = $${valueIndex}`;
            values.push(chain);
            valueIndex++;
        }

        const countResult = await pg.query(countQuery, values);
        const totalItems = parseInt(countResult.rows[0].count);

        let query = `
            SELECT 
                cd.*,
                u.name as username
            FROM ccdeposit cd
            LEFT JOIN users u ON cd.userid = u.id::text
            WHERE 1=1
        `;

        if (status) query += ` AND cd.status = $1`;
        if (startDate) query += ` AND cd.created_at >= $2`;
        if (endDate) query += ` AND cd.created_at <= $3`;
        if (userid) query += ` AND cd.userid = $4`;
        if (chain) query += ` AND cd.chain = $5`;

        const offset = (parseInt(page) - 1) * parseInt(limit);
        query += ` ORDER BY cd.created_at DESC LIMIT $${valueIndex} OFFSET $${valueIndex + 1}`;
        values.push(parseInt(limit), offset);

        const result = await pg.query(query, values);

        res.json({
            success: true,
            data: result.rows,
            page: parseInt(page),
            limit: parseInt(limit),
            total: totalItems,
            totalPages: Math.ceil(totalItems / parseInt(limit))
        });
    } catch (error) {
        console.error('Error fetching crypto deposits:', error);
        res.status(500).json({
            success: false,
            error: 'Internal server error'
        });
    }
});
// Get crypto deposit stats
router.get('/crypto/stats', async (req, res) => {
  try {
      const stats = await pg.query(`
          SELECT 
              COUNT(*)::integer as total_transactions,
              COALESCE(SUM(amount), 0)::float as total_amount,
              COUNT(CASE WHEN LOWER(status) = 'success' THEN 1 END)::integer as successful_transactions,
              COUNT(CASE WHEN LOWER(status) = 'processing' THEN 1 END)::integer as processing_transactions,
              COUNT(CASE WHEN LOWER(status) = 'failed' THEN 1 END)::integer as failed_transactions
          FROM ccdeposit
      `);

      res.json({
          success: true,
          data: stats.rows[0]
      });
  } catch (error) {
      console.error('Error fetching crypto deposit stats:', error);
      res.status(500).json({
          success: false,
          error: 'Internal server error'
      });
  }
});
router.get('/fiat/deposits', async (req, res) => {
    try {
        const {
            page = 1,
            limit = 10,
            status,
            startDate,
            endDate,
            userid,
            currency,
            provider
        } = req.query;

        let countQuery = `
            SELECT COUNT(*) 
            FROM (
                SELECT id, user_id, currency, status::text AS status, created_at, 'PayIn' AS provider_type
                FROM pay_in_transactions
                UNION ALL
                SELECT id, user_id, currency, status, created_at, 'APay' AS provider_type
                FROM apaydeposits
                UNION ALL
                SELECT deposit_id AS id, user_id, currency, status, created_at, 'Fiat' AS provider_type
                FROM fiat_deposits
                UNION ALL
                SELECT id, uid AS user_id, 'INR' AS currency, status, created_at, 'CricPay' AS provider_type
                FROM cricpaytransactions
            ) combined
            LEFT JOIN users u ON combined.user_id = u.id
            WHERE 1=1
        `;
        
        const values = [];
        let valueIndex = 1;

        if (status !== undefined) {
            countQuery += ` AND combined.status = $${valueIndex}`;
            values.push(status);
            valueIndex++;
        }

        if (startDate) {
            countQuery += ` AND combined.created_at >= $${valueIndex}`;
            values.push(startDate);
            valueIndex++;
        }

        if (endDate) {
            countQuery += ` AND combined.created_at <= $${valueIndex}`;
            values.push(endDate);
            valueIndex++;
        }

        if (userid) {
            countQuery += ` AND combined.user_id = $${valueIndex}`;
            values.push(parseInt(userid));
            valueIndex++;
        }

        if (currency) {
            countQuery += ` AND combined.currency = $${valueIndex}`;
            values.push(currency);
            valueIndex++;
        }

        if (provider) {
            countQuery += ` AND combined.provider_type = $${valueIndex}`;
            values.push(provider);
            valueIndex++;
        }

        const countResult = await pg.query(countQuery, values);
        const totalItems = parseInt(countResult.rows[0].count);

        let query = `
            SELECT 
                combined.*,
                u.name as username
            FROM (
                SELECT 
                    id, user_id, transaction_id, out_trade_no, currency, amount, 
                    pay_amount, merchant_ratio, real_amount, status::text AS status, 
                    pay_type, created_at, updated_at, 'PayIn' AS provider_type,
                    'okpay' AS provider_name
                FROM pay_in_transactions
                UNION ALL
                SELECT 
                    id, user_id, custom_transaction_id AS transaction_id, NULL AS out_trade_no, 
                    currency, amount, NULL AS pay_amount, NULL AS merchant_ratio, 
                    NULL AS real_amount, status, payment_system AS pay_type, 
                    created_at, updated_at, 'APay' AS provider_type,
                    'paykasma' AS provider_name
                FROM apaydeposits
                UNION ALL
                SELECT 
                    deposit_id AS id, user_id, transaction_id, NULL AS out_trade_no, 
                    currency, amount, NULL AS pay_amount, NULL AS merchant_ratio, 
                    NULL AS real_amount, status, 'Fiat' AS pay_type, 
                    created_at, updated_at, 'Fiat' AS provider_type,
                    'inhouse' AS provider_name
                FROM fiat_deposits
                UNION ALL
                SELECT 
                    id, uid AS user_id, transaction_code AS transaction_id, NULL AS out_trade_no,
                    'INR' AS currency, amount, NULL AS pay_amount, NULL AS merchant_ratio,
                    NULL AS real_amount, status, payment_method AS pay_type,
                    created_at, updated_at, 'CricPay' AS provider_type,
                    'cricpay' AS provider_name
                FROM cricpaytransactions
            ) combined
            LEFT JOIN users u ON combined.user_id = u.id
            WHERE 1=1
        `;

        if (status !== undefined) query += ` AND combined.status = $${valueIndex++}`;
        if (startDate) query += ` AND combined.created_at >= $${valueIndex++}`;
        if (endDate) query += ` AND combined.created_at <= $${valueIndex++}`;
        if (userid) query += ` AND combined.user_id = $${valueIndex++}`;
        if (currency) query += ` AND combined.currency = $${valueIndex++}`;
        if (provider) query += ` AND combined.provider_type = $${valueIndex++}`;

        const offset = (parseInt(page) - 1) * parseInt(limit);
        query += ` ORDER BY combined.created_at DESC LIMIT $${valueIndex} OFFSET $${valueIndex + 1}`;
        values.push(parseInt(limit), offset);

        const result = await pg.query(query, values);

        res.json({
            success: true,
            data: result.rows,
            page: parseInt(page),
            limit: parseInt(limit),
            total: totalItems,
            totalPages: Math.ceil(totalItems / parseInt(limit))
        });
    } catch (error) {
        console.error('Error fetching fiat deposits:', error);
       
        res.status(500).json({
            success: false,
            error: 'Internal server error'
        });
    }
});
// router.get('/fiat/deposits', async (req, res) => {
//     try {
//         const {
//             page = 1,
//             limit = 10,
//             status,
//             startDate,
//             endDate,
//             userid,
//             currency,
//             provider
//         } = req.query;

//         let countQuery = `
//             SELECT COUNT(*) 
//             FROM (
//                 SELECT id, user_id, currency, status::text AS status, created_at, 'PayIn' AS provider
//                 FROM pay_in_transactions
//                 UNION ALL
//                 SELECT id, user_id, currency, status, created_at, 'APay' AS provider
//                 FROM apaydeposits
//                 UNION ALL
//                 SELECT deposit_id AS id, user_id, currency, status, created_at, 'Fiat' AS provider
//                 FROM fiat_deposits
//                 UNION ALL
//                 SELECT id, uid AS user_id, 'INR' AS currency, status, created_at, 'CricPay' AS provider
//                 FROM cricpaytransactions
//             ) combined
//             LEFT JOIN users u ON combined.user_id = u.id
//             WHERE 1=1
//         `;
        
//         const values = [];
//         let valueIndex = 1;

//         if (status !== undefined) {
//             countQuery += ` AND combined.status = $${valueIndex}`;
//             values.push(status);
//             valueIndex++;
//         }

//         if (startDate) {
//             countQuery += ` AND combined.created_at >= $${valueIndex}`;
//             values.push(startDate);
//             valueIndex++;
//         }

//         if (endDate) {
//             countQuery += ` AND combined.created_at <= $${valueIndex}`;
//             values.push(endDate);
//             valueIndex++;
//         }

//         if (userid) {
//             countQuery += ` AND combined.user_id = $${valueIndex}`;
//             values.push(parseInt(userid));
//             valueIndex++;
//         }

//         if (currency) {
//             countQuery += ` AND combined.currency = $${valueIndex}`;
//             values.push(currency);
//             valueIndex++;
//         }

//         if (provider) {
//             countQuery += ` AND combined.provider = $${valueIndex}`;
//             values.push(provider);
//             valueIndex++;
//         }

//         const countResult = await pg.query(countQuery, values);
//         const totalItems = parseInt(countResult.rows[0].count);

//         let query = `
//             SELECT 
//                 combined.*,
//                 u.name as username
//             FROM (
//                 SELECT 
//                     id, user_id, transaction_id, out_trade_no, currency, amount, 
//                     pay_amount, merchant_ratio, real_amount, status::text AS status, 
//                     pay_type, created_at, updated_at, 'PayIn' AS provider
//                 FROM pay_in_transactions
//                 UNION ALL
//                 SELECT 
//                     id, user_id, custom_transaction_id AS transaction_id, NULL AS out_trade_no, 
//                     currency, amount, NULL AS pay_amount, NULL AS merchant_ratio, 
//                     NULL AS real_amount, status, payment_system AS pay_type, 
//                     created_at, updated_at, 'APay' AS provider
//                 FROM apaydeposits
//                 UNION ALL
//                 SELECT 
//                     deposit_id AS id, user_id, transaction_id, NULL AS out_trade_no, 
//                     currency, amount, NULL AS pay_amount, NULL AS merchant_ratio, 
//                     NULL AS real_amount, status, 'Fiat' AS pay_type, 
//                     created_at, updated_at, 'Fiat' AS provider
//                 FROM fiat_deposits
//                 UNION ALL
//                 SELECT 
//                     id, uid AS user_id, transaction_code AS transaction_id, NULL AS out_trade_no,
//                     'INR' AS currency, amount, NULL AS pay_amount, NULL AS merchant_ratio,
//                     NULL AS real_amount, status, payment_method AS pay_type,
//                     created_at, updated_at, 'CricPay' AS provider
//                 FROM cricpaytransactions
//             ) combined
//             LEFT JOIN users u ON combined.user_id = u.id
//             WHERE 1=1
//         `;

//         if (status !== undefined) query += ` AND combined.status = $${valueIndex++}`;
//         if (startDate) query += ` AND combined.created_at >= $${valueIndex++}`;
//         if (endDate) query += ` AND combined.created_at <= $${valueIndex++}`;
//         if (userid) query += ` AND combined.user_id = $${valueIndex++}`;
//         if (currency) query += ` AND combined.currency = $${valueIndex++}`;
//         if (provider) query += ` AND combined.provider = $${valueIndex++}`;

//         const offset = (parseInt(page) - 1) * parseInt(limit);
//         query += ` ORDER BY combined.created_at DESC LIMIT $${valueIndex} OFFSET $${valueIndex + 1}`;
//         values.push(parseInt(limit), offset);

//         const result = await pg.query(query, values);

//         res.json({
//             success: true,
//             data: result.rows,
//             page: parseInt(page),
//             limit: parseInt(limit),
//             total: totalItems,
//             totalPages: Math.ceil(totalItems / parseInt(limit))
//         });
//     } catch (error) {
//         console.error('Error fetching fiat deposits:', error);
       
//         res.status(500).json({
//             success: false,
//             error: 'Internal server error'
//         });
//     }
// });
router.get('/fiat/stats', async (req, res) => {
    try {
        const query = `
            SELECT
                COUNT(*)::integer as total_transactions,
                COALESCE(SUM(amount), 0)::float as total_amount,
                COUNT(CASE 
                    WHEN status = '1' OR status IN ('Success', 'Successful', 'Approved') OR
                         (source = 'cricpaytransactions' AND status = 'Successful')
                    THEN 1 END)::integer as successful_transactions,
                COUNT(CASE 
                    WHEN status = '0' OR status = 'Pending' OR 
                         (source = 'cricpaytransactions' AND status IN ('Pending', 'Processing'))
                    THEN 1 END)::integer as processing_transactions,
                COUNT(CASE 
                    WHEN status = '2' OR status IN ('Failed', 'Rejected') OR
                         (source = 'cricpaytransactions' AND status IN ('Failed', 'Rejected', 'Error'))
                    THEN 1 END)::integer as failed_transactions
            FROM (
                SELECT amount, status::text AS status, 'pay_in_transactions' AS source
                FROM pay_in_transactions
                UNION ALL
                SELECT amount, status, 'apaydeposits' AS source
                FROM apaydeposits
                UNION ALL
                SELECT amount, status, 'fiat_deposits' AS source
                FROM fiat_deposits
                UNION ALL
                SELECT amount, status, 'cricpaytransactions' AS source
                FROM cricpaytransactions
            ) combined
        `;
        
        const result = await pg.query(query);
        res.json({
            success: true,
            data: result.rows[0]
        });
    } catch (error) {
        console.error('Error fetching fiat stats:', error);
        res.status(500).json({
            success: false,
            error: 'Internal server error'
        });
    }
});

module.exports = router;