// email.service.js
const nodemailer = require('nodemailer');
const pg = require('../General/Model');
const EmailTemplateService = require('./templet');

class EmailService {
    constructor() {
        this.transporter = nodemailer.createTransport({
            host: "mx3594.syd1.mymailhosting.com",
            port: 465,
            secure: true,
            auth: {
                user: "service@smartbet36.com",
                pass: "Bachubapa1211$"
            },
            logger: true,
            debug: true
        });
    }

    async sendOTPEmail(email, otp, purpose) {
        try {
            console.log(`Sending OTP email to ${email} for ${purpose}...`);

            const templates = {
                register: {
                    title: 'Complete Your Registration',
                    message: 'Use this code to complete your registration:'
                },
                login: {
                    title: 'Login Verification',
                    message: 'Use this code to verify your login:'
                },
                'reset-password': {
                    title: 'Reset Your Password',
                    message: 'Use this code to reset your password:'
                },
                'reset-2fa': {
                    title: 'Reset Your 2FA',
                    message: 'Use this code to reset your two-factor authentication:'
                }
            };

            const template = templates[purpose];

            const info = await this.transporter.sendMail({
                from: "service@smartbet36.com",
                to: email,
                subject: template.title,
                html: EmailTemplateService.getTemplate('otp', {
                    title: template.title,
                    message: template.message,
                    otp
                })
            });

            console.log(`OTP email sent successfully to ${email}. Message ID: ${info.messageId}`);
            return info;
        } catch (error) {
            console.error(`Failed to send OTP email to ${email}:`, error);
            return null;
        }
    }

    async sendGeneralEmail(to, subject, data) {
        try {
            console.log(`Sending general email to ${to} with subject: ${subject}...`);

            const info = await this.transporter.sendMail({
                from: "support@boss707.com",
                to,
                subject,
                html: EmailTemplateService.getTemplate('general', data)
            });

            console.log(`General email sent successfully to ${to}. Message ID: ${info.messageId}`);
            return info;
        } catch (error) {
            console.error(`Failed to send general email to ${to}:`, error);
            return null;
        }
    }

    async sendBulkEmails(emails, subject, data) {
        console.log(`Sending bulk emails to ${emails.length} recipients...`);

        const promises = emails.map(email =>
            this.sendGeneralEmail(email, subject, data)
        );

        const results = await Promise.allSettled(promises);
        
        results.forEach((result, index) => {
            if (result.status === 'fulfilled') {
                console.log(`Email sent successfully to ${emails[index]}`);
            } else {
                console.error(`Failed to send email to ${emails[index]}:`, result.reason);
            }
        });

        return results;
    }
}

module.exports = new EmailService();
