const express = require('express');
const router = express.Router();
const kycController = require('./controller');
const path = require('path');
const fs = require('fs');

// Get KYC status by user ID
router.get('/status/:userId', kycController.getKycStatus);

// Submit KYC information
router.post('/submit', kycController.uploadDocuments, kycController.submitKyc);

// Admin route to update KYC status
router.put('/update-status', kycController.updateKycStatus);

router.get('/admin/applications', kycController.getAllKycApplications);

router.get('/documents/:filename', (req, res) => {
    let { filename } = req.params;
    
    // IMPORTANT: Validate the filename to prevent directory traversal attacks
    if (!filename || filename.includes('..') || filename.includes('/')) {
      return res.status(400).send('Invalid filename');
    }
    
    // Add .png extension if not present
    if (!filename.includes('.')) {
      filename = `${filename}.png`;
    }
    
    const filePath = path.join('/var/www/html/boss707/frontend/uploads/kyc', filename);
    
    // Check if file exists
    fs.access(filePath, fs.constants.F_OK, (err) => {
      if (err) {
        console.error('File access error:', err);
        return res.status(404).send('File not found');
      }
      
      // Set CORS headers to allow image to be displayed in your application
      res.setHeader('Access-Control-Allow-Origin', '*'); // Or specify your domain
      res.setHeader('Access-Control-Allow-Methods', 'GET');
      res.setHeader('Cross-Origin-Resource-Policy', 'cross-origin');
      
      // Set proper content type based on file extension
      const ext = path.extname(filename).toLowerCase();
      let contentType = 'application/octet-stream';
      
      if (ext === '.png') contentType = 'image/png';
      else if (ext === '.jpg' || ext === '.jpeg') contentType = 'image/jpeg';
      else if (ext === '.pdf') contentType = 'application/pdf';
      
      // Set content type
      res.setHeader('Content-Type', contentType);
      
      // Send the file
      res.sendFile(filePath, (err) => {
        if (err) {
          console.error('Error sending file:', err);
          res.status(500).send('Error sending file');
        }
      });
    });
});
module.exports = router;