const pg = require('../../General/Model');


exports.createSession = async (req, res) => {
  const {
    userId,
    loginAt,
    logoutAt = null,
    ipAddress,
    geoLocation = null,
    deviceInfo = null,
    sessionToken = null,
  } = req.body;

  try {
    await pg.query(
      `INSERT INTO user_sessions
        (user_id, login_at, logout_at, ip_address, geo_location, device_info, session_token)
       VALUES ($1,$2,$3,$4,$5,$6,$7)`,
      [userId, loginAt, logoutAt, ipAddress, geoLocation, deviceInfo, sessionToken]
    );
    res.status(201).json({ message: 'Session recorded.' });
  } catch (err) {
    console.error('createSession error:', err);
    res.status(500).json({ error: 'Unable to record session.' });
  }
};

exports.getUserSessions = async (req, res) => {
  const { userId } = req.params;
  try {
    const { rows } = await pg.query(
      `SELECT id, login_at, logout_at, ip_address AS "ipAddress",
              geo_location AS "geoLocation", device_info AS "deviceInfo",
              session_token AS "sessionToken", created_at AS "createdAt"
       FROM user_sessions
       WHERE user_id = $1
       ORDER BY login_at DESC`,
      [userId]
    );
    res.json(rows);
  } catch (err) {
    console.error('getUserSessions error:', err);
    res.status(500).json({ error: 'Unable to fetch sessions.' });
  }
};
