module.exports = io => {
  const site = require("../model/siteconfigmodels");
  const user = require("../model/userconfigmodel");
  const { permittedIds } = require("../model/hierarchyModel");

  const ROOM = { g:"room:global", u:id=>`room:user:${id}` };

  const emitGlobal = cfg       => io.to(ROOM.g).emit("siteConfigUpdated", cfg);
  const emitUser   = (id,cfg)  => io.to(ROOM.u(id)).emit("userConfigUpdated", cfg);

  return {
    async getGlobal(_req,res){ res.json(await site.get()); },

    async updateGlobal(req,res){
      const up = await site.update(req.body);
      emitGlobal(up);
      res.json(up);
    },

    async getUser(req,res){
      const uid = req.params.uid;
      const ids = await permittedIds(req.staff.id, req.staff.level);
      if (!ids.includes(req.staff.level === 0 ? uid : req.staff.id) &&
          !ids.includes(req.staff.level === 0 ? null : uid))
        return res.sendStatus(403);
      res.json(await user.get(uid));
    },

    async updateUser(req,res){
      const uid = req.params.uid;
      const ids = await permittedIds(req.staff.id, req.staff.level);
      if (!ids.includes(req.staff.level === 0 ? uid : req.staff.id) &&
          !ids.includes(req.staff.level === 0 ? null : uid))
        return res.sendStatus(403);
      const up = await user.update(uid, req.body);
      emitUser(uid, up);
      res.json(up);
    }
  };
};
