module.exports = ()=>{
  const r=require('express').Router();
const { protectStaff } = require('../../system/middleware/auth');
  const { permittedStaffIds }=require('../model/hierarchyModel');
  const pg=require('../../General/Model');

  r.get('/users', protectStaff, async (req,res)=>{
    const q=(req.query.q||'').trim()+'%';
    const ids=await permittedStaffIds(req.user.id, req.user.role_level);
    const {rows}=await pg.query(
      `SELECT id,name,email FROM users
        WHERE (parent_staff_id = ANY($1) OR ($2=0 AND parent_staff_id IS NULL))
          AND (name ILIKE $3 OR email ILIKE $3)
        LIMIT 20`,
      [ids, req.user.role_level, q]
    );
    res.json(rows);
  });
  return r;
};
