const db = require('../General/Model');

const filterEnabledGames = async (games) => {
    try {
      // Fetch enabled games from the database
      const enabledGamesQuery = await db.query(
        'SELECT game_id FROM sports_config WHERE enabled = true'
      );
  
      // Extract enabled game IDs and ensure they are strings
      const enabledGameIds = enabledGamesQuery.rows.map(row => row.game_id.toString());
      console.log('Enabled Game IDs:', enabledGameIds);
  
      // Detailed logging and filtering
      const filteredGames = games.filter(game => {
        const gameId = game.id.toString();
        const isEnabled = enabledGameIds.includes(gameId);
        
        console.log('Game Details:', {
          id: game.id,
          name: game.name,
          gameIdType: typeof game.id,
          isEnabled: isEnabled
        });
  
        return isEnabled;
      });
  
      console.log('Filtered Games Full Details:', filteredGames);
      return filteredGames;
    } catch (error) {
      console.error('Game filtering error:', error);
      throw new Error('Error filtering games');
    }
  };

module.exports = { filterEnabledGames };