const axios = require('axios');
const db = require('../General/Model');


const validateSeriesId = async (seriesId) => {
    try {
      const seriesQuery = await db.query(
  `SELECT 
     id,
     game_id,
     game_name,
     enabled,
     created_at,
     updated_at
   FROM sports_config
   WHERE game_id = $1
     AND enabled = true`,
  [seriesId]
);

      return seriesQuery.rows.length > 0;
    } catch (error) {
      console.error('Series ID validation error:', error);
      throw error;
    }
  };

  const getEventListBySeriesId = async (req, res) => {
    try {
      const { sid: seriesId } = req.query;
  
      // Validate series ID is provided
      if (!seriesId) {
        return res.status(400).json({ error: 'Series ID is required' });
      }
  
      // Validate if series ID is enabled (exists and is a valid game_id)
      const isValid = await validateSeriesId(seriesId);
      if (!isValid) {
        console.warn(`Series ID ${seriesId} is not valid or enabled`);
        return res.status(403).json({ error: 'Invalid or disabled series ID', id: seriesId });
      }
  
      // Fetch events from the external API
      const apiResponse = await axios.get(`http://89.116.20.218:8085/api/result/event-list?sid=${seriesId}`, {
        headers: {
          'x-rapidapi-key': process.env.RAPIDAPI_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31',
          'x-rapidapi-host': process.env.RAPIDAPI_HOST ?? 'betfair14.p.rapidapi.com',
          'X-ScoreSwift-Key': process.env.SCORESWIFT_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31'
        }
      });
  
      console.log('Fetched Events:', apiResponse.data);
      res.json(apiResponse.data);
    } catch (error) {
      console.error('Error fetching events:', error);
  
      if (error.response) {
        console.error('Error Response Data:', error.response.data);
        console.error('Error Response Status:', error.response.status);
        return res.status(error.response.status).json(error.response.data);
      }
  
      res.status(500).json({ error: 'Internal server error', details: error.message });
    }
  };

  const getEventDetailsByEventId = async (req, res) => {
    try {
      const { eventid: eventId } = req.query;
  
      // Validate that event ID is provided
      if (!eventId) {
        return res.status(400).json({ error: 'Event ID is required' });
      }
  
      // Fetch event details from the external API
      const apiResponse = await axios.get(`http://89.116.20.218:8085/api/result/event-result?eventid=${eventId}`, {
        headers: {
          'x-rapidapi-key': process.env.RAPIDAPI_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31',
          'x-rapidapi-host': process.env.RAPIDAPI_HOST ?? 'betfair14.p.rapidapi.com',
          'X-ScoreSwift-Key': process.env.SCORESWIFT_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31'
        }
      });
  
      console.log('Fetched Event Details:', apiResponse.data);
      res.json(apiResponse.data);
    } catch (error) {
      console.error('Error fetching event details:', error);
  
      if (error.response) {
        console.error('Error Response Data:', error.response.data);
        console.error('Error Response Status:', error.response.status);
        return res.status(error.response.status).json(error.response.data);
      }
  
      res.status(500).json({ error: 'Internal server error', details: error.message });
    }
  };
  

  module.exports = {
    getEventListBySeriesId,
    getEventDetailsByEventId
  };