const axios = require('axios');

const getMarketOdds = async (req, res) => {
  try {
    const { market_id } = req.query;

    // Validate market ID is provided
    if (!market_id) {
      return res.status(400).json({
        error: 'Market ID(s) are required'
      });
    }

    // Encode market IDs to handle URL special characters
    const encodedMarketIds = encodeURIComponent(market_id);

    // Make request to external API with market ID(s)
    const response = await axios.get(`http://89.116.20.218:8085/api/GetMarketOdds?market_id=${encodedMarketIds}`, {
      headers: {
        'x-rapidapi-key': process.env.RAPIDAPI_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31',
        'x-rapidapi-host': process.env.RAPIDAPI_HOST ?? 'betfair14.p.rapidapi.com',
        'X-ScoreSwift-Key': process.env.SCORESWIFT_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31'
      }
    });

    // Log the fetched market odds
    console.log(`Fetched Market Odds for Market ID(s) ${market_id}:`, response.data);

    // Return the response directly
    res.json(response.data);
  } catch (error) {
    console.error('Market Odds fetch error:', error);

    // Detailed error logging
    if (error.response) {
      console.error('Error Response Data:', error.response.data);
      console.error('Error Response Status:', error.response.status);

      // Pass through the external API's error response
      return res.status(error.response.status).json(error.response.data);
    }

    res.status(500).json({
      error: 'Error fetching market odds',
      details: error.message
    });
  }
};

module.exports = { 
  getMarketOdds 
};