const db = require('../General/Model');

const sportsCheckMiddleware = async (req, res, next) => {
  try {
    // 1) Check if sports are globally enabled
    const sportsConfigQuery = await db.query(
      'SELECT sports FROM siteconfig LIMIT 1'
    );
  
    if (!sportsConfigQuery.rows[0]?.sports) {
      return res.status(403).json({
        error: 'Sports are not activated globally'
      });
    }

    // 2) Guard against missing or empty body for gameId
    if (!req.body || !req.body.gameId) {
      return next();
    }

    // 3) Check if specific game is enabled
    const { gameId } = req.body;
    const gameConfigQuery = await db.query(
      'SELECT enabled FROM sports_config WHERE game_id = $1',
      [gameId]
    );
    console.log(`Game ${gameId} enabled:`, gameConfigQuery.rows[0]?.enabled);
    if (!gameConfigQuery.rows[0]?.enabled) {
      return res.status(403).json({
        error: 'This specific game is not enabled'
      });
    }

    next();
  } catch (error) {
    console.error('Sports check middleware error:', error);
    res.status(500).json({
      error: 'Internal server error during sports configuration check'
    });
  }
};

module.exports = sportsCheckMiddleware;