// routes/staff.js
const router  = require('express').Router();
const { protectStaff } = require('../middleware/auth');
const ctrl    = require('../controllers/staffController');

router.use(protectStaff);

// ─── READ ─────────────────────────────────────────────────
router.get('/tree',     ctrl.getTree);
router.get('/',         ctrl.listStaff);          // staff in your tree
router.get('/players',  ctrl.listPlayers);        // players in your tree

router.get ("/:id/percent-chain",   ctrl.percentChain);   // root ➜ leaf
router.get ("/:id/percent-tree",    ctrl.percentTree);    // full subtree
// ─── CREATE ──────────────────────────────────────────────
router.post('/',        ctrl.createStaff);        // create next-level staff
router.post('/players', ctrl.createPlayer);       // create player
router.patch('/players/:id', ctrl.updatePlayer);       
router.post('/transfer',ctrl.transfer);           // send INR downwards

// ─── UPDATE ──────────────────────────────────────────────
router.patch('/password', ctrl.changePassword);   // self or SuperAdmin
router.patch('/:id',      ctrl.editStaff);        // edit descendant

// ─── DELETE ──────────────────────────────────────────────
router.delete('/:id',     ctrl.deleteStaff);      // delete descendant
router.delete('/players/:id', ctrl.deletePlayer); 
router.get('/:id',       ctrl.getById);

router.get("/metrics/:id",   ctrl.metrics);      // personalised counts
router.get("/analytics/:id", ctrl.analytics);    // personalised 7-day trend
router.post('/patch-bulk-status', ctrl.bulkStatus);
// routes/staff.js
router.get('/transactions', ctrl.transferHistory);
router.get('/rollupStaff/:id', ctrl.rollupAll);    // ALL visible accounts
router.get('/rollup/:id',ctrl.rollupById);   // single account

router.get('/transfers/:id?',     ctrl.listTransfers);
router.get('/transfers/summary',  ctrl.transfersSummary);    // NEW
router.get('/transfers/summary/:id', ctrl.transfersSummaryById); // NEW
router.get('/:id/whatsapp-ref', ctrl.getWhatsappRef);
module.exports = router;
