const pg = require("../General/Model");
const cron = require('node-cron');

// Utility to get current date in 'YYYY-MM-DD' format
const getCurrentDate = () => {
  const today = new Date();
  return today.toISOString().slice(0, 10);
};

// 1. Income Distribution Job - Runs every day at 10:00 PM IST
cron.schedule('30 16 * * *', async () => {
  console.log('Running Income Distribution Job at 10:00 PM IST');

  const client = await pg.connect();
  try {
    const currentDate = getCurrentDate();

    // Fetch all records where incomeDate matches the current date
    const vaultDataQuery = await client.query(`
      SELECT userid, vaultBalance, coin, incomeDate
      FROM vault_pro
      WHERE incomeDate::date = $1
    `, [currentDate]);

    const vaults = vaultDataQuery.rows;

    for (let vault of vaults) {
      const { userid, vaultBalance, coin } = vault;
      const newBalance = vaultBalance + (vaultBalance * 0.01); // Add 1%

      // Update the vaultBalance in the vault_pro table
      await client.query(`
        UPDATE vault_pro
        SET vaultBalance = $1, updatedAt = NOW()
        WHERE userid = $2 AND coin = $3
      `, [newBalance, userid, coin]);

      console.log(`Updated balance for user ${userid}, coin ${coin}: ${newBalance}`);
    }
  } catch (error) {
    console.error('Error running Income Distribution Job:', error.message);
  } finally {
    client.release();
  }
});
