import React from 'react';
import styled, { css, keyframes } from 'styled-components';
import ClaudeIcon from '../../../Icons/Casino';
import GameIcon from '../../../Icons/Game';
import LotteryIcon from '../../../Icons/Lottery';
import RacingIcon from '../../../Icons/RacingIcon';
import { getUID, isMobile } from '../../../Helper';
import { useHistory } from 'react-router-dom';
import { launchGame } from '../../../services/gameLaunchService';
import { useGameLaunch } from '../../../context/gameLaunchContext';

// Click animation keyframes
const clickAnimation = keyframes`
  0% {
    transform: scale(1);
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1), 0 1px 3px rgba(0, 0, 0, 0.08);
  }
  50% {
    transform: scale(0.95);
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
  }
  100% {
    transform: scale(1);
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1), 0 1px 3px rgba(0, 0, 0, 0.08);
  }
`;

// Click animation style
const clickedStyle = css`
  animation: ${clickAnimation} 0.2s ease-out;
`;

const CardGrid = styled.div`
  display: grid;
  grid-template-areas:
    "casino sports sports lottery racing"
    "casino sports sports updown bingo";
  grid-template-columns: 1.4fr 1.4fr 0fr 1fr 1fr;
  gap: 16px;
  padding: 1rem 0.1rem;
  
  @media (max-width: 768px) {
    grid-template-areas:
      "casino casino"
      "sports sports"
      "lottery racing"
      "updown bingo";
    grid-template-columns: repeat(2, 1fr);
  }

  @media (max-width: 480px) {
    grid-template-columns: repeat(2, 1fr);
  }
`;

const Card = styled.div`
  position: relative;
  border-radius: 12px;
  overflow: hidden;
  cursor: pointer;
  padding: ${props => props.$isLarge ? '28px' : '18px'};
  transition: all 0.2s ease;
  background: ${props => props.background};
  height: ${props => props.$isLarge ? '250px' : '117px'};
  ${({ $isClicked }) => $isClicked && clickedStyle}
`;

const Card1 = styled.div`
  position: relative;
  border-radius: 12px;
  overflow: hidden;
  cursor: pointer;
  padding: 10px;
  transition: all 0.2s ease;
  background: ${props => props.background};
  height: 116px;
  width: 177px;
  ${({ isClicked }) => isClicked && clickedStyle}
`;

const CasinoCard = styled(Card)`
  grid-area: casino;
  padding: 1rem 0.8rem;
  background-color: rgb(50, 55, 56);
  background-image: linear-gradient(to right, rgba(115, 198, 196, 0.1), rgba(115, 198, 196, 0.4));
`;

const SportsCard = styled(Card)`
  grid-area: sports;
  padding: 1rem 0.8rem;
  background-color: rgb(50, 55, 56);
  background-image: linear-gradient(to right, rgba(88, 46, 89, 0.3), rgba(88, 46, 89, 0.8));
  box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1), 0 1px 3px rgba(0, 0, 0, 0.08);
`;

const CasinoCard1 = styled(Card1)`
  flex: 1;
  background-color: rgb(50, 55, 56);
  background-image: linear-gradient(to left, rgb(44, 80, 64), transparent 75%);
`;

const SportsCard1 = styled(Card1)`
  flex: 1;
  background-color: rgb(50, 55, 56);
  background-image: linear-gradient(to left, rgb(88, 46, 89), transparent 75%);
`;

const LotteryCard = styled(Card)`
  grid-area: lottery;
  padding: 0.25rem 0.3rem;
  background-color: rgb(50, 55, 56);
  background-image: linear-gradient(to right, rgba(85, 148, 146, 0.8), rgba(66, 83, 48, 0.3) 75%);
  box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1), 0 1px 3px rgba(0, 0, 0, 0.08);
`;

const LotteryCard1 = styled(Card)`
  display: flex;
  justify-content: center;
  align-items: center;
  height: 105px;
  width: 105px;
  background-color: rgb(50, 55, 56);
  background-image: linear-gradient(to left, rgb(66, 83, 48), transparent 75%);
`;

const RacingCard = styled(Card)`
  grid-area: racing;
  padding: 0.25rem 0.3rem;
  background-color: rgb(50, 55, 56);
  background-image: linear-gradient(to right, #4a8482, rgb(80, 65, 48) 75%);
  box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1), 0 1px 3px rgba(0, 0, 0, 0.08);
`;

const RacingCard1 = styled(Card)`
  display: flex;
  justify-content: center;
  align-items: center;
  height: 105px;
  width: 105px;
  background-color: rgb(50, 55, 56);
  background-image: linear-gradient(to left, rgb(80, 65, 48), transparent 75%);
`;

const UpdownCard = styled(Card)`
  grid-area: updown;
  padding: 0.15rem 0.2rem;
  background-color: rgb(50, 55, 56);
  background-image: linear-gradient(to right, #2B6462, rgb(45, 79, 49) 75%);
  box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1), 0 1px 3px rgba(0, 0, 0, 0.08);
`;

const UpdownCard1 = styled(Card)`
  display: flex;
  justify-content: center;
  align-items: center;
  height: 105px;
  width: 105px;
  background-color: rgb(50, 55, 56);
  background-image: linear-gradient(to left, rgb(45, 79, 49), transparent 75%);
`;

const BingoCard = styled(Card)`
  grid-area: bingo;
  padding: 0.25rem 0.3rem;
  background-color: rgb(50, 55, 56);
  background-image: linear-gradient(to right, #3F7C89, rgb(71, 56, 111) 75%);
  box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1), 0 1px 3px rgba(0, 0, 0, 0.08);
`;

const BingoCard1 = styled(Card)`
  display: flex;
  justify-content: center;
  align-items: center;
  height: 105px;
  width: 105px;
  background-color: rgb(50, 55, 56);
  background-image: linear-gradient(to right, #3F7C89, rgb(71, 56, 111) 75%);
  box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1), 0 1px 3px rgba(0, 0, 0, 0.08);
`;

const CardContent = styled.div`
  position: relative;
  height: 100%;
  display: flex;
  flex-direction: column;
  justify-content: flex-start;
`;

const TitleContainer1 = styled.h3`
  display: flex;
  align-items: center;
  gap: 8px;

  @media (max-width: 768px) {
    display: none;
  }
`;

const TitleContainer = styled.h3`
  display: flex;
  align-items: center;
  gap: 8px;
`;

const Title = styled.div`
  color: #ffffff;
  font-size: 24px;
  margin: 0;
  font-weight: 700;
  text-transform: uppercase;
  letter-spacing: 0.5px;
  @media (max-width: 768px) {
    font-size: 14px;
  }
`;

const TitleS = styled.div`
  color: #ffffff;
  font-size: 18px;
  margin: 0;
  font-weight: 700;
  text-transform: uppercase;
  font-family: 'Montserrat', sans-serif !important;
  letter-spacing: 0.5px;
  @media (max-width: 768px) {
    display: none;
  }
`;

const TitleR = styled.div`
  display: none;

  @media (max-width: 768px) {
    display: flex;
    color: #ffffff;
    font-size: 13px;
    margin: -1px auto 0px 9px;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    font-family: 'Montserrat', sans-serif;
    text-align: center;
  }
`;
const TitleS1 = styled.div`
  display: none;

  @media (max-width: 768px) {
    display: flex;
    color: #ffffff;
    font-size: 13px;
    margin: -1px auto 0px 1px;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    font-family: 'Montserrat', sans-serif;
    text-align: center;
  }
`;

const TitleR1 = styled.div`
  display: none;

  @media (max-width: 768px) {
    display: flex;
    color: #ffffff;
    font-size: 13px;
    margin: -1px auto 0px 15px;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    font-family: 'Montserrat', sans-serif;
    text-align: center;
  }
`;

const Description = styled.p`
  color: #fff;
  font-size: ${props => props.isLarge ? '14px' : '14px'};
  margin-top: 130px;
  max-width: ${props => props.isLarge ? '75%' : '75%'};
  line-height: 1.4;
`;

const CardImage = styled.img`
  position: absolute;
  right: ${props => props.isLarge ? '5px' : '-10px'};
  bottom: ${props => props.isLarge ? '-10px' : '-10px'};
  width: ${props => props.isLarge ? '245px' : '240px'};
  height: ${props => props.isLarge ? '245px' : '240px'};
  object-fit: contain;
  transition: transform 0.3s ease;
  
  ${Card}:hover & {
    transform: scale(1.05);
  }
`;

const CardImage1 = styled.img`
  position: absolute;
  right: -10px;
  top: 8px;
  width: 120px;
  height: 120px;
  object-fit: contain;
  transition: transform 0.3s ease;
  ${Card}:hover & {
    transform: scale(1.05);
  }
`;

const CardImageS = styled.img`
  position: absolute;
  right: ${props => props.isLarge ? '5px' : '0px'};
  bottom: ${props => props.isLarge ? '-10px' : '0px'};
  width: 110px;
  height: 110px;
  object-fit: contain;
  transition: transform 0.3s ease;

  ${Card}:hover & {
    transform: scale(1.05);
  }

  @media (max-width: 768px) {
    position: static;
    margin: 0 auto;
    display: block;
    width: 80px;
    height: 70px;
  }
`;

const CardImageSM = styled.img`
  width: 60px;
  height: 60px;
  object-fit: contain;
  transition: transform 0.3s ease;
  position: static;
  margin: -10px auto 0px auto;
  
  ${Card}:hover & {
    transform: scale(1.05);
  }
`;

const GamingCards = () => {
  const { setGameUrl, setIsGameOpen } = useGameLaunch();
  const history = useHistory();
  const [clickedCard, setClickedCard] = React.useState(null);

  const handleCardClick = (cardName, callback) => {
    setClickedCard(cardName);
    callback();
    setTimeout(() => setClickedCard(null), 200);
  };

  const handleSportsClick = async () => {
    try {
      const credits = localStorage.getItem('credit') || '0';
      const coins = localStorage.getItem('coin') || 'INR';

      const id = getUID();
           const gameUrl = await launchGame(
             '92b24e4c25107367a80e0fe1a97c24e4', 
             id, 
             coins,
             credits
           );

      if (gameUrl) {
        setGameUrl(gameUrl);
        setIsGameOpen(true);
      } else {
        console.error('Failed to get game URL');
      }
    } catch (error) {
      console.error('Failed to launch sports game:', error);
    }
  };

  return (
    <>
      {!isMobile() ? (
        <CardGrid>
          <CasinoCard 
            $isLarge 
            $isClicked={clickedCard === 'casino'}
            onClick={() => handleCardClick('casino', () => history.push('/casino'))}
          >
            <CardContent>
              <TitleContainer>
                <ClaudeIcon />
                <Title $isLarge>CASINO</Title>
              </TitleContainer>
              <Description $isLarge>
                Dive into our in-house games, casino and slots
              </Description>
              <div style={{ padding: "10px" }}>
                <CardImage
                  src="/assets/images/casino-bjb.png"
                  alt="Casino"
                  $isLarge
                />
              </div>
            </CardContent>
          </CasinoCard>

          <SportsCard 
            $isLarge 
            $isClicked={clickedCard === 'sports'}
            
            onClick={handleSportsClick}
          >
            <CardContent>
              <TitleContainer>
                <GameIcon />
                <Title $isLarge>Sports</Title>
              </TitleContainer>
              <Description $isLarge>
                Bet on Football, Cricket, NFL, eSports & over 80 sports!
              </Description>
              <div style={{ padding: '40px' }}>
                <CardImage
                  src="/assets/images/bcgames/gamescards/s2.png"
                  alt="Sports"
                  $isLarge
                />
              </div>
            </CardContent>
          </SportsCard>

          <LotteryCard 
            $isClicked={clickedCard === 'lottery'}
            onClick={() => handleCardClick('lottery', () => history.push('/spribe-games'))}
          >
            <CardContent>
              <TitleContainer1>
                <LotteryIcon />
                <TitleS>Spribe</TitleS>
              </TitleContainer1>
              <CardImageS
                src="/assets/images/bccrash.png"
                alt="Lottery"
              />
              <TitleR>Casino</TitleR>
            </CardContent>
          </LotteryCard>

          <RacingCard 
            $isClicked={clickedCard === 'racing'}
            onClick={() => handleCardClick('racing', () => history.push('/live'))}
          >
            <CardContent>
              <TitleContainer1>
                <LotteryIcon />
                <TitleS>Live</TitleS>
              </TitleContainer1>
              <CardImageS
                src="/assets/images/live-card/live-card.png"
                alt="Racing"
              />
              <TitleR>Live</TitleR>
            </CardContent>
          </RacingCard>

          <UpdownCard 
            $isClicked={clickedCard === 'updown'}
            onClick={() => handleCardClick('updown', () => history.push('/pm-slots'))}
          >
            <CardContent>
              <TitleContainer1>
                <ClaudeIcon />
                <TitleS>SLOTS</TitleS>
              </TitleContainer1>
              <CardImageS
                src="/assets/images/bcslots.png"
                alt="Updown"
              />
              <TitleR>SLOTS</TitleR>
            </CardContent>
          </UpdownCard>

          <BingoCard 
            $isClicked={clickedCard === 'bingo'}
            onClick={() => handleCardClick('bingo', () => history.push('/ezugi-games'))}
          >
            <CardContent>
              <TitleContainer1>
                <ClaudeIcon />
                <TitleS>JILI</TitleS>
              </TitleContainer1>
              <CardImageS
                src="/assets/images/live-card/ezugi-live.png"
                alt="Bingo"
              />
              <TitleR>JILI</TitleR>
            </CardContent>
          </BingoCard>
        </CardGrid>
      ) : (
        <>
          <div style={{ display: "flex", gap: '7px', width: '100%' }}>
            <CasinoCard1 
              $isLarge 
              $isClicked={clickedCard === 'casino-mobile'}
              onClick={() => handleCardClick('casino-mobile', () => history.push('/casino'))}
            >
              <CardContent>
                <TitleContainer>
                  <ClaudeIcon />
                  <Title $isLarge>CASINO</Title>
                </TitleContainer>
                <div style={{ padding: "40px" }}>
                  <CardImage1
                    src="/assets/images/casino-bjb.png"
                    alt="Casino"
                    $isLarge
                  />
                </div>
              </CardContent>
            </CasinoCard1>

            <SportsCard1 
              $isLarge 
              $isClicked={clickedCard === 'sports-mobile'}
                     onClick={handleSportsClick}
            >
              <CardContent>
                <TitleContainer>
                  <GameIcon />
                  <Title $isLarge>Sports</Title>
                </TitleContainer>
                <div style={{ padding: '40px' }}>
                  <CardImage1
                    src="/assets/images/bcgames/gamescards/s2.png"
                    alt="Sports"
                    $isLarge
                  />
                </div>
              </CardContent>
            </SportsCard1>
          </div>

          <div style={{ display: "flex", gap: '8.5px', marginTop: '6px' }}>
            <LotteryCard1 
              $isClicked={clickedCard === 'lottery-mobile'}
              onClick={() => handleCardClick('lottery-mobile', () => history.push('/spribe-games'))}
            >
              <CardContent>
                <div>
                  <CardImageSM
                    src="/assets/images/bccrash.png"
                    alt="Lottery"
                  />
                  <TitleS1>Spribe</TitleS1>
                </div>
              </CardContent>
            </LotteryCard1>

            <RacingCard1 
              $isClicked={clickedCard === 'racing-mobile'}
              onClick={() => handleCardClick('racing-mobile', () => history.push('/live'))}
            >
              <CardContent>
                <div>
                  <CardImageSM
                    src="/assets/images/live-card/live-card.png"
                    alt="Racing"
                  />
                  <TitleR1>Live</TitleR1>
                </div>
              </CardContent>
            </RacingCard1>

            <UpdownCard1 
              $isClicked={clickedCard === 'updown-mobile'}
              onClick={() => handleCardClick('updown-mobile', () => history.push('/pm-slots'))}
            >
              <CardContent>
                <div>
                  <CardImageSM
                    src="/assets/images/bcslots.png"
                    alt="Updown"
                  />
                  <TitleR>SLOTS</TitleR>
                </div>
              </CardContent>
            </UpdownCard1>

            <BingoCard1 
              $isClicked={clickedCard === 'bingo-mobile'}
              onClick={() => handleCardClick('bingo-mobile', () => history.push('/ezugi-games'))}
            >
              <CardContent>
                <div>
                  <CardImageSM
                    src="/assets/images/live-card/ezugi-live.png"
                    alt="Bingo"
                  />
                  <TitleR>JILI</TitleR>
                </div>
              </CardContent>
            </BingoCard1>
          </div>
        </>
      )}
    </>
  );
};

export default GamingCards;