import React, { useEffect, useLayoutEffect, useMemo, useState } from 'react';
import styled from 'styled-components';
import { Link, useHistory } from 'react-router-dom';
import { ChevronDown, ChevronUp, Gamepad, OrigamiIcon, SliceIcon } from 'lucide-react';
import { ArrowDownTrayIcon } from '@heroicons/react/24/outline';
import ClaudeIcon from '../../../Icons/Casino';
import GameIcon from '../../../Icons/Game';
import LotteryIcon from '../../../Icons/Lottery';
import TradingIcon from '../../../Icons/Crypto';
import PromotionIcon from '../../../Icons/PromotionIcon';
import VipSvg from '../../../Icons/Vip';
import BonusIcon from '../../../Icons/BonusIcon';
import AffilateIcon from '../../../Icons/AffliateIcon';
import ProvablyFairIcon from '../../../Icons/Provably';
import HeadphoneIcon from '../../../Icons/Support';
import GlobeIcon from '../../../Icons/Glob';
import SkylaSlot from '../../../Icons/SlotsSkyla';
import SkylaLivecasino from '../../../Icons/SkylaLiveCasino';
import ClubIconMember from '../../../Icons/Club';
import { addNewStyle, CRISTP_ID, getUID, wait } from '../../../Helper';
import CrashIcon from '../../../Icons/CrashIcon';
import SlotsIcon from '../../../Icons/SlotsIcon';
import { Android, Download } from '@mui/icons-material';
import { launchGame } from '../../../services/gameLaunchService';
import { useGameLaunch } from '../../../context/gameLaunchContext';
import { useSelector } from 'react-redux';
import Storage from '../../../Storage';

// Custom Android SVG Icon Component
const AndroidIcon = () => (
  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M17.6 12.8C17.6 12.36 17.24 12 16.8 12H15.2C14.76 12 14.4 12.36 14.4 12.8V14.4C14.4 14.84 14.76 15.2 15.2 15.2H16.8C17.24 15.2 17.6 14.84 17.6 14.4V12.8Z"
      fill="currentColor"
    />
    <path
      d="M9.6 12.8C9.6 12.36 9.24 12 8.8 12H7.2C6.76 12 6.4 12.36 6.4 12.8V14.4C6.4 14.84 6.76 15.2 7.2 15.2H8.8C9.24 15.2 9.6 14.84 9.6 14.4V12.8Z"
      fill="currentColor"
    />
    <path
      d="M18.4 9.6H16.8V11.2H18.4C18.84 11.2 19.2 10.84 19.2 10.4C19.2 9.96 18.84 9.6 18.4 9.6Z"
      fill="currentColor"
    />
    <path
      d="M7.2 9.6H5.6C5.16 9.6 4.8 9.96 4.8 10.4C4.8 10.84 5.16 11.2 5.6 11.2H7.2V9.6Z"
      fill="currentColor"
    />
    <path
      d="M16 4.8L17.6 6.4C17.84 6.64 18.24 6.64 18.48 6.4C18.72 6.16 18.72 5.76 18.48 5.52L16.48 3.52C16.32 3.36 16.08 3.2 15.84 3.12C15.6 3.04 15.36 3 15.12 3C14.88 3 14.64 3.04 14.4 3.12C14.16 3.2 13.92 3.36 13.76 3.52L11.76 5.52C11.52 5.76 11.52 6.16 11.76 6.4C12 6.64 12.4 6.64 12.64 6.4L14.24 4.8H16Z"
      fill="currentColor"
    />
    <path
      d="M12 7.2C14.24 7.2 16 8.96 16 11.2V16.8C16 18.56 14.56 20 12.8 20H11.2C9.44 20 8 18.56 8 16.8V11.2C8 8.96 9.76 7.2 12 7.2Z"
      fill="currentColor"
    />
  </svg>
);

const SidebarContainer = styled.div`
  width: ${props => props.$isCollapsed ? '76px' : '234px'};
  height: 100vh;
  background: #03030F;
  position: absolute;
  left: 0;
  top: 64px;
  transition: width 0.3s ease;
  overflow-y: auto;
  color: white;
  padding-top: 56px;
  display: flex;
  z-index:999;
  flex-direction: column;
`;

const MenuSection = styled.div`
  padding: 12px;
  margin-top: -55px;
`;

const MenuSectionS = styled.div`
  padding: 6px 0px;
  width: 100%;
`;

const MenuItem = styled.div`
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 8px 12px;
  text-decoration: none;
  color: #808A94;
  border-radius: ${props => {
    if (props.$accordion) {
      return props.$isAccordionOpen ? '12px 12px 0 0' : '12px'
    }
    return '12px'
  }};
  margin-bottom: 4px;
  background-color: ${props => props.$isActive ? 'rgb(30, 35, 40)' : 'rgb(18, 20, 24)'};
  transition: all 0.2s ease;
  cursor: pointer;

  &:hover {
    background-color: rgb(30, 35, 45) !important;
    color: white;
  }

  ${props => props.$isActive && `
    background-color: rgb(30, 35, 40) !important;
    color: white;
  `}
`;

const BottomMenuItem = styled.div`
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 8px 12px;
  text-decoration: none;
  color: #808A94;
  margin-top: 20px;
  border-radius: ${props => {
    if (props.$accordion) {
      return props.$isAccordionOpen ? '12px 12px 0 0' : '12px'
    }
    return '12px'
  }};
  margin-bottom: 4px;
  background-color: ${props => props.$isActive ? 'rgb(30, 35, 40)' : 'rgb(18, 20, 24)'};
  transition: all 0.2s ease;
  cursor: pointer;

  &:hover {
    background-color: rgb(30, 35, 45) !important;
    color: white;
  }

  ${props => props.$isActive && `
    background-color: rgb(30, 35, 40) !important;
    color: white;
  `}
`;

const MenuItemVip = styled(Link)`
  display: flex;
  align-items: center;
  text-decoration: none;
  color: #808A94;
  width: 100%;
  margin:4px 0px;
  border-radius: 12px;
  padding: 8px 12px;
  background-color: ${props => props.$isActive ? 'rgb(30, 35, 40)' : 'rgb(18, 20, 24)'};
  transition: all 0.2s ease;

  &:hover {
    background-color: rgb(30, 35, 45) !important;
  }

  ${props => props.$isActive && `
    background-color: rgb(30, 35, 40) !important;
  `}
`;

const OuterWrapper = styled.div`
  display: flex;
  align-items: center;
  color: #808A94;
  background-color: rgb(18, 20, 24);
  border-radius: 12px;
  transition: all 0.2s ease;
`;

const IconBgNew = styled.div`
  background-color:  #03030F;
  border-radius: 10px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  padding: 4px;
  transition: background-color 0.2s ease;

  &:hover {
    background-color: #4a5354;
  }
`;

const MenuIcon = styled.div`
  display: flex;
  align-items: center;
  justify-content: center;
  color: ${props => props.$color || 'inherit'};
  transition: color 0.2s ease;

  ${MenuItem}:hover & {
    color: #ffffff;
  }
`;

const VIPSpan = styled.span`
  color: #25E284;
  &:hover {
    color: white !important;
  }
`;

const ClubSpan = styled.span`
  color: white;
  &:hover {
    color: white !important;
  }
`;

const VIPContainer = styled.div`
  display: flex;
  gap: 2px;

  ${MenuItem}:hover &,
  ${MenuItemVip}:hover & ${ClubSpan} {
    color: #f09c06;
  }
`;

const MenuText = styled.span`
  display: ${props => props.$isCollapsed ? 'none' : 'block'};
  font-size: 14px;
  font-weight: bold;
  color: ${props => props.$isActive ? '#f09c06' : 'white'};
  margin-left: 12px;
  transition: color 0.2s ease;

  ${props => props.$isSpecial && `
    color: #25E284;
  `}

  ${MenuItem}:hover & {
    color: white;
  }
`;

const Divider = styled.div`
  height: 1px;
  background-color: #2C2F36;
  margin: 12px 4px;
`;

const ExternalIndicator = styled.div`
  display: ${props => props.isCollapsed ? 'none' : 'flex'};
  align-items: center;
`;

const LeftSection = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
  transition: all 0.2s ease;
`;

const IconBg = styled.div`
  padding: 6px 8px;
  background-color: rgb(18, 20, 24);
  border-radius: 10px;
  transition: background-color 0.2s ease;

  &:hover {
    background-color: #4a5354;
  }
`;

const LogoContainer = styled(Link)`
  display: flex;
  align-items: center;
`;

const Logo = styled.img`
  width: ${props => props.$showFull ? '128px' : '96px'};
  height: auto;
  transition: width 0.3s ease;
`;

const SubMenuContainer = styled.div`
  margin-top: -6px;
  background-color: rgb(18, 20, 24);
  display: ${props => props.$isOpen ? 'block' : 'none'};
  border-bottom-left-radius: 12px;
  border-bottom-right-radius: 12px;
`;

const SubMenuItem = styled(Link)`
  display: flex;
  align-items: center;
  padding: 8px 12px;
  text-decoration: none;
  color: #808A94;
  border-radius: 8px;
  margin-bottom: 4px;
  background-color: ${props => props.$isActive ? 'rgb(30, 35, 40)' : 'rgb(18, 20, 24)'};
  transition: all 0.2s ease;

  &:hover {
    background-color: rgb(30, 35, 45);
    color: #ffffff;
  }
`;

const MenuItemClub = styled(MenuItemVip)`
  color: #f09c06;
margin:4px 0px;
  ${props => props.$isActive && `
    background: linear-gradient(90deg, rgba(255, 215, 0, 0.2), rgba(255, 215, 0, 0)) !important;
    background-color: rgba(255, 215, 0, 0.05) !important;
  `}

  ${MenuText} {
    color: #f09c06 !important;
  }

  ${MenuIcon} {
    color: #f09c06 !important;
  }

  &:hover {
    ${MenuText}, ${MenuIcon} {
      color: #f09c06 !important;
    }
  }
`;

const AppDownloadContainer = styled.div`
  padding: 12px;
  margin-top: auto;
  border-top: 1px solid #2C2F36;
`;

const AppDownloadButton = styled.a`
  display: flex;
  align-items: center;
  padding: 8px 12px;
  text-decoration: none;
  color: #808A94;
  border-radius: 12px;
  background-color: rgb(18, 20, 24);
  transition: all 0.2s ease;
  cursor: pointer;

  &:hover {
    background-color: rgb(30, 35, 45);
    color: white;
  }
`;

const SkylaSidebar = ({ isCollapsed }) => {
  const [activePath, setActivePath] = useState('/');
  const [openAccordions, setOpenAccordions] = useState({});
  const [openSGOriginals, setSGOriginals] = useState(false);
  const [isHovered, setIsHovered] = useState(false);
  const [loaded, setLoaded] = useState(false);
  const [isLogged, setIsLogged] = useState(false);
  const { setGameUrl, setIsGameOpen } = useGameLaunch();
  const [enabledFeatures, setEnabledFeatures] = useState({
    promotions: true,
    vipClub: true,
    clubMembership: true,
    bonus: true,
    affiliate: true,
    Provably: true, 
    casino:true,
    sports: true, // Added for Sports
    spribe: true, // Added for Spribe
    slots: true,  // Added for Slots
    live: true,// Ensure consistent capitalization
});
  const finalState = useSelector((state) => state.finalState.finalState);
  
  useEffect(() => {
   if (finalState && typeof finalState === 'object') {
    setEnabledFeatures(prev => {
        const newState = {
            ...prev,
            affiliate: finalState.affiliate ?? prev.affiliate,
            bonus: finalState.bonus ?? prev.bonus,
            casino: finalState.casino ?? prev.casino,
            clubMembership: finalState.clubmembership ?? prev.clubMembership,
            vipClub: finalState.vipclub ?? prev.vipClub,
            Provably: finalState.provablyfair ?? prev.Provably,
            sports: finalState.sports ?? prev.sports,
            spribe: finalState.spribe ?? prev.spribe,
            slots: finalState.slotsgames ?? prev.slots,
            live: finalState.alllivegames ?? prev.live,
        };
        return newState;
    });
}
}, [finalState]);

  const handleSportsClick = async () => {
    try {
      const credits = localStorage.getItem('credit') || '0';
      const coins = localStorage.getItem('coin') || 'INR';  
      const id = getUID();
      const gameUrl = await launchGame(
        '92b24e4c25107367a80e0fe1a97c24e4', 
        id, 
        coins,
        credits
      );
      if (gameUrl) {
        setGameUrl(gameUrl);
        setIsGameOpen(true);
      } else {
        console.error('Failed to get game URL');
      }
    } catch (error) {
      console.error('Failed to launch sports game:', error);
    }
  };

  useLayoutEffect(() => {
    setOpenAccordions(prev => ({ ...prev }));
  }, [isCollapsed]);

  useEffect(() => {
    const currentPath = window.location.pathname;
    if (currentPath.includes('/sports/markets')) {
      setActivePath('/sports/markets/in-play');
    } else {
      setActivePath(currentPath);
    }
  }, [window.location.pathname]);

  const toggleAccordion = (path) => {
    setOpenAccordions((prevState) => ({
      ...prevState,
      [path]: !prevState[path],
    }));
  };

  // useLayoutEffect(() => {
  //   const token = localStorage.getItem('token');
  //   if (token) {
  //     setIsLogged(!!token)
  //   }

  //   setOpenAccordions(prev => ({ ...prev }));

  //   setEnabledFeatures(prev => ({
  //     ...prev,
  //     clubMembership: !!token
  //   }));
  // }, [isCollapsed]);

  const returnPath = () => {
    return isLogged ? '/club-membership' : '/login';
  }
 // {
    //   id: 1,
    //   icon: <ClaudeIcon />,
    //   text: 'Casino',
    //   path: '/',
    //   accordion: false,
    // },
const menuItems = useMemo(() => {
  const items = [
    {
      id: 1,
      icon: <ClaudeIcon />,
      text: 'Casino',
      path: '/',
      accordion: false,
      isEnabled: enabledFeatures.casino,
    },
    {
      id: 2,
      icon: <GameIcon />,
      text: 'Sports',
      path: '/',
      accordion: false,
      isEnabled: enabledFeatures.sports,
    },
      {
      id: 6,
      icon: <svg width="20" height="20" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
 
  <circle cx="50" cy="50" r="45" fill="#f1a516"/>

 
  <path d="M50 5 A45 45 0 0 1 95 50 L85 45 L95 50 L85 55" fill="#fff"/>
  <path d="M95 50 A45 45 0 0 1 50 95 L55 85 L50 95 L45 85" fill="#fff"/>

  
  <circle cx="50" cy="50" r="20" fill="none" stroke="black" stroke-width="3"/>
  <path d="M35 50 A15 15 0 0 1 65 50 A15 15 0 0 1 35 50" fill="none" stroke="black" stroke-width="3"/>
</svg>,
      text: 'Sports Exchange',
      path: '/sports/markets/in-play',
      accordion: false,
      isEnabled: enabledFeatures.sports,
    },
    // {
    //   id: 3,
    //   icon: <LotteryIcon />,
    //   text: 'Spribe',
    //   path: '/spribe-games',
    //   accordion: false,
    //   isEnabled: enabledFeatures.spribe,
    // },
    {
      id: 4,
      icon: <SlotsIcon />,
      text: 'Slots',
      path: '/pm-slots',
      accordion: false,
      isEnabled: enabledFeatures.slots,
    },
    {
      id: 5,
      icon: <CrashIcon />,
      text: 'Live',
      path: '/live',
      accordion: false,
      isEnabled: enabledFeatures.live,
    },
    
  ];

  const filteredItems = items.filter(item => item.isEnabled);


  return filteredItems;
}, [enabledFeatures]);

  const filteredVipItems = [
    { id: 0, icon: <PromotionIcon />, text: 'Promotions', path: '/promotions', isEnabled: enabledFeatures.promotions },
    { id: 1, icon: <VipSvg />, text: 'VIP Club', path: '/vip-club', color: '#f09c06', isEnabled: enabledFeatures.vipClub },
    // { id: 2, icon: <ClubIconMember />, text: 'Club Membership', path: '/club-membership', color: '#f09c06', isEnabled: enabledFeatures.clubMembership },
    { id: 3, icon: <BonusIcon />, text: 'Bonus', path: '/bonus', isEnabled: enabledFeatures.bonus },
    { id: 4, icon: <AffilateIcon />, text: 'Affiliate', path: '/affiliate', isEnabled: enabledFeatures.affiliate },
    { id: 5, icon: <ProvablyFairIcon />, text: 'Provably Fair', path: '/provably-fair', isEnabled: enabledFeatures.Provably },
].filter(item => item.isEnabled !== false);

  const gameItems = [
    { icon: <ClaudeIcon />, text: 'Crash' },
    { icon: <ClaudeIcon />, text: 'FastParity' },
    { icon: <ClaudeIcon />, text: 'Twist' },
    { icon: <ClaudeIcon />, text: 'Plinko' },
  ];

  const support = () => {
    window.$crisp = [];
    window.CRISP_WEBSITE_ID = CRISTP_ID;

    if (!loaded) {
    
      setLoaded(true);
      const script = document.createElement('script');
      script.src = "https://client.crisp.chat/l.js";
      script.id = "chtt";
      script.async = true;
      document.head.appendChild(script);
    }

    addNewStyle("#crisp-chatbox {display:block !important;}");
    addNewStyle(
      ".crisp-client .cc-kv6t .cc-1xry .cc-ge4v .cc-qqzz .cc-5b24 .cc-19cg {display:none !important;}"
    );

    wait(2000).then(() => {
      const close = document.querySelector(".cc-wdhl");
      if (close === null) return;
      close.addEventListener("click", function (event) {
        addNewStyle("#crisp-chatbox {display:none !important;}");
        document.getElementById("chtt").src = "";
      });
    });
  };

  const history = useHistory();

  // useEffect(() => {
  //   const checkEnabledFeatures = async () => {
  //     const response = await new Promise(resolve =>
  //       setTimeout(() => resolve({
  //         promotions: false,
  //         vipClub: true,
  //         clubMembership: true,
  //         bonus: true,
  //         affiliate: true
  //       }), 1000)
  //     );
  //     setEnabledFeatures(response);
  //   };

  //   checkEnabledFeatures();
  // }, []);

  const handleDownloadAPK = () => {
    window.open('https://your-app-download-url.apk', '_blank');
  };

  return (
    <SidebarContainer $isCollapsed={isCollapsed}>
      <MenuSection>
        {menuItems.map((item) => (
          <React.Fragment key={item.id}>
            <MenuItem
              as={item.text === 'Sports' ? 'div' : Link}
              {...(item.text !== 'Sports' && item.path ? { to: item.path } : {})}
              $accordion={item.accordion}
              $isAccordionOpen={openAccordions[item.path]}
              $isActive={activePath === item.path ||
              
                (item.path === '/sports/markets/in-play' && activePath.includes('/sports/markets'))}
                 isCollapsed={isCollapsed}
              onClick={(e) => {
                if (item.text === 'Sports') {
                  e.preventDefault();
                  handleSportsClick();
                } else if (item.path) {
                  setActivePath(item.path);
                }
              }}
            >
              <div style={{
                width: "100%",
                display: "flex",
                justifyContent: "space-between",
                alignItems: "center"
              }}>
                <LeftSection>
                  <MenuIcon $isCollapsed={isCollapsed} $color={item.color}>
                    {item.icon}
                  </MenuIcon>
                  <MenuText
                    $isActive={activePath === item.path}
                    $isCollapsed={isCollapsed}
                    $color={item.color}
                    $isSpecial={item.text === 'VIP Club'}
                  >
                    {item.text === "VIP Club" ? (
                      <VIPContainer>
                        <VIPSpan>VIP</VIPSpan>
                        <ClubSpan>Club</ClubSpan>
                      </VIPContainer>
                    ) : item.text}
                  </MenuText>
                </LeftSection>
                {item.accordion && !isCollapsed && (
                  <IconBgNew>
                    <MenuIcon $isCollapsed={isCollapsed}>
                      {openAccordions[item.path] ? <ChevronUp size={18} /> : <ChevronDown size={18} />}
                    </MenuIcon>
                  </IconBgNew>
                )}
              </div>
            </MenuItem>
            {!isCollapsed && item.subMenu && openAccordions[item.path] && (
              <SubMenuContainer $isOpen={openAccordions[item.path]}>
                {item.subMenu.length > 0 ? (
                  item.subMenu.map((subItem) => (
                    <SubMenuItem
                      key={subItem.path}
                      to={subItem.path}
                      $isActive={activePath === subItem.path}
                      onClick={() => setActivePath(subItem.path)}
                      onMouseEnter={() => {
                        if (subItem.text === "Originals") setIsHovered(true);
                      }}
                      onMouseLeave={() => setIsHovered(false)}
                    >
                      <LeftSection>
                        <MenuIcon $isCollapsed={false} $color={subItem.color}>
                          {subItem.icon}
                        </MenuIcon>
                        <MenuText $isCollapsed={false}>
                          {subItem.text}
                        </MenuText>
                      </LeftSection>
                    </SubMenuItem>
                  ))
                ) : (
                  <div style={{ "textAlign": "center", padding: "24px" }}>Coming Soon</div>
                )}
              </SubMenuContainer>
            )}
          </React.Fragment>
        ))}
      </MenuSection>

      <div style={{ padding: '8px', display: 'flex', flexDirection: 'column', flex: 1 }}>
        <OuterWrapper>
          <MenuSectionS>
            {filteredVipItems.map((item, index) => (
              <React.Fragment key={item.path}>
                {item.text === 'Club Membership' ? (
                  <MenuItemClub
                    to={item.path}
                    $isActive={activePath === item.path}
                    $isCollapsed={isCollapsed}
                    onClick={() => setActivePath(item.path)}
                  >
                    <LeftSection>
                      <MenuIcon $isCollapsed={isCollapsed}>
                        <ClubIconMember color="gold" />
                      </MenuIcon>
                      <MenuText
                        $isActive={activePath === item.path}
                        $isCollapsed={isCollapsed}
                      >
                        {item.text}
                      </MenuText>
                    </LeftSection>
                  </MenuItemClub>
                ) : (
                  <MenuItemVip
                    to={item.path}
                    $isActive={activePath === item.path}
                    onClick={() => setActivePath(item.path)}
                  >
                    <LeftSection>
                      <MenuIcon $isCollapsed={isCollapsed}>
                        {item.icon}
                      </MenuIcon>
                      <MenuText
                        $isActive={activePath === item.path}
                        $isCollapsed={isCollapsed}
                      >
                        {item.text}
                      </MenuText>
                    </LeftSection>
                  </MenuItemVip>
                )}
                {[4, 7, 8, 12].includes(index) && <Divider />}
              </React.Fragment>
            ))}
          </MenuSectionS>
        </OuterWrapper>

        {/* <BottomMenuItem onClick={handleDownloadAPK}>
          <div style={{
            width: "100%",
            display: "flex",
            justifyContent: "space-between",
            alignItems: "center"
          }}>
            <LeftSection>
              <Android style={{ color: 'white' }} />
              <MenuText isCollapsed={isCollapsed}>
                Download APK
              </MenuText>
            </LeftSection>
          </div>
        </BottomMenuItem> */}
      </div>
    </SidebarContainer>
  );
};

export default SkylaSidebar;