import * as PIXI from "pixi.js";
import { wait } from "../Helper/index.js";

class Graphic {
	constructor(type, opt = {}){
		this.type = type
		this.opt = opt
		this.object = null
		this.ticker = null
		
		this.show();
	}
	
	show(){
		switch(this.type)
		{
			case 'square':
				return this.square();
				
				break
			case 'circle':
				return this.circle();
				
			case 'star':
				return this.star();
		}
	}
	
	square() {
		const g = new PIXI.Graphics();
		
		if(this.opt.line)
			g.lineStyle(this.opt.line, this.opt.color, this.opt.opacity ? this.opt.opacity : 1);
		else
			g.lineStyle(0);
		
		g.beginFill(this.opt.color ? this.opt.color : '', this.opt.opacity ? this.opt.opacity : 1);
		g.drawRoundedRect(this.opt.x ? (this.opt.x) : 0, this.opt.y ? (this.opt.y) : 0, this.opt.width ? (this.opt.width) : 50, this.opt.height ? (this.opt.height) : 50, this.opt.radius ? this.opt.radius : 0);
		g.endFill();
		
		if(this.opt.button){
			g.interactive = true;
			g.buttonMode = true;
		}
		
		if(this.opt.scale){
			g.scale.x = this.opt.scale
			g.scale.y = this.opt.scale
		}
		
		if(this.opt.active){
			g.interactive = true;
		}
		
		if(this.opt.rotation){
			g.rotation = this.opt.rotation
		}
		
		let index = this.opt.index ? this.opt.index : 1
		
		g.sortChildren(index);
		g.zIndex = index
		g.type = this.type;
		this.object = g;
	}
	
	circle() {
		const g = new PIXI.Graphics();
		
		if(this.opt.line)
			g.lineStyle(this.opt.line, this.opt.color, this.opt.opacity ? this.opt.opacity : 1);
		else
			g.lineStyle(0);
	
		g.beginFill(this.opt.color ? this.opt.color : 0xFFFFFF, this.opt.opacity ? this.opt.opacity : 1);
		g.drawCircle(this.opt.x ? (this.opt.x ) : 0, this.opt.y ? (this.opt.y) : 0, this.opt.radius ? (this.opt.radius ) : 0);
		g.endFill();
		
		if(this.opt.button){
			g.interactive = true;
			g.buttonMode = true;
		}
		
		if(this.opt.active){
			g.interactive = true;
		}
		
		if(this.opt.rotation){
			g.rotation = this.opt.rotation
		}
		
		let index = this.opt.index ? this.opt.index : 1
		
		g.sortChildren(index);
		g.zIndex = index
		g.type = this.type;
		this.object = g;
	}
	
	star() {
		const g = new PIXI.Graphics();
		
		if(this.opt.line)
			g.lineStyle(this.opt.line, this.opt.color, this.opt.opacity ? this.opt.opacity : 1);
		else
			g.lineStyle(0);
	
		g.beginFill(this.opt.color ? this.opt.color : 0xFFFFFF, this.opt.opacity ? this.opt.opacity : 1);
		g.drawStar(this.opt.x ? (this.opt.x ) : 0, this.opt.y ? (this.opt.y ) : 0, 5, this.opt.radius ? (this.opt.radius) : 0);
		g.endFill();
		
		if(this.opt.button){
			g.interactive = true;
			g.buttonMode = true;
		}
		
		if(this.opt.active){
			g.interactive = true;
		}
		
		if(this.opt.rotation){
			g.rotation = this.opt.rotation
		}
		
		let index = this.opt.index ? this.opt.index : 1
		
		g.sortChildren(index);
		g.zIndex = index
		g.type = this.type;
		this.object = g;
	}

	animate(delay, callback){
		this.ticker = new PIXI.Ticker();
		
		let self = this;
		
		if(typeof delay === 'function'){
			callback = delay;
			delay = 0;
		}
		
		var c = function(delta){
			return callback(self.object, delta);
		}
		
		wait(delay).then(() => {
			this.ticker.add(c)
			this.ticker.start();
		})
	}
	
	stop(){
		if(this.ticker !== null)
			this.ticker.stop();
	}
}

export default Graphic;
