import React from 'react';
import ReactDOM from "react-dom";
import { Button, Card, Col, Dropdown, Row } from "react-bootstrap";
import PropTypes from "prop-types";
import { connect } from "react-redux";
import RangeCredit from "../../Components/Game/Addons";
import { __, wait, decode, isValidNumber, forceSatoshiFormat, sendNotfication, Event, playAudio } from "../../../Helper";
import { gameCoin } from "../../../actions/gameCoin";
import { setWallet } from "../../../actions/gameWallet";
import storage from "../../../Storage";
import Wheel from "./components/Wheel";
import C from "../../../Constant";
import "./components/Lib/myWheel";
import styled from "styled-components";
import { ChevronDown, ChevronUp, Info } from "lucide-react";

const Container = styled.div`
 background:rgb(18, 20, 24);
  color: white;
  padding: 20px;
  max-width: 380px;
  border-right: 1px solid #2a2a2a;
  border-bottom: 1px solid #2a2a2a;
  border-radius: 0;
  border-top-left-radius: 12px;
  border-bottom-left-radius: 12px;
`;

const Container2 = styled.div`
 background:rgb(18, 20, 24);
  color: white;
  padding: 20px;
  width: 100%;  /* Full width on mobile */
  border-right: 1px solid #2a2a2a;
  border-bottom: 1px solid #2a2a2a;
  border-radius: 0;
  border-top-left-radius: 12px;
  border-bottom-left-radius: 12px;

  /* Desktop size (768px and above) */
  @media (min-width: 768px) {
    max-width: 380px;
  }
`;

const TabContainer = styled.div`
  display: flex;
  margin-bottom: 24px;
  border-bottom: 1px solid #2a2a2a;
`;

const Tab = styled.button`
  padding: 8px 16px;
  color: ${props => props.active ? '#34d399' : '#808080'};
  background: none;
  border: none;
  cursor: pointer;
  position: relative;
  
  &:after {
    content: '';
    position: absolute;
    bottom: -1px;
    left: 0;
    width: 100%;
    height: 2px;
    background-color: ${props => props.active ? '#34d399' : 'transparent'};
  }
`;

const NewTag = styled.span`
  color: #fbbf24;
  font-size: 12px;
  margin-left: 4px;
`;

const AmountSection = styled.div`
  margin-bottom: 16px;
`;

const Label = styled.div`
  display: flex;
  align-items: center;
  color: #808080;
  margin-bottom: 4px;
  
  svg {
    margin-left: 4px;
    width: 16px;
    height: 16px;
  }
`;

const BetDisplay = styled.div`
  display: flex;
  align-items: center;
  background-color: #292D2E;
  padding: 8px 12px;
  border-radius: 8px;
  margin-bottom: 16px;
  position:relative;
`;

const BetInput = styled.input`
  border: none;
  outline: none;
  color: white;
  background: none;
  padding:5px;
  
  &:focus {
    background: none;
  }
  
  /* Additional browser resets to ensure no background appears */
  &:-webkit-autofill,
  &:-webkit-autofill:hover,
  &:-webkit-autofill:focus,
  &:-webkit-autofill:active {
    -webkit-box-shadow: 0 0 0 30px #1a1a1a inset !important;
    -webkit-text-fill-color: white !important;
    transition: background-color 5000s ease-in-out 0s;
  }
`;

const MultiplierGroup = styled.div`
  margin-left: auto;
  display: flex;
  gap: 8px;
`;

const MultiplierButton = styled.button`
  background-color: #3A4142;
  padding: 4px 12px;
  border-radius: 6px;
  border: none;
  color: white;
  cursor: pointer;
`;

const DropdownContainer = styled.div`
  margin-bottom: 16px;
`;

const DropdownLabel = styled.div`
  display: flex;
  align-items: center;
  color: #808080;
  margin-bottom: 4px;
  
  svg {
    margin-left: 4px;
    width: 16px;
    height: 16px;
  }
`;

const DropdownDisplay = styled.div`
  display: flex;
  align-items: center;
  background-color: #292D2E;
  padding: 8px 12px;
  border-radius: 8px;
  cursor: pointer;
  transition: background-color 0.2s ease;
  
  &:hover {
    background-color: #3A4142;
  }
`;

const DropdownText = styled.span`
  color: white;
  flex: 1;
`;

const DropdownIcon = styled(ChevronDown)`
  color: #808080;
  width: 16px;
  height: 16px;
`;

const RollButton = styled.div`
  width: 100%;
  padding: 12px;
  background: linear-gradient(90deg, rgb(36, 238, 137), rgb(159, 232, 113));
  border: none;
  border-radius: 8px;
  color: black !important;
  font-weight: bold;
  cursor: pointer;
  display: flex;
  justify-content: center;
  align-items: center;
  transition: transform 0.2s ease;

  &:hover {
    transform: scale(1.02);
  }

  &:focus {
    transform: scale(1.02);
    outline: 2px solid rgb(36, 238, 137);
    outline-offset: 2px;
  }
`;

const WarningContainer = styled.div`
  background-color: rgba(52, 199, 89, 0.1);
  border-radius: 8px;
  padding: 2px 16px;
  display: flex;
  align-items: center;
  gap: 12px;
  margin: 0 auto;
  margin-bottom: 16px;
  margin-top: 8px;
`;

const DemoText = styled.div`
  color: #808080;
  font-size: 14px;
  text-align: center;
`;

const TabSwitcher = styled.div`
  display: flex;
  background: #323738;
  padding: 4px;
  border-radius: 12px;
  gap: 4px;
  width: 100%;
  margin: 0 auto 1rem auto;
`;

const TabOption = styled.button`
  background: ${props => props.active ? 'linear-gradient(90deg, #f09c06, #9fe871)' : 'transparent'};
  color: ${props => props.active ? '#1C1D21' : '#80A94'};
  border: none;
  padding: 8px 24px;
  border-radius: 8px;
  font-weight: ${props => props.active ? '600' : '500'};
  cursor: pointer;
  flex:1;
  transition: all 0.2s ease;
  font-size: 14px;
  
  &:hover {
    color: ${props => props.active ? '#1C1D21' : '#ffffff'};
    background: ${props => props.active ? 'linear-gradient(90deg, #f09c06, #9fe871)' : 'rgba(255, 255, 255, 0.05)'};
  }

  &:disabled {
    opacity: 0.5;
    cursor: not-allowed;
  }
`;

const AutoSection = styled.div`
  margin-top: 16px;
  padding-top: 16px;
  border-top: 1px solid #2a2a2a;
`;

const AutoInput = styled.input`
  border: none;
  outline: none;
  color: white;
  background: none;
  padding: 8px 12px;
  border-radius: 6px;
  background-color: #292D2E;
  width: 100%;
  margin-bottom: 12px;
  
  &:focus {
    background-color: #3A4142;
  }
`;

const AutoButton = styled.button`
  background-color: #292D2E;
  color: white;
  border: none;
  padding: 6px 12px;
  border-radius: 6px;
  cursor: pointer;
  font-size: 12px;
  margin-right: 4px;
  
  &:hover {
    background-color: #3A4142;
  }
`;

const SPIN_BUTTON = "spin-to-win";
var HASH = false;

class Game extends React.Component {
    _isMounted = false;
    constructor(props) {
        super(props);
        this.state = {
            engine: this.props.engine,
            started: false,
            bet: 'manual',
            isLogged: storage.getKey("logged") !== null ? true : false,
            playing: false,
            buttonText: 'BET',
            risk: 3,
            riskName: 'Default',
            amount: forceSatoshiFormat(storage.getKey('lam') ? storage.getKey('lam') : .00000010),
            segment: 11,
            game_status: null,
            lock: false,
            bitError: false,
            outError: false,
            inputDisabled: false,
            betNumber: 10,
            firstBetNumber: 10,
            onWin: 0,
            onLost: 0,
            stopOnWin: 0,
            wheelStart: null,
            showRiskDropdown: false,
            showSegmentDropdown: false
        };
        this.handleInputChange = this.handleInputChange.bind(this);
        this.handleBet = this.handleBet.bind(this);
        this.handleClickOutside = this.handleClickOutside.bind(this);
    }

    componentWillUnmount() {
        let { engine, started } = this.state;
        this._isMounted = false;

        engine.init = false;

        // Remove click outside listener
        document.removeEventListener('click', this.handleClickOutside);

        try {
            if (started) {
                document.getElementById('bet').click()
            }
        }
        catch (e) { }
    }

    handleClickOutside = (event) => {
        if (this._isMounted) {
            // Check if click is outside dropdown containers
            const riskDropdown = event.target.closest('[data-dropdown="risk"]');
            const segmentDropdown = event.target.closest('[data-dropdown="segment"]');
            
            if (!riskDropdown && !segmentDropdown) {
                // Close dropdowns if clicking outside
                if (this.state.showRiskDropdown || this.state.showSegmentDropdown) {
                    this.setState({
                        showRiskDropdown: false,
                        showSegmentDropdown: false
                    });
                }
            }
        }
    };

    componentDidMount() {
        let { engine } = this.state;
        this._isMounted = true;

        engine.on(C.PLAY_WHEEL, (data) => this.play(data));
        engine.on(C.BUSTED_WHEEL, (data) => this.busted(data));
        engine.on(C.ERROR_WHEEL, (data) => this.error(data));
        engine.on("stop_wheel", () => this.stopAuto());
        engine.on("stop_playing", () => this.stopManual());

        //Get Redux Coin
        this.props.gameCoin();

        // Add click outside listener
        document.addEventListener('click', this.handleClickOutside);
    }

    stopManual() {
        if (this._isMounted) {
            this.setState({ started: false, buttonText: 'BET', inputDisabled: false });
        }
    }

    stopAuto() {
        if (this._isMounted) {
            this.setState({ started: false, buttonText: 'Start Auto Mode', inputDisabled: false });
        }
    }

    error(data) {
        if (this._isMounted) {
            sendNotfication(data.message, 'info', 'top-center');

            if (data.code === 'credit')
                this.props.setWallet(true, data.uid);

            this.setState({ inputDisabled: false });

            if (this.state.started) {
                this.setState({ started: false, buttonText: 'Start Auto Mode' });
            }
        }
    }

    play(data) {
        if (this._isMounted) {
            this.setState({
                hash: data.hash,
                game_status: 'started',
                lock: true,
                playing: true,
                inputDisabled: true,
                playing: true
            });
            this.state.engine.emit('play_wheel', data.target)
        }
    }

    busted(data) {
        if (this._isMounted) {
            let { profit } = data;
            let { engine, bet, started } = this.state;

            let isWin = false;

            if (parseFloat(profit) !== 0) {
                isWin = true;
            }

            wait(100)
                .then(() => {
                    this.setState({ lock: false, playing: false, inputDisabled: false, playing: false });

                    if (bet === 'auto') {
                        if (started) {
                            wait(250)
                                .then(() => {
                                    engine.isWin = isWin;
                                    engine.roundProfit = __.toNumber(profit) + __.toNumber(engine.roundProfit);
                                    this.placeAutoBet();
                                });
                        }
                    }
                    else {
                        engine.init = false;
                    }
                })

            if (isWin === true)
                playAudio('win.mp3')
        }
    }

    placeAutoBet() {
        if (this._isMounted) {
            let { engine, amount, betNumber, firstBetNumber, onWin, onLost, stopOnWin, segment, risk } = this.state;
            engine.init = true;
            engine.coin = this.props.coin;
            engine.amount = amount;
            engine.segment = segment;
            engine.risk = risk;
            engine.betNumber = firstBetNumber;
            engine.stopOnWin = parseInt(stopOnWin);
            engine.onWin = parseInt(onWin);
            engine.onLost = parseInt(onLost);
            engine.autoStart();

            this.setState({ betNumber: betNumber - 1 });
        }
    }

    placeBet() {
        if (this._isMounted) {
            let { engine, amount, segment, risk } = this.state;
            engine.init = true;
            engine.coin = this.props.coin;
            engine.amount = amount;
            engine.segment = segment;
            engine.risk = risk;
            engine.start();
        }
    }

    isCorrectBet(amount) {
        if (__.trim(amount) === '')
            return false;

        if (!isValidNumber(amount))
            return false;

        if (parseFloat(amount) <= 0) {
            this.setState({ amount: forceSatoshiFormat(0.00000010) });
        }
        else {
            amount = Math.min(parseFloat(storage.getKey('credit')), parseFloat(amount));
            this.setState({ amount: forceSatoshiFormat(amount) });
        }

        return true;
    }

    handleBet(e) {
        e.preventDefault();

        // Check User
        if (!this.state.isLogged) {
            return Event.emit('showAuthModal', true);
        }

        // Check is Correct Bet
        if (!this.isCorrectBet(this.state.amount))
            return false;

        this.setState({ inputDisabled: true });

        wait(100)
            .then(() => {
                if (this.state.bet === 'auto') {
                    if (this.state.started) {
                        this.state.engine.init = false;
                        this.setState({ started: false, buttonText: 'Start Auto Mode', inputDisabled: false, });
                        return;
                    }
                    else {
                        this.setState({ started: true, buttonText: 'Stop Auto Mode' });
                        this.placeAutoBet();
                    }
                }
                else {
                    if (this.state.playing !== true) {
                        // Check for Double request
                        if (this.state.lock === true)
                            return false;

                        this.setState({ inputDisabled: false });
                        this.placeBet();
                    }
                }
            })
    }

    handleInputChange(event) {
        var target = event.target;
        var value = target.type === 'checkbox' ? true : target.value;
        var name = target.name;

        if (__.isEmpty(value)) {
            if (name === 'amount')
                this.setState({ bitError: 'red-border' });
        }
        else {
            if (name === 'amount')
                this.setState({ bitError: false });
        }

        if (name === 'amount' || name === 'stopOnWin') {
            this.setState({amount:value})
            if (!isValidNumber(value)) return;
        }

        if (name === 'amount') {
            storage.setKey('lam', value);
        }

        this.setState({ [name]: value });
    }

    handleRisk = value => {
        if (this._isMounted) {
            if (this.state.inputDisabled)
                return;

            this.setState({ risk: value });

            let name;
            if (value === 3) name = "Default";
            if (value === 2) name = "High";
            this.setState({ riskName: name });

            wait(10)
                .then(() => {
                    this.state.engine.emit('wheel_segment', { segment: this.state.segment, risk: value });
                })
        }
    };

    handleSegment = value => {
        if (this._isMounted) {
            if (this.state.inputDisabled)
                return;

            this.setState({ segment: value });

            wait(10)
                .then(() => {
                    this.state.engine.emit('wheel_segment', { segment: value, risk: this.state.risk });
                })
        }
    };

    betMode = (type) => {
        let text;

        if (type === 'auto') {
            text = 'Start Auto Mode';
        }
        else {
            text = 'BET';
        }
        this.setState({ bet: type, buttonText: text });
    };

    setAmount = (val) => {
        var am = forceSatoshiFormat(val);
        this.setState({ amount: am });
        storage.setKey('lam', am);
    }

    setNumber = (e, num) => {
        e.preventDefault();
        this.setState({ betNumber: num, firstBetNumber: num });
    };

    handleMultiplier = (type) => {
        if (this._isMounted) {
            let currentAmount = parseFloat(this.state.amount);
            let newAmount;

            if (type === 'half') {
                newAmount = currentAmount / 2;
            } else if (type === 'double') {
                newAmount = currentAmount * 2;
            }

            // Ensure the amount doesn't go below the minimum bet
            if (this.props.coin === 'INR') {
                newAmount = Math.max(newAmount, 50);
            } else if (this.props.coin === 'USDT') {
                newAmount = Math.max(newAmount, 1);
            } else {
                newAmount = Math.max(newAmount, 0.0000001);
            }

            // Format and update the amount
            const formattedAmount = forceSatoshiFormat(newAmount);
            this.setState({ amount: formattedAmount });
            storage.setKey("lam", formattedAmount);
        }
    };

    render() {
        let { inputDisabled, selectedOption, bet, started, segment, riskName } = this.state;

        return (
            <Container2>
                <div className="w-100 mt-1">
                    <TabSwitcher>
                        <TabOption
                            active={bet === 'manual'}
                            onClick={() => this.betMode('manual')}
                            disabled={started}
                        >
                            Manual
                        </TabOption>
                        <TabOption
                            active={bet === 'auto'}
                            onClick={() => this.betMode('auto')}
                            disabled={started}
                        >
                            Auto
                        </TabOption>
                    </TabSwitcher>

                    <AmountSection>
                        <Label>
                            Amount
                            <Info />
                        </Label>
                        <BetDisplay>
                            <img
                                src={`/assets/images/${this.props.coin}.png`}
                                className="mini-coin-7"
                                alt=""
                            />
                            <BetInput
                                disabled={inputDisabled}
                                type="text"
                                className="form-control text-left"
                                id="amount"
                                name="amount"
                                placeholder="Enter Bet Amount"
                                value={this.state.amount}
                                autoComplete="off"
                                onChange={this.handleInputChange}
                            />
                            <MultiplierGroup>
                                <MultiplierButton
                                    onClick={() => this.handleMultiplier('half')}
                                    disabled={this.state.inputDisabled}
                                >
                                    1/2
                                </MultiplierButton>
                                <MultiplierButton
                                    onClick={() => this.handleMultiplier('double')}
                                    disabled={this.state.inputDisabled}
                                >
                                    2x
                                </MultiplierButton>
                                <div className="input-group-append">
                                    <RangeCredit set={this.setAmount} />
                                </div>
                            </MultiplierGroup>
                        </BetDisplay>
                    </AmountSection>

                    <DropdownContainer data-dropdown="risk">
                        <DropdownLabel>
                            Risk Level
                            <Info />
                        </DropdownLabel>
                        <div style={{ position: 'relative' }}>
                            <DropdownDisplay 
                                onClick={(e) => {
                                    e.stopPropagation();
                                    if (!inputDisabled) {
                                        this.setState({ showRiskDropdown: !this.state.showRiskDropdown });
                                    }
                                }}
                            >
                                <DropdownText>{riskName}</DropdownText>
                                <DropdownIcon />
                            </DropdownDisplay>
                            {this.state.showRiskDropdown && (
                                <div style={{ 
                                    position: 'absolute', 
                                    top: '100%', 
                                    left: 0, 
                                    right: 0,
                                    zIndex: 1000, 
                                    background: '#292D2E', 
                                    borderRadius: '8px', 
                                    marginTop: '4px',
                                    border: '1px solid #3A4142',
                                    boxShadow: '0 4px 6px rgba(0, 0, 0, 0.3)'
                                }}>
                                    <div 
                                        style={{ 
                                            padding: '8px 12px', 
                                            cursor: 'pointer', 
                                            color: 'white',
                                            borderBottom: '1px solid #3A4142'
                                        }}
                                        onMouseEnter={(e) => e.target.style.backgroundColor = '#3A4142'}
                                        onMouseLeave={(e) => e.target.style.backgroundColor = 'transparent'}
                                        onClick={(e) => {
                                            e.stopPropagation();
                                            this.handleRisk(3);
                                            this.setState({ showRiskDropdown: false });
                                        }}
                                    >
                                        Default
                                    </div>
                                    <div 
                                        style={{ 
                                            padding: '8px 12px', 
                                            cursor: 'pointer', 
                                            color: 'white'
                                        }}
                                        onMouseEnter={(e) => e.target.style.backgroundColor = '#3A4142'}
                                        onMouseLeave={(e) => e.target.style.backgroundColor = 'transparent'}
                                        onClick={(e) => {
                                            e.stopPropagation();
                                            this.handleRisk(2);
                                            this.setState({ showRiskDropdown: false });
                                        }}
                                    >
                                        High
                                    </div>
                                </div>
                            )}
                        </div>
                    </DropdownContainer>

                    <DropdownContainer data-dropdown="segment">
                        <DropdownLabel>
                            Segments
                            <Info />
                        </DropdownLabel>
                        <div style={{ position: 'relative' }}>
                            <DropdownDisplay 
                                onClick={(e) => {
                                    e.stopPropagation();
                                    if (!inputDisabled) {
                                        this.setState({ showSegmentDropdown: !this.state.showSegmentDropdown });
                                    }
                                }}
                            >
                                <DropdownText>{segment}</DropdownText>
                                <DropdownIcon />
                            </DropdownDisplay>
                            {this.state.showSegmentDropdown && (
                                <div style={{ 
                                    position: 'absolute', 
                                    top: '100%', 
                                    left: 0, 
                                    right: 0,
                                    zIndex: 1000, 
                                    background: '#292D2E', 
                                    borderRadius: '8px', 
                                    marginTop: '4px',
                                    border: '1px solid #3A4142',
                                    boxShadow: '0 4px 6px rgba(0, 0, 0, 0.3)'
                                }}>
                                    <div 
                                        style={{ 
                                            padding: '8px 12px', 
                                            cursor: 'pointer', 
                                            color: 'white',
                                            borderBottom: '1px solid #3A4142'
                                        }}
                                        onMouseEnter={(e) => e.target.style.backgroundColor = '#3A4142'}
                                        onMouseLeave={(e) => e.target.style.backgroundColor = 'transparent'}
                                        onClick={(e) => {
                                            e.stopPropagation();
                                            this.handleSegment(8);
                                            this.setState({ showSegmentDropdown: false });
                                        }}
                                    >
                                        7
                                    </div>
                                    <div 
                                        style={{ 
                                            padding: '8px 12px', 
                                            cursor: 'pointer', 
                                            color: 'white',
                                            borderBottom: '1px solid #3A4142'
                                        }}
                                        onMouseEnter={(e) => e.target.style.backgroundColor = '#3A4142'}
                                        onMouseLeave={(e) => e.target.style.backgroundColor = 'transparent'}
                                        onClick={(e) => {
                                            e.stopPropagation();
                                            this.handleSegment(11);
                                            this.setState({ showSegmentDropdown: false });
                                        }}
                                    >
                                        10
                                    </div>
                                    <div 
                                        style={{ 
                                            padding: '8px 12px', 
                                            cursor: 'pointer', 
                                            color: 'white',
                                            borderBottom: '1px solid #3A4142'
                                        }}
                                        onMouseEnter={(e) => e.target.style.backgroundColor = '#3A4142'}
                                        onMouseLeave={(e) => e.target.style.backgroundColor = 'transparent'}
                                        onClick={(e) => {
                                            e.stopPropagation();
                                            this.handleSegment(21);
                                            this.setState({ showSegmentDropdown: false });
                                        }}
                                    >
                                        20
                                    </div>
                                    <div 
                                        style={{ 
                                            padding: '8px 12px', 
                                            cursor: 'pointer', 
                                            color: 'white'
                                        }}
                                        onMouseEnter={(e) => e.target.style.backgroundColor = '#3A4142'}
                                        onMouseLeave={(e) => e.target.style.backgroundColor = 'transparent'}
                                        onClick={(e) => {
                                            e.stopPropagation();
                                            this.handleSegment(31);
                                            this.setState({ showSegmentDropdown: false });
                                        }}
                                    >
                                        30
                                    </div>
                                </div>
                            )}
                        </div>
                    </DropdownContainer>

                    {bet === 'auto' && (
                        <AutoSection>
                            <Label>Number of Bets</Label>
                            <BetDisplay>
                                <BetInput
                                    type="number"
                                    disabled={inputDisabled}
                                    value={this.state.betNumber}
                                    onChange={(e) => this.setNumber(e, e.target.value)}
                                    placeholder="Enter number of bets"
                                />
                                <MultiplierGroup>
                                    <AutoButton onClick={(e) => this.setNumber(e, 10)}>10</AutoButton>
                                    <AutoButton onClick={(e) => this.setNumber(e, 50)}>50</AutoButton>
                                    <AutoButton onClick={(e) => this.setNumber(e, 100)}>100</AutoButton>
                                </MultiplierGroup>
                            </BetDisplay>

                            <Label>Increase Amount On Win (%)</Label>
                            <AutoInput
                                disabled={inputDisabled}
                                type="number"
                                name="onWin"
                                min="0"
                                max="100"
                                value={this.state.onWin}
                                onChange={e => this.setState({ onWin: e.target.value })}
                                placeholder="0"
                            />

                            <Label>Increase Amount On Loss (%)</Label>
                            <AutoInput
                                disabled={inputDisabled}
                                type="number"
                                name="onLost"
                                min="0"
                                max="100"
                                value={this.state.onLost}
                                onChange={e => this.setState({ onLost: e.target.value })}
                                placeholder="0"
                            />

                            <Label>Stop On Win</Label>
                            <AutoInput
                                disabled={inputDisabled}
                                type="text"
                                name="stopOnWin"
                                placeholder="Enter amount to stop on win"
                                value={this.state.stopOnWin}
                                onChange={this.handleInputChange}
                            />
                        </AutoSection>
                    )}

                    <RollButton onClick={() => {
                        if (this.props.coin === 'INR') {
                            if (this.state.amount < 50) {
                                sendNotfication('Enter valid amount')
                            } else {
                                this.handleBet({ preventDefault: () => {} });
                            }
                        }
                        else if (this.props.coin === 'USDT') {
                            if (this.state.amount < 1) {
                                sendNotfication('Enter valid amount')
                            } else {
                                this.handleBet({ preventDefault: () => {} });
                            }
                        } else {
                            this.handleBet({ preventDefault: () => {} });
                        }
                    }}>
                        {this.state.buttonText}
                        {started && <div className="ml-2 spinner-border spinner-border-sm" />}
                    </RollButton>

                    <WarningContainer>
                        <DemoText>Betting with $0 will enter demo mode.</DemoText>
                    </WarningContainer>

                    <a href="#" className={'hidden ' + SPIN_BUTTON} />
                </div>
            </Container2>
        );
    }
}

Game.propTypes = {
    coin: PropTypes.string,
    credit: PropTypes.string
};

const mapStateToProps = state => ({
    coin: state.items.coin,
    credit: state.items.credit
});

export default connect(mapStateToProps, { gameCoin, setWallet })(Game);
