import React,{useEffect,useState} from "react";
import styled from "styled-components";
import CommissionHistory from "./History/CommissionHistory";
import ReferralHistory from "./History/ReferralHistory";
import { Link } from "react-router-dom";
import { getUID, sendNotfication } from "../../../Helper";
import storage from "../../../Storage";
import axios from 'axios';

const AffiliateBody = styled.div`
  display: flex;
  flex-direction: column;
  gap: 20px;
  margin-top: 20px;
`;

const SectionHeader = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  gap: 3rem;
  width: 100%;
  padding: 20px;
  border-radius: 10px;
 background:rgb(18, 20, 24);

  @media (max-width: 911px) {
    flex-direction: column;
    gap: 2rem;
    align-items: flex-start;
  }
`;

const SectionBody = styled.div`
  display: flex;
  flex-direction: column;
  border-radius: 10px;
 background:rgb(18, 20, 24);
`;

const SectionNavWrapper = styled.div`
  position: relative;
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding-top: 20px;
  border-bottom: 1px solid #ffffff20;
`;

const NavItem = styled.div`
  padding: 0px 10px;
  padding-bottom: 8px;
  text-align: center;
  min-width: 150px;
  border-bottom: 2px solid ${(props) => (props.active ? "#f09c06" : "#323738")};
  cursor: pointer;
  color: ${(props) => (props.active ? "#ffffff" : "#f09c06")};
  transition: all 0.3s ease;
`;

const SectionDataWrapper = styled.div`
  display: flex;
  flex-direction: column;
  gap: 10px;
  padding: 20px;
  min-height: 50vh;
`;

const Column = styled.div`
  display: flex;
  flex-direction: column;
  gap: 10px;
  width: 100%;
`;

const ValueText = styled.span`
  color: #f09c06;
  font-size: 18px;
  font-weight: bold;
`;

const Label = styled.span`
  color: ${(props) => (props.dimmed ? "red" : "#ffffff")};
  font-weight: ${(props) => (props.bold ? "bold" : "normal")};
`;

const FlexRow = styled.div`
  display: flex;
  gap: 5px;
  align-items: center;
`;

const DividerContainer = styled.div`
  display: flex;
  align-items: center;
  gap: 10px;
  border-left: 1.5px solid #ffffff20;
  justify-content: center;
  min-height: 8vh;
  width: 100%;

  @media (max-width: 911px) {
    border-left: none;
    justify-content: start;
    align-items: start;
  }
`;

const StyledButton = styled.div`
color:black !important;
font-weight:bold !important;
  background-size: 200% auto;
  text-align: center;
  background: #f09c06;
  border: none;
  border-radius: 10px;
  padding: 10px 25px;
  font-size: 14px;
  font-weight: 500;
  white-space: nowrap;
  min-width: 100px;
  max-width: max-content;
  transition: all 0.3s ease;

  &:hover {
    background-position: right center;
  }

  @media (max-width: 768px) {
    font-size: 12px;
    padding: 8px 15px;
    border: 1px solid #f09c06;
  }
`;

const AffiliateRewards = () => {
  const [referralCode, setReferralCode] = useState("");
  const [teamMembers, setTeamMembers] = useState([]);
  const [rewards, setRewards] = useState([]);
  const [unclaimedRewards, setUnclaimedRewards] = useState([]);
  const [totalUnclaimed, setTotalUnclaimed] = useState(0);
  const [isHistoryTab, setIsHistoryTab] = useState("Commission");
  const [isLoading, setIsLoading] = useState(false);
  const [stats, setStats] = useState({
    totalMembers: 0,
    totalRewards: 0,
    referralRewards: 0,
    commissionRewards: 0,
    totalReferrals: 0,
  });

  const handleTabClick = (tab) => {
    setIsHistoryTab(tab);
  };

  
  const fetchReferralInfo = async () => {
    try {
       const id = getUID();
       const token = localStorage.getItem('token');
      const response = await fetch(`https://api.boss707.com/affiliate/referral-info/${id}`, {
        method: "GET",
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Bearer ${token}`,
        },
      });
      const data = await response.json();

      if (data.referralCode) {
        setReferralCode(data.referralCode);
        try {
          // Fetch team members and rewards
          const token = localStorage.getItem('token');
          const headers = {
            'Authorization': `Bearer ${token}`
          };
          const teamResponse = await axios.get(`https://api.boss707.com/affiliate/team/${data.referralCode}`, { headers });
          const rewardsResponse = await axios.get(`https://api.boss707.com/affiliate/rewards/${data.referralCode}`, { headers });
          const unclaimedResponse = await axios.get(`https://api.boss707.com/affiliate/unclaimed-rewards/${getUID()}`, { headers });

          setTeamMembers(teamResponse.data.teamMembers || []);
          setRewards(rewardsResponse.data.rewards || []);
          setUnclaimedRewards(unclaimedResponse.data.unclaimedRewards || []);
          setTotalUnclaimed(unclaimedResponse.data.totalUnclaimed || 0);

          // Calculate statistics
          const totalMembers = teamResponse.data.teamMembers?.length || 0;
          const totalRewards = rewardsResponse.data.totalRewards || 0;

          // Calculate rewards by type
          const rewardsByType = (rewardsResponse.data.rewards || []).reduce(
            (acc, reward) => {
              if (reward.type === "referral") {
                acc.referralRewards += reward.amount;
              } else if (reward.type === "commission") {
                acc.commissionRewards += reward.amount;
              }
              return acc;
            },
            { referralRewards: 0, commissionRewards: 0 }
          );

          const rewardsByType2 = (rewardsResponse.data.rewards || []).reduce(
            (acc, reward) => {
              if (reward.type === "referral") {
                acc.totalReferrals += reward.referalmount;
              } 
              return acc;
            },
            { totalReferrals:0}
          );

          setStats({
            totalMembers,
            totalRewards,
            ...rewardsByType,
            ...rewardsByType2,
          });
        } catch (error) {
          console.error("Error fetching additional data:", error);
        }
      }
    } catch (error) {
      console.error("Error fetching referral info:", error);
    }
  };

  const handleWithdrawToWallet = async () => {
    setIsLoading(true);
    try {
      const response = await axios.post("https://api.boss707.com/affiliate/claim-reward-all", {
        uid: getUID(),
      });

      if (response.data.success) {
        console.log("Withdraw successful:", response.data.message);
        sendNotfication(response.data.message);
        // Refetch data to update UI with the latest information
        await fetchReferralInfo();
      } else {
        console.error("Withdraw failed:", response.data.message);
        sendNotfication(response.data.message);
      }
    } catch (error) {
      console.error("Error during withdrawal:", error);
      sendNotfication("An error occurred during withdrawal. Please try again later.");
     
    }
    finally {
      setIsLoading(false); // Hide loading indicator
    }
  };

  useEffect(() => {
    fetchReferralInfo();
  }, [referralCode]);

  return (
    <AffiliateBody>
      <SectionHeader>
        <Column>
          <div>
            <Label>Total Commission Rewards</Label>
          </div>
          <div>
            <ValueText>{stats.commissionRewards.toFixed(2)} B7</ValueText>
          </div>
          {/* <div>
            <FlexRow>
              <Label>Total Received:</Label>
              <Label bold>{stats.commissionRewards.toFixed(2)} B7</Label>
            </FlexRow>
          </div> */}
        </Column>

        <Column>
          <div>
            <Label>Available Referral Rewards</Label>
          </div>
          <div>
            <ValueText>{totalUnclaimed.toFixed(2)} B7</ValueText>
          </div>
          <FlexRow>
            <FlexRow>
              <Label >Total Received:</Label>
              <Label bold>{stats.totalReferrals.toFixed(2)} B7</Label>
            </FlexRow>
            <FlexRow>
              <Label style={{marginLeft:'5px'}} >Locked:</Label>
              <Label dimmed bold>{stats.referralRewards.toFixed(2)} B7</Label>
            </FlexRow>
          </FlexRow>
        </Column>
     <DividerContainer>
     <StyledButton  onClick={handleWithdrawToWallet} disabled={isLoading}>
            {isLoading ? "Processing..." : "Withdraw to Wallet"}
          </StyledButton>
        </DividerContainer> 
      </SectionHeader>
      <SectionBody>
        <SectionNavWrapper>
          <div style={{ display: "flex", gap: "10px" }}>
            <NavItem
              active={isHistoryTab === "Commission"}
              onClick={() => handleTabClick("Commission")}
            >
              Commission
            </NavItem>
            <NavItem
              active={isHistoryTab === "Referral"}
              onClick={() => handleTabClick("Referral")}
            >
              Referral
            </NavItem>
          </div>

      
        </SectionNavWrapper>

        <SectionDataWrapper>
          {isHistoryTab === "Commission" && <CommissionHistory />}
          {isHistoryTab === "Referral" && <ReferralHistory />}
        </SectionDataWrapper>
      </SectionBody>
    </AffiliateBody>
  );
};

export default AffiliateRewards;

