import React, { Component } from 'react';
import { Modal } from 'react-bootstrap';
import styled from 'styled-components';
import Cookies from 'js-cookie';
import storage from '../../../Storage';
import socket from '../../../Socket';
import { Event, wait, decode, encode, sendNotfication, isEmail } from '../../../Helper';
import C from '../../../Constant';
import Google from "./Google";
import { CrossIcon } from 'lucide-react';

const StyledModal = styled(Modal)`
  .modal-content {
    // background-color: #232626;
     background: #03030F;
    color: white;
    border-radius: 12px;
    overflow: hidden;
    max-width: 900px;
    margin: 0 auto;
    display: flex;
    flex-direction: column;
    z-index: 999;
    
    @media (min-width: 768px) {
      flex-direction: row;
    }
    
    @media (max-width: 768px) {
      padding: 0;
      height: 100vh;
      border-radius: 0;
      margin: 0;
    }
  }
  
  .modal-dialog {
    max-width: 900px;
    margin: 0;
    height: 100vh;
    width: 100vw;
    z-index: 9999;
    
    @media (min-width: 768px) {
      margin: 1.75rem auto;
      height: auto;
      width: auto;
    }

    @media (max-width: 768px) {
      margin: 0;
      max-width: 100%;
      height: 100vh;
    }
  }
  
  &.modal {
    z-index: 1060;
  }
  
  .modal-backdrop {
     background: rgba(0, 0, 0, 1);
  
   
  }
  
  @media (max-width: 768px) {
    margin: 0;
    padding: 0;
    
    &.modal-dialog-centered {
      min-height: 100vh;
      align-items: flex-start;
      margin: 0;
    }
  }
`;

const LeftSection = styled(Modal.Body)`
  padding: 32px;
  flex: 1;
  position: relative;
  width: 100%;
  
  @media (max-width: 768px) {
    padding: 20px;
    order: 2;
    margin-top: -250px;
    // background-color: #232626;
     background: #03030F;
    border-top-left-radius: 20px;
    border-top-right-radius: 20px;
  }
`;

const RightSection = styled.div`
  flex: 1;
  // background-image: url('/assets/images/bcgames/signin/signup.png');
    background-image: url('/assets/images/bcgames/signin/signup.png');
  background-size: cover;
  background-position: center;
  position: relative;
  background-repeat: no-repeat;
  min-height: 160px;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
  padding: 30px;
  object-fit: cover;
  
  @media (min-width: 768px) {
    min-height: 450px;
    background-position: center top;
    background-repeat: no-repeat;
    overflow: hidden;
    background-size: 100% auto;
  }
  
  @media (max-width: 768px) {
    order: 1;
    // padding: 12px;

    min-height: auto;
    // background-image: url('/assets/images/bcgames/signin/signup.png');
    background-image: url('/assets/images/bcgames/signin/signup.png');
    // background-position: top;
    // background-size: contain;
    justify-content: flex-end;
    
    &::after {
      content: '';
      position: absolute;
      bottom: 0;
      left: 0;
      right: 0;
      height: 70%;
      background: linear-gradient(to bottom, rgba(35, 38, 38, 0), rgba(35, 38, 38, 1));
      pointer-events: none;
    }
  }
`;

const RightContent = styled.div`
  position: relative;
  z-index: 1;
  color: white;
`;

const StayUntamed = styled.div`
  h2 {
    font-size: 28px;
    font-weight: bold;
    margin-bottom: 16px;
    color: white;
    text-align: center;
    
    @media (max-width: 768px) {
      font-size: 20px;
      margin-bottom: 8px;
    }
  }

  p {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.8);
    text-align: center;
    
    @media (max-width: 768px) {
      font-size: 12px;
    }
  }

  @media (max-width: 768px) {
    display: none;
  }
`;

const CloseButton = styled.button`
  position: fixed;
  right: 6%;
  top: 5%;
  background: rgba(255, 255, 255, 0.1);
  border: none;
  color: white;
  font-size: 18px;
  width: 32px;
  height: 32px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  cursor: pointer;
  z-index: 10;
  
  @media (min-width: 768px) {
    position: absolute;
  }
  
  &:hover {
    background: rgba(255, 255, 255, 0.2);
  }
`;

const Logo = styled.div`
  margin-bottom: 32px;
  
  img {
    height: 36px;
  }

  @media (max-width: 768px) {
    margin-bottom: 16px;
    
    img {
      height: 28px;
    }
  }
`;

const Title = styled.h2`
  font-size: 24px;
  color: white;
  margin-bottom: 32px;

  @media (max-width: 768px) {
    font-size: 18px;
    margin-bottom: 20px;
  }
`;

const StyledForm = styled.form`
  display: flex;
  flex-direction: column;
  gap: 20px;

  @media (max-width: 768px) {
    gap: 12px;
  }
`;

const InputWrapper = styled.div`
  display: flex;
  flex-direction: column;
  gap: 8px;
`;

const StyledInput = styled.input`
  background: rgba(0, 0, 0, 0.2);;
  border: 1px solid #272B30;
  border-radius: 12px;
  color: white;
  padding: 12px 16px;
  width: 100%;
  font-size: 15px;

  @media (max-width: 768px) {
    padding: 10px 12px;
    font-size: 13px;
    border-radius: 8px;
  }

  &::placeholder {
    color: #fff;
  }

  &:focus {
    outline: none;
    border-color: #f09c06;
  }
`;

const PasswordWrapper = styled.div`
  position: relative;
  width: 100%;
`;

const PasswordToggle = styled.button`
  position: absolute;
  right: 16px;
  top: 50%;
  transform: translateY(-50%);
  background: none;
  border: none;
  color: #fff;
  cursor: pointer;
`;

const ForgotPassword = styled.a`
  color: #fff;
  text-decoration: none;
  font-size: 14px;
  text-align: right;
  display: block;
  margin-top: -12px;
  
  @media (max-width: 768px) {
    font-size: 12px;
    margin-top: -8px;
  }
  
  &:hover {
    color: #f09c06;
  }
`;

const SignInButton = styled.button`
  background: #f09c06;
  border: none;
  border-radius: 12px;
  color: black !important;
  padding: 12px 16px;
  font-weight: 600;
  font-size: 15px;
  width: 100%;
  cursor: pointer;
  margin-top: 12px;

  @media (max-width: 768px) {
    padding: 10px 12px;
    font-size: 14px;
    margin-top: 8px;
    border-radius: 8px;
  }

  &:hover {
    background-color: #00A06D;
  }

  &:disabled {
    opacity: 0.7;
    cursor: not-allowed;
  }
`;

const Divider = styled.div`
  display: flex;
  align-items: center;
  margin: 24px 0;
  color: #fff;
  font-size: 14px;
  
  &::before, &::after {
    content: "";
    flex: 1;
    height: 1px;
    background: #272B30;
    margin: 0 16px;
  }

  @media (max-width: 768px) {
    margin: 16px 0;
    font-size: 12px;
  }
`;

const SocialLoginContainer = styled.div`
  display: flex;
  justify-content: center;
  gap: 12px;
  
  @media (max-width: 768px) {
    gap: 8px;
  }
`;

const SocialButton = styled.button`
  background: #111315;
  border: 1px solid #272B30;
  border-radius: 12px;
  width: 48px;
  height: 48px;
  display: flex;
  align-items: center;
  justify-content: center;
  cursor: pointer;
  
  @media (max-width: 768px) {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    
    svg {
      width: 18px;
      height: 18px;
    }
  }
  
  &:hover {
    background: #191B1D;
  }

  svg {
    width: 24px;
    height: 24px;
    fill: #fff;
  }
`;

const SignUpPrompt = styled.div`
  text-align: center;
  margin-top: 24px;
  color: #fff;
  font-size: 14px;

  @media (max-width: 768px) {
    margin-top: 16px;
    font-size: 12px;
  }

  a {
    color: #f09c06;
    text-decoration: none;
    font-weight: 600;
    margin-left: 8px;

    &:hover {
      text-decoration: underline;
    }
  }
`;

const ModalClose = styled.div`
 display:none;
  @media (max-width: 768px) {
  display:flex;
   height:30px;
   width:30px;
   justify-content:center;
   align-items:center;
   border-radius:20%;
   background-color:#2D6A4D;
   position:absolute;
   padding:12px;
   top:-550px;;
   left:299px;
   z-index:9999;

  }
`;

const StyledSignInButton = styled.div`
  font-size: 14px;
  color: #fff !important;
  background-color: transparent;
  border: 1px solid  #f09c06;
  border-radius: 10px;
  padding: 7px 14px;
  font-weight: bold;
  cursor: pointer;
  white-space: nowrap;

  @media (max-width: 768px) {
    width: 100%;
    text-align: center;
    font-size: 13px;
    padding: 6px 12px;
    border-radius: 8px;
  }
`;
class AgentLoginModal extends Component {
    constructor(props) {
        super(props);
        this.state = {
            isLogged: storage.getKey('logged'),
            show: true,
            username: '',
            password: '',
            status: false,
            submitted: false,
            disabled: false,
            effect: 'zoomIn',
            forgetPage: false,
            showPassword: false,
             // Add new 2FA states
             showTwoFactorInput: false,
             twoFactorCode: '',
             tempLoginData: null,
             email: '',
             
             loading: false,
             showReset2FAModal: false,
        reset2FAIdentifier: '',
        showOTPInputModal: false,
        reset2FAOTP: ''
        };
    }


   
  handleInputEmailChange = (e) => {
      this.setState({ email: e.target.value });
  }

  handleSubmitForgot = (e) => {
    e.preventDefault();
    const { t } = this.props;
  
    if (!isEmail(this.state.email)) {
      return sendNotfication(
        t ? t('please_enter_valid_email_address') : 'Please enter a valid email address',
        'warning',
        'top-center'
      );
    }
  
    this.setState({ disabled: true });
    socket.emit(C.RESET_PASSWORD, encode({ email: this.state.email }));
  };
resetPassword = (data) => {
  const { t } = this.props;
  const response = data;

  this.setState({ disabled: false });

  if (response.status) {
       this.setState({email:""});
       this.setState({ forgetPage: !this.state.forgetPage });
      return sendNotfication(t ? t('your password sended to email') : 'Your password has been sent to your email', 'success', 'top-center');
  } else {
      return sendNotfication(t ? t('this emails not registred on our system') : 'This email is not registered in our system', 'warning', 'top-center');
  }
}

  


    togglePasswordVisibility = () => {
        this.setState(prevState => ({
            showPassword: !prevState.showPassword
        }));
    }

    componentDidMount() {
      socket.on(C.LOGIN_USER, data => this.handleLoginResponse(decode(data)));
      console.log('Setting up RESET_PASSWORD listener');
      socket.on(C.RESET_PASSWORD, (data) => {
        console.log('Received RESET_PASSWORD response:', data);
        const decodedData = decode(data);
        console.log('Decoded data:', decodedData);
        this.resetPassword(decodedData);
      });
        Event.on('login_form', () => {
            this.handleShow();
        });
        
        // Automatically show modal when component mounts via route
        this.handleShow();
    }
    
 

    check2FAStatus = async (uid) => {
      try {
        const token = localStorage.getItem('token');
          const response = await fetch(`https://api.boss707.com/2fa/status/${uid}`, {
            headers: {
              'Authorization': `Bearer ${token}`,
            },
          });
          const data = await response.json();
          return data.isEnabled;
      } catch (error) {
          console.error('Error checking 2FA status:', error);
          return false;
      }
  };
  handleReset2FAModalShow = () => {
    this.setState({ showReset2FAModal: true });
};

handleReset2FAModalClose = () => {
    this.setState({ 
        showReset2FAModal: false, 
        reset2FAIdentifier: '', 
        showOTPInputModal: false, 
        reset2FAOTP: '',
        disabled: false 
    });
};

handleReset2FAIdentifierChange = (e) => {
    this.setState({ reset2FAIdentifier: e.target.value });
};

handleReset2FASubmit = async (e) => {
    e.preventDefault();
    const { reset2FAIdentifier } = this.state;

    if (!reset2FAIdentifier) {
        sendNotfication('Please enter your email or username', 'warning', 'top-center');
        return;
    }

    this.setState({ disabled: true });

    try {
        const token = localStorage.getItem('token');
        const response = await fetch('https://api.boss707.com/email/2fa/reset', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Authorization': `Bearer ${token}`,
            },
            body: JSON.stringify({ identifier: reset2FAIdentifier })
        });
        const data = await response.json();

        if (data.success) {
            this.setState({ 
                showOTPInputModal: true,
                disabled: false
            });
            sendNotfication('OTP sent to your email', 'success', 'top-center');
        } else {
            this.setState({ disabled: false });
            sendNotfication(data.error, 'error', 'top-center');
        }
    } catch (error) {
        this.setState({ disabled: false });
        sendNotfication('Failed to send OTP', 'error', 'top-center');
    }
};

handleReset2FAOTPChange = (e) => {
    this.setState({ reset2FAOTP: e.target.value });
};

handleReset2FAOTPSubmit = async (e) => {
    e.preventDefault();
    const { reset2FAIdentifier, reset2FAOTP } = this.state;

    if (!reset2FAOTP) {
        sendNotfication('Please enter the OTP', 'warning', 'top-center');
        return;
    }

    this.setState({ disabled: true });

    try {
        const response = await fetch('https://api.boss707.com/email/2fa/reset-verify', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                identifier: reset2FAIdentifier,
                otp: reset2FAOTP
            })
        });
        const data = await response.json();

        if (data.success) {
            this.setState({
                showReset2FAModal: false,
                showOTPInputModal: false,
                reset2FAIdentifier: '',
                reset2FAOTP: '',
                showTwoFactorInput: false,
                twoFactorCode: '',
                tempLoginData: null,
                disabled: false
            });
            sendNotfication('2FA has been reset successfully', 'success', 'top-center');
        } else {
            this.setState({ disabled: false });
            sendNotfication(data.error, 'error', 'top-center');
        }
    } catch (error) {
        this.setState({ disabled: false });
        sendNotfication('Failed to verify OTP', 'error', 'top-center');
    }
};
  handleLoginResponse = async (data) => {
    console.log('Received login response:', data);
    
    if (data.status === true) {
      console.log('Login successful, checking 2FA status');
      try {
        const is2FAEnabled = await this.check2FAStatus(data.uid);
        console.log('2FA status:', is2FAEnabled);
        
        if (is2FAEnabled) {
          this.setState({
            showTwoFactorInput: true,
            tempLoginData: data,
            disabled: false,
            submitted: false
          });
        } else {
          this.setLogin(data);
        }
      } catch (error) {
        console.error('Error during 2FA check:', error);
        this.setState({ submitted: false, disabled: false });
        sendNotfication('Error verifying account security', 'error', 'bottom-left');
      }
    } else {
      console.log('Login failed:', data.status);
      this.setState({ submitted: false, disabled: false });
      sendNotfication(data.status, 'error', 'bottom-left');
    }
  };
    setLogin = (data) => {
        console.log('🔐 setLogin called with data:', data);
        
        if (data.status === true) {
            console.log('✅ Login successful, storing user data');
            sendNotfication('Successfully Login, Please Wait...', 'success', 'bottom-left');
            
            console.log('🍪 Setting cookies');
            Cookies.set("session", data.token, { expires: 14 });
            Cookies.set("uid",data.uid);
            
            console.log('💾 Storing user data in localStorage');
            storage.setKey('logged', true);
            storage.setKey('token', data.token);
            storage.setKey('name', data.name);
            storage.setKey('avatar', data.avatar);
            storage.setKey('email', data.email);
            
            console.log('💰 Storing credit data:', data.credit);
            
            // Handle credit data properly - extract INR value if it's an object
            let creditValue;
            if (typeof data.credit === 'object' && data.credit !== null) {
              // If credit is an object with multiple coins, get the INR value
              creditValue = data.credit.inr || data.credit.INR || 0;
              console.log('💰 Extracted INR credit value:', creditValue);
            } else {
              // If credit is already a single value, use it directly
              creditValue = data.credit || 0;
              console.log('💰 Using direct credit value:', creditValue);
            }
            
            storage.setKey('credit', creditValue);
            
            storage.setKey('room', data.room);
            storage.setKey('friends', data.friends);
            storage.setKey('country',data.country);
            
            console.log('🚩 Setting localStorage flags');
            localStorage.setItem('showLoginSuccessModal', 'true');
            localStorage.setItem('coinRefresh', 'true');
            
            // Emit events to notify components about login success
            console.log('📡 Emitting login success events');
            Event.emit('user_logged_in', {
                token: data.token,
                uid: data.uid,
                credit: creditValue
            });
            Event.emit('credit_updated', creditValue);
            Event.emit('coins_refresh_required');
            
            console.log('⏳ Waiting 500ms before page reload');
            this.props.history.push('/');
            wait(500).then(() => {
                console.log('🔄 Reloading page');
                window.location.reload();
            });
            
            // Force a second reload after 2 seconds to ensure credit is properly loaded
            setTimeout(() => {
                console.log('🔄 Force reloading page to ensure credit display');
                window.location.reload();
            }, 2000);

        } else {
            console.log('❌ Login failed:', data.status);
            this.setState({ submitted: false, disabled: false });
            sendNotfication(data.status, 'success', 'bottom-left');
        }
    };
    handleTwoFactorSubmit = async (e) => {
      e.preventDefault();
      const { twoFactorCode, tempLoginData } = this.state;

      if (!twoFactorCode) {
          sendNotfication('Please enter verification code', 'error', 'bottom-left');
          return;
      }

      this.setState({ disabled: true });
      const token = localStorage.getItem('token');

      try {
          const response = await fetch('https://api.boss707.com/2fa/verify', {
              method: 'POST',
              headers: {
                  'Authorization': `Bearer ${token}`,
                  'Content-Type': 'application/json',
              },
              body: JSON.stringify({
                  uid: tempLoginData.uid,
                  token: twoFactorCode
              })
          });
          const data = await response.json();
          if (data.success) {
              this.setLogin({
                  ...tempLoginData,
                  status: true
              });
          } else {
              this.setState({ 
                  disabled: false,
                  submitted: false 
              });
              sendNotfication('Invalid verification code', 'error', 'bottom-left');
          }
      } catch (error) {
          this.setState({ 
              disabled: false,
              submitted: false 
          });
          sendNotfication('Failed to verify code', 'error', 'bottom-left');
      }
  };

    handleShow = () => {
        this.setState({ show: true, effect: 'zoomIn' });
    }

    handleClose = () => {
        this.setState({ 
            show: false, 
            effect: 'zoomOut', 
            disabled: false, 
            status: false, 
            submitted: false,
            forgetPage: false 
        });
        // Redirect to home page
        this.props.history.push('/');
    }

    handleSubmit = async (e) => {
      e.preventDefault();
      this.setState({ submitted: true, disabled: true, status: 'Please wait' });
      
      const { username, password } = this.state;
      
      if (!(username && password)) {
        console.log('Missing username or password');
        this.setState({ disabled: false, status: false });
        return;
      }
      
      const name = username.toLowerCase();
      console.log('Attempting login for:', name);
      
      wait(200).then(() => {
        const payload = {
          username: name,
          password: password,
          recaptcha: 'google'
        };
        console.log('Emitting login data:', payload);
        socket.emit(C.LOGIN_USER, encode(payload));
      });
    }
    handleInputChange = (e) => {
        this.setState({ [e.target.name]: e.target.value });
    }

    signup = (e) => {
        e.preventDefault();
        this.props.history.push('/signup');
    }

    forgetPass = (e) => {
        e.preventDefault();
        this.setState({ forgetPage: !this.state.forgetPage });
    };
    render() {
      const { 
          show, 
          username, 
          password, 
          disabled, 
          forgetPage,
          showTwoFactorInput,
          twoFactorCode,
          loading,
          showReset2FAModal,
          reset2FAIdentifier,
          showOTPInputModal,
          reset2FAOTP
      } = this.state;
  
      return (
          <>
              {/* <StyledSignInButton onClick={this.handleShow}>
                  Sign in
              </StyledSignInButton> */}
              <StyledModal
                  size="md"
                  centered
                  show={show}
                  onHide={this.handleClose}
                  aria-labelledby="login-modal"
                  className={`animated ${this.state.effect}`}
                  style={{background:"black"}}
              >
                  <CloseButton onClick={this.handleClose}>×</CloseButton>
                  <RightSection>
                      <RightContent>
                          <ModalClose onClick={this.handleClose}>x</ModalClose>
                      </RightContent>
                      <StayUntamed />
                  </RightSection>
                  <LeftSection>
                      {showTwoFactorInput ? (
                          // 2FA Verification Form
                          <>
                              <Title>Two-Factor Authentication</Title>
                              <StyledForm onSubmit={this.handleTwoFactorSubmit}>
                                  <InputWrapper>
                                      <StyledInput
                                          type="text"
                                          name="twoFactorCode"
                                          value={twoFactorCode}
                                          onChange={(e) => this.setState({ 
                                              twoFactorCode: e.target.value 
                                          })}
                                          placeholder="Enter verification code"
                                      />
                                  </InputWrapper>
                                  <SignInButton type="submit" disabled={disabled}>
                                      {disabled ? 'Verifying...' : 'Verify Code'}
                                  </SignInButton>
                                  <ForgotPassword href="#" onClick={this.handleReset2FAModalShow}>
                                      Lost access to 2FA? Reset it
                                  </ForgotPassword>
                              </StyledForm>
                          </>
                      ) : (
                          // Original Login Form or Forgot Password Form
                          !forgetPage ? (
                              <>
                                  <Title>Sign In </Title>
                                  <StyledForm onSubmit={this.handleSubmit}>
                                      <InputWrapper>
                                          <StyledInput
                                              type="text"
                                              name="username"
                                              value={username}
                                              onChange={this.handleInputChange}
                                              placeholder="Username or email"
                                          />
                                      </InputWrapper>
                                      <InputWrapper>
                                          <PasswordWrapper>
                                              <StyledInput
                                                  type={this.state.showPassword ? "text" : "password"}
                                                  name="password"
                                                  value={password}
                                                  onChange={this.handleInputChange}
                                                  placeholder="Password"
                                              />
                                              <PasswordToggle 
                                                  type="button" 
                                                  onClick={this.togglePasswordVisibility}
                                              >
                                                  {this.state.showPassword ? (
                                                      <svg viewBox="0 0 24 24" width="20" height="20">
                                                          <path fill="currentColor" d="M12 7c2.76 0 5 2.24 5 5 0 .65-.13 1.26-.36 1.83l2.92 2.92c1.51-1.26 2.7-2.89 3.43-4.75-1.73-4.39-6-7.5-11-7.5-1.4 0-2.74.25-3.98.7l2.16 2.16C10.74 7.13 11.35 7 12 7zM2 4.27l2.28 2.28.46.46C3.08 8.3 1.78 10.02 1 12c1.73 4.39 6 7.5 11 7.5 1.55 0 3.03-.3 4.38-.84l.42.42L19.73 22 21 20.73 3.27 3 2 4.27zM7.53 9.8l1.55 1.55c-.05.21-.08.43-.08.65 0 1.66 1.34 3 3 3 .22 0 .44-.03.65-.08l1.55 1.55c-.67.33-1.41.53-2.2.53-2.76 0-5-2.24-5-5 0-.79.20-1.53.53-2.2zm4.31-.78l3.15 3.15.02-.16c0-1.66-1.34-3-3-3l-.17.01z"/>
                                                      </svg>
                                                  ) : (
                                                      <svg viewBox="0 0 24 24" width="20" height="20">
                                                          <path fill="currentColor" d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/>
                                                      </svg>
                                                  )}
                                              </PasswordToggle>
                                          </PasswordWrapper>
                                      </InputWrapper>
                                      <ForgotPassword href="#" onClick={this.forgetPass}>
                                          Forgot your password?
                                      </ForgotPassword>
                                      <SignInButton type="submit" disabled={disabled}>
                                          {disabled ? 'Signing in...' : 'Sign In'}
                                      </SignInButton>
                                  </StyledForm>
                              
                                  {/* <SignUpPrompt>
                                      Don't have an agent account?
                                      <a>Contact admin</a>
                                  </SignUpPrompt> */}
                              </>
                          ) : (
                              // Forgot Password Form
                              <StyledForm onSubmit={this.handleSubmitForgot}>
                                  <Title>Reset Password</Title>
                                  <InputWrapper>
                                      <StyledInput
                                          type="email"
                                          name="email"
                                          placeholder="Enter your email"
                                          onChange={this.handleInputEmailChange}
                                      />
                                  </InputWrapper>
                                  <SignInButton type="submit" disabled={disabled}>
                                      {disabled ? 'Loading...' : 'Reset Password'}
                                  </SignInButton>
                                  <SignUpPrompt>
                                      Remember your password?
                                      <a href="#" onClick={this.forgetPass}>Sign in</a>
                                  </SignUpPrompt>
                              </StyledForm>
                          )
                      )}
                  </LeftSection>
              </StyledModal>
  
              {/* 2FA Reset Modal */}
              <StyledModal
                  size="md"
                  centered
                  show={showReset2FAModal}
                  onHide={this.handleReset2FAModalClose}
                  aria-labelledby="reset-2fa-modal"
                  className={`animated ${this.state.effect}`}
              >
                  <CloseButton onClick={this.handleReset2FAModalClose}>×</CloseButton>
                  <LeftSection>
                      {showOTPInputModal ? (
                          <>
                              <Title>Verify OTP</Title>
                              <StyledForm onSubmit={this.handleReset2FAOTPSubmit}>
                                  <InputWrapper>
                                      <StyledInput
                                          type="text"
                                          name="reset2FAOTP"
                                          value={reset2FAOTP}
                                          onChange={this.handleReset2FAOTPChange}
                                          placeholder="Enter OTP"
                                      />
                                  </InputWrapper>
                                  <SignInButton type="submit" disabled={disabled}>
                                      {disabled ? 'Verifying...' : 'Verify OTP'}
                                  </SignInButton>
                              </StyledForm>
                          </>
                      ) : (
                          <>
                              <Title>Reset 2FA</Title>
                              <StyledForm onSubmit={this.handleReset2FASubmit}>
                                  <InputWrapper>
                                      <StyledInput
                                          type="text"
                                          name="reset2FAIdentifier"
                                          value={reset2FAIdentifier}
                                          onChange={this.handleReset2FAIdentifierChange}
                                          placeholder="Enter your email or username"
                                      />
                                  </InputWrapper>
                                  <SignInButton type="submit" disabled={disabled}>
                                      {disabled ? 'Sending...' : 'Send OTP'}
                                  </SignInButton>
                              </StyledForm>
                          </>
                      )}
                  </LeftSection>
              </StyledModal>
          </>
      );
  }
  //   render() {
  //     const { 
  //         show, 
  //         username, 
  //         password, 
  //         disabled, 
  //         forgetPage,
  //         showTwoFactorInput,
  //         twoFactorCode ,
  //         loading,
  //         showReset2FAModal,
  //       reset2FAIdentifier,
  //       showOTPInputModal,
  //       reset2FAOTP
  //     } = this.state;
    
  //     return (
  //         <>
  //             <StyledSignInButton onClick={this.handleShow}>
  //                 Sign in
  //             </StyledSignInButton>
  //             <StyledModal
  //                 size="md"
  //                 centered
  //                 show={show}
  //                 onHide={this.handleClose}
  //                 aria-labelledby="login-modal"
  //                 className={`animated ${this.state.effect}`}
  //             >
  //                 <CloseButton onClick={this.handleClose}>×</CloseButton>
  //                 <RightSection>
  //                     <RightContent>
  //                         <ModalClose onClick={this.handleClose}>x</ModalClose>
  //                     </RightContent>
  //                     <StayUntamed />
  //                 </RightSection>
  //                 <LeftSection>
  //                     {showTwoFactorInput ? (
  //                         // 2FA Verification Form
  //                         <>
  //                             <Title>Two-Factor Authentication</Title>
  //                             <StyledForm onSubmit={this.handleTwoFactorSubmit}>
  //                                 <InputWrapper>
  //                                     <StyledInput
  //                                         type="text"
  //                                         name="twoFactorCode"
  //                                         value={twoFactorCode}
  //                                         onChange={(e) => this.setState({ 
  //                                             twoFactorCode: e.target.value 
  //                                         })}
  //                                         placeholder="Enter verification code"
  //                                     />
  //                                 </InputWrapper>
  //                                 <SignInButton type="submit" disabled={disabled}>
  //                                     {disabled ? 'Verifying...' : 'Verify Code'}
  //                                 </SignInButton>
  //                             </StyledForm>
  //                         </>
  //                     ) : (
  //                         // Original Login Form
  //                         !forgetPage ? (
  //                             <>
  //                                 <Title>Sign In</Title>
  //                                 <StyledForm onSubmit={this.handleSubmit}>
  //                                     <InputWrapper>
  //                                         <StyledInput
  //                                             type="text"
  //                                             name="username"
  //                                             value={username}
  //                                             onChange={this.handleInputChange}
  //                                             placeholder="Username or email"
  //                                         />
  //                                     </InputWrapper>
  //                                     <InputWrapper>
  //                                         <PasswordWrapper>
  //                                             <StyledInput
  //                                                 type={this.state.showPassword ? "text" : "password"}
  //                                                 name="password"
  //                                                 value={password}
  //                                                 onChange={this.handleInputChange}
  //                                                 placeholder="Password"
  //                                             />
  //                                             <PasswordToggle 
  //                                                 type="button" 
  //                                                 onClick={this.togglePasswordVisibility}
  //                                             >
  //                                                 {this.state.showPassword ? (
  //                                                     <svg viewBox="0 0 24 24" width="20" height="20">
  //                                                         <path fill="currentColor" d="M12 7c2.76 0 5 2.24 5 5 0 .65-.13 1.26-.36 1.83l2.92 2.92c1.51-1.26 2.7-2.89 3.43-4.75-1.73-4.39-6-7.5-11-7.5-1.4 0-2.74.25-3.98.7l2.16 2.16C10.74 7.13 11.35 7 12 7zM2 4.27l2.28 2.28.46.46C3.08 8.3 1.78 10.02 1 12c1.73 4.39 6 7.5 11 7.5 1.55 0 3.03-.3 4.38-.84l.42.42L19.73 22 21 20.73 3.27 3 2 4.27zM7.53 9.8l1.55 1.55c-.05.21-.08.43-.08.65 0 1.66 1.34 3 3 3 .22 0 .44-.03.65-.08l1.55 1.55c-.67.33-1.41.53-2.2.53-2.76 0-5-2.24-5-5 0-.79.2-1.53.53-2.2zm4.31-.78l3.15 3.15.02-.16c0-1.66-1.34-3-3-3l-.17.01z"/>
  //                                                     </svg>
  //                                                 ) : (
  //                                                     <svg viewBox="0 0 24 24" width="20" height="20">
  //                                                         <path fill="currentColor" d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/>
  //                                                     </svg>
  //                                                 )}
  //                                             </PasswordToggle>
  //                                         </PasswordWrapper>
  //                                     </InputWrapper>
  //                                     <ForgotPassword href="#" onClick={this.forgetPass}>
  //                                         Forgot your password?
  //                                     </ForgotPassword>
  //                                     <SignInButton type="submit" disabled={disabled}>
  //                                         {disabled ? 'Signing in...' : 'Sign In'}
  //                                     </SignInButton>
  //                                 </StyledForm>
  //                                 <Divider>or continue with</Divider>
  //                                 <SocialLoginContainer>
  //                                     <Google />
  //                                 </SocialLoginContainer>
  //                                 <SignUpPrompt>
  //                                     Don't have an account?
  //                                     <a href="#" onClick={this.signup}>Sign up</a>
  //                                 </SignUpPrompt>
  //                             </>
  //                         ) : (
  //                             // Forgot Password Form
  //                             <StyledForm onSubmit={this.handleSubmitForgot}>
  //                             <Title>Reset Password</Title>
  //                             <InputWrapper>
  //                                 <StyledInput
  //                                     type="email"
  //                                     name="email"
  //                                     placeholder="Enter your email"
  //                                     onChange={this.handleInputEmailChange}
  //                                 />
  //                             </InputWrapper>
  //                             <SignInButton type="submit" disabled={disabled}>
  //                              {disabled ? 'Loading...' : 'Reset Password'}
  //                             </SignInButton>
  //                             <SignUpPrompt>
  //                                 Remember your password?
  //                                 <a href="#" onClick={this.forgetPass}>Sign in</a>
  //                             </SignUpPrompt>
  //                         </StyledForm>
  //                         )
  //                     )}
  //                 </LeftSection>
  //             </StyledModal>
  //         </>
  //     );
  // }
}

export default AgentLoginModal;