import React, { useEffect, useState } from 'react';
import styled from 'styled-components';
import {
  getUID, isMobile, SITE_URL,
  encode, wait, decode, sendNotfication
} from '../../../Helper';
import { X } from 'lucide-react';
import BonusDetails from './BonusDetailsTable';
import BonusMobile from './BonusMobile';
import { useHistory } from 'react-router-dom';
import LockIcon from '../../../Icons/LockIcon';


import { Modal } from 'react-bootstrap';
import socket from "../../../Socket";
import storage from "../../../Storage";
import C from "../../../Constant";
import { keyframes } from 'styled-components';
import SkylaDepositModal from '../Wallet/Deposit/ModalContent';


const Container = styled.div`
  display: grid;
  grid-template-columns: 1.7fr 1fr;
  gap: 20px;
  max-width: 1200px;
  margin: 0 auto;

  @media (max-width: 768px) {
    grid-template-columns: 1fr;
  }
`;

const Header = styled.div`
  grid-column: 1 / -1;
  display: flex;
  justify-content: space-between;
  align-items: center;
  // margin-bottom: 20px;
`;

const Title = styled.h1`
  color: white;
  font-size: 20px;
  margin: 0;
  font-weight:bold
`;
const Title1 = styled.h1`
  color: white;
  font-size: 18px;
  font-weight:bold;
  margin-bottom: 10px;
`;
const RedeemWrapper = styled.div`
  position: relative;
  width: 400px;
    background: rgba(0, 0, 0, 0.2);
  border-radius: 5px;
  border: 1px solid rgba(255, 255, 255, 0.1);
  display: flex;
  align-items: center;
`;

const RedeemInput = styled.input`
 background: rgba(0, 0, 0, 0.2);
  border: none;
  border-radius: 4px;
  color: white;
  padding: 8px 120px 8px 12px;
  width: 100%;
  height: 36px;
  font-size: 14px;

  &::placeholder {
    color: rgba(255, 255, 255, 0.5);
  }

`;

const RedeemButton = styled.div`
  position: absolute;
  right: 4px;
  top: 50%;
  transform: translateY(-50%);
  background: #f09c06;
  color: white;
  border: none;
  text-align:center;
  border-radius: 6px;
  padding: 6px 8px;
  cursor: pointer;
  font-size: 13px;
  height: 28px;
  display: flex;
  align-items: center;
  gap: 6px;
  transition: background 0.2s ease;

  &:hover {
    background: #4F5253;
  }

  &::before {
    content: '';
    display: inline-block;
    width: 14px;
    height: 14px;
    background-size: contain;
    transform: rotate(180deg);
  }
`;


const BonusCard = styled.div`
  background: linear-gradient(274deg, 
    rgba(43, 100, 130, 0) 14.01%,
    rgba(59, 163, 100, 0.8) 146.96%
  );
  border-radius: 12px;
  padding: 24px;
  height: 100%;
  position: relative;
  overflow: hidden;
  box-shadow: 
    0 25px 50px -12px rgba(0, 0, 0, 0.25),
    inset 0 1px 0 rgba(255, 255, 255, 0.1);
  transition: transform 0.2s ease;

  &:hover {
    transform: translateY(-2px);
    box-shadow: 
      0 30px 60px -12px rgba(0, 0, 0, 0.3),
      inset 0 1px 0 rgba(255, 255, 255, 0.1);
  }
`;

const BonusContent = styled.div`
  position: relative;
  z-index: 1;
  width: 60%;
`;

const BonusCardImage = styled.img`
  position: absolute;
  right: -5%;
  top: 50%;
  transform: translateY(-50%);
  height: 120%;
  z-index: 0;
  opacity: 0.8;
  object-fit: contain;

  @media (max-width: 768px) {
    opacity: 0.4;
    right: -20%;
  }
`;

const TotalAmount = styled.div`
  font-size: 32px;
  color: white;
  font-weight: bold;
  margin-bottom: 30px;
`;

const BonusTypes = styled.div`
  display: flex;
  justify-content: space-between;
  gap: 20px;
  margin-bottom: 30px;
`;

const BonusType = styled.div`
  .label {
    color: rgba(255, 255, 255, 0.6);
    font-size: 14px;
    margin-bottom: 8px;
  }
  
  .amount {
    color: white;
    font-size: 16px;
    font-weight: bold;
  }
`;
const BonusType1 = styled.div`
  .label {
    color: rgba(255, 255, 255, 0.6);
    font-size: 14px;
   
  }
  
  .amount {
    color: white;
    font-size: 16px;
    font-weight: bold;
  }
`;


const DetailsButton = styled.button`
  background: transparent;
  border: none;
  color: rgba(255, 255, 255, 0.8);
  cursor: pointer;
  font-size: 16px;
  padding: 0;
  display: flex;
  align-items: center;
  gap: 4px;

  &:hover {
    color: white;
  }
`;

const DepositBonusCard = styled.div`
  background: linear-gradient(86deg, rgba(255, 164, 49, 0) 65.46%, rgba(255, 136, 3, .3) 130.45%), linear-gradient(288deg, rgba(255, 164, 49, 0) 21.4%, rgba(255, 136, 3, .3) 116.92%);
  border-radius: 12px;
  padding: 24px;
  height: 100%;
  position: relative;
`;

const DepositHeader = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
`;

const BonusAmount1 = styled.div`
  color: #fff;
  font-size: 20px;
  font-weight: bold;
`;
const BonusAmount = styled.div`
  color: #8B8B85;
  font-size: 14px;
  font-weight: bold;
`;

const BonusTimer = styled.div`
  color: rgba(255, 255, 255, 0.6);
  font-size: 14px;
`;

const DepositButton = styled.div`
  background: #f09c06;
   padding: 7px 14px;
  border-radius: 6px;
  border: none;
  font-weight: bold;
  font-size: 14px;
  color: black !important;
  cursor: pointer;
  transition: opacity 0.2s ease;
  &:hover {
    opacity: 0.9;
  }
`;

const ProgressContainer = styled.div`
  position: relative;
  padding-top: 10px;
`;

const ProgressBar = styled.div`
  position: relative;
  height: 4px;
  background: #333;
 

  &::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    height: 100%;
    width: ${props => props.onProgress}%;
    background: linear-gradient(90deg, #FFD700, #FFA500);
  }
`;

const ProgressPoints = styled.div`
  display: flex;
  justify-content: space-between;
  // margin-top: 20px;
  padding: 0 0px;
`;

const ProgressPoint = styled.div`
  color: ${props => props.active ? '#FFD700' : 'white'};
  font-weight: ${props => props.active ? 'bold' : 'normal'};
  font-size: 16px;
  text-align: center;
  
  img {
    width: 70px;
    height: 70px;
    margin-bottom: 4px;
  }
`;



const GridContainer = styled.div`
  display: grid;
  grid-template-columns: repeat(4, 1fr);
  gap: 20px;
`;


const CardBG = styled.div`
  background-color: rgb(50, 55, 56);
    border-radius: 12px;
    position:relative;
`;


const ModalOverlay = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0, 0, 0, 0.5);
  display: ${props => props.$show ? 'flex' : 'none'};
  justify-content: center;
  align-items: center;
  z-index: 1050;
  padding: 20px;

  @media (max-width: 768px) {
    padding: 0;
  }
`;

const ModalContent = styled.div`
  background:rgb(18, 20, 24);
  border-radius: 12px;
  width: 100%;
  max-width: 500px;
  max-height: 80vh;
  position: relative;
  animation: modalFadeIn 0.3s ease-out;
  display: flex;
  flex-direction: column;

  @media (max-width: 768px) {
    max-width: 100%;
    max-height: 100vh;
    height: 100vh;
    border-radius: 0;
  }

  @keyframes modalFadeIn {
    from {
      opacity: 0;
      transform: translateY(-20px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }
`;

const ModalHeader = styled.div`
  height: 50px;
  background: rgb(30, 35, 40);
  display: flex;
  align-items: center;
  justify-content: center;
  position: relative;
  border-top-left-radius: 12px;
  border-top-right-radius: 12px;

  @media (max-width: 768px) {
    border-radius: 0;
    height: 60px;
  }
`;

const ModalTitle = styled.h3`
  color: white;
  margin: 0;
  font-size: 16px;
  font-weight: 500;
`;

const CloseButton = styled.button`
  position: absolute;
  right: 8px;
  top: 50%;
  transform: translateY(-50%);
  background: transparent;
  border: none;
  color: #6F767E;
  width: 30px;
  height: 30px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  cursor: pointer;
  
  &:hover {
    color: #fff;
  }
`;

const ModalBody = styled.div`
  padding: 16px;
  color: white;
      background:rgb(18, 20, 24);
  overflow-y: auto;
  height: 100%;

  &::-webkit-scrollbar {
    width: 6px;
  }
  
  &::-webkit-scrollbar-track {
    background: transparent;
  }
  
  &::-webkit-scrollbar-thumb {
    background: #666;
    border-radius: 3px;
  }

  @media (max-width: 768px) {
    padding: 12px 8px;
  }
`;

const DepositInfo = styled.div`
  background-color: #2A2D35;
  border-radius: 8px;
  padding: 16px;
  margin-bottom: 20px;
`;

const QRContainer = styled.div`
  background-color: white;
  padding: 16px;
  border-radius: 8px;
  width: fit-content;
  margin: 20px auto;
`;

const AddressContainer = styled.div`
  background-color: #2A2D35;
  border-radius: 8px;
  padding: 12px;
  margin-top: 20px;
  display: flex;
  justify-content: space-between;
  align-items: center;
`;

const Address = styled.input`
  background: none;
  border: none;
  color: white;
  width: 100%;
  margin-right: 12px;
  outline: none;
  font-family: monospace;
`;

const CopyButton = styled.button`
  background: linear-gradient(90deg, rgb(36, 238, 137), rgb(159, 232, 113));
  color: black;
  border: none;
  border-radius: 6px;
  padding: 8px 16px;
  font-weight: 600;
  cursor: pointer;
  
  &:hover {
    opacity: 0.9;
  }
`;






const Card = styled.div`
 background: ${props => props.$background || '#2b2b3d'};
border-radius: 12px;
  padding: 10px 9px;
  display: flex;
  flex-direction: column;
  align-items: center;
  min-height: 250px;
  backdrop-filter: blur(40px);
  -webkit-backdrop-filter: blur(40px); /* For Safari support */

`;

const ImagePlaceholder = styled.img`
  width: 120px;
  height: 120px;
  object-fit:contain;
`;

const CardTitle = styled.h3`
  color: white;
  font-size: 18px;
  margin: 4px 0
  font-weight: 600;
`;

const StatsContainer = styled.div`
  width: 100%;
  margin: 10px 0;
`;
const ContainerBottom = styled.div`
  background-color: #272B2C;
  border-radius: 8px;
  padding: 8px;
  width: 100%;
  margin-top: 20px;
  min-height:100px;
`;


const StatRow = styled.div`
  display: flex;
  justify-content: center;
  align-items:center;
  color: #9ca3af;
  margin: 5px 0;
  font-size: 12px;
`;

const ClaimButton = styled.button`
  width: 100%;
  padding: 12px;
  border-radius: 8px;
  background: ${({ $amount }) => ($amount > 0 ? '#f09c06' : 'rgba(255, 255, 255, 0.1)')};
  color: ${({ $amount }) => ($amount > 0 ? 'white' : 'white')};
  border: none;
  cursor: ${({ $amount }) => ($amount > 0 ? 'pointer' : 'not-allowed')};
  margin-top: 25px;

  &:hover {
    background: ${({ $amount }) => ($amount > 0 ? '#f09c06' : 'rgba(255, 255, 255, 0.1)')};
  }
`;

const ClaimButton2 = styled.button`
  width: 100%;
  padding: 12px;
  border-radius: 8px;
  background: ${({ $eligible, $claimable }) => {
    if (!$eligible) return 'rgba(255, 255, 255, 0.1)'; // Not eligible
    if ($eligible && !$claimable) return 'rgba(255, 255, 255, 0.1)'; // Eligible but not claimable (claimable is undefined or falsy)
    return '#f09c06'; // Eligible and claimable (claimable is an object, truthy)
  }};
  color: white;
  border: none;
  cursor: ${({ $eligible, $claimable }) => ($eligible && $claimable ? 'pointer' : 'not-allowed')};
  margin-top: 25px;

  &:hover {
    background: ${({ $eligible, $claimable }) => {
    if (!$eligible) return 'rgba(255, 255, 255, 0.1)'; // Not eligible
    if ($eligible && !$claimable) return 'rgba(255, 255, 255, 0.1)'; // Eligible but not claimable
    return '#f09c06'; // Eligible and claimable
  }};
  }

  &:disabled {
    opacity: 0.5;
    cursor: not-allowed;
  }
`;
const ClaimButton1 = styled.button`
   width: 100%;
  padding: 12px;
  border-radius: 8px;
  background: ${({ amount }) => (amount > 0 ? '#f09c06' : a)};
  color: ${({ amount }) => (amount > 0 ? 'white' : 'white')};
  border: none;
  cursor: pointer;
  margin-top: 25px;

  &:hover {
    background: ${({ amount }) => (amount > 0 ? '#f09c06' : 'rgba(255, 255, 255, 0.1)')};
  }
`;

const Timer = styled.span`
  color: #9ca3af;
  font-size: 14px;
`;
import { Info } from 'lucide-react';

// Add styled components
const InfoIconWrapper = styled.div`
  position: absolute;
  top: 16px;
  right: 16px;
  z-index: 10;
  cursor: pointer;
  transition: transform 0.2s ease;

  &:hover {
    transform: scale(1.1);
  }
`;

const InfoModalContent = styled(ModalContent)`
  background: #1E2024;
  max-width: 480px;
  border-radius: 12px;
  border: 1px solid rgba(255, 255, 255, 0.1);
`;

const InfoList = styled.ul`
  list-style: none;
  padding: 0;
  margin: 0;

  li {
    padding: 6px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    color: rgba(255, 255, 255, 0.8);
    font-size: 14px;
    display: flex;
    align-items: center;
    gap: 10px;

    &:last-child {
      border-bottom: none;
    }

    &:before {
      content: "•";
      color: #D8AB59;
      font-size: 20px;
    }
  }
`;

// Add modal content data
const BONUS_INFO = {
  dailyBonus: {
    title: "Daily Bonus",
    points: [
      "Login daily to claim your bonus rewards",
      "Available for VIP level 25 and above",
      "Bonus amount increases with VIP level",
      "Must be claimed within 24 hours",
      "Wagering requirements may apply"
    ]
  },
  sports: {
    title: "Sports Bonus",
    points: [
      "Get a 300% bonus on your sports deposit",
      "Minimum deposit required: $10",
      "Wagering requirement: 30x the bonus amount",
      "Available for all registered users",
      "Applies to selected sports betting markets"
    ]
  },
  sportsclaim: {
    title: "Sports Stats for claim",
    points: [
      "Status Pending ",
      "Progress Percent is 40%",
      "Wagering requirement: 30x the bonus amount",
      "Wager progress is 40%",
      "Applies to selected sports betting markets"
    ]
  },
  casino: {
    title: "Casino Bonus",
    points: [
      "Enjoy a 300% bonus on your casino deposit",
      "Minimum deposit required: $10",
      "Wagering requirement: 30x the bonus amount",
      "Available on selected slot and table games",
      "Claimable once per user per promotion"
    ]
  },
  casinoclaim: {
    title: "Casino Stats for claim",
    points: [
      "Status Pending ",
      "Progress Percent is 40%",
      "Wagering requirement: 30x the bonus amount",
      "Wager progress is 40%",
      "Applies to selected sports betting markets"
    ]
  },

  rakeback: {
    title: "Rakeback Bonus",
    points: [
      "Earn back a percentage of your house edge",
      "No minimum bet requirements",
      "Available for all casino games",
      "Instant crediting to your account",
      "Higher percentages for VIP members"
    ]
  },
  vaultPro: {
    title: "Vault Pro",
    points: [
      "Secure storage for your assets",
      "Earn interest on your deposits",
      "No minimum deposit required",
      "Daily interest payouts",
      "Flexible withdrawal options"
    ]
  },
  welcomeBonus: {
    title: "Welcome Bonus",
    points: [
      "One-time bonus for VIP 11 members",
      "Must be claimed within 7 days",
      "Bonus credited instantly",
      "Wagering requirements apply",
      "Exclusive VIP welcome reward"
    ]
  },
  weeklyCashback: {
    title: "Weekly Cashback",
    points: [
      "The Weekly Cashback is a personalized bonus based on your recent activity",
      "We aim to drop Weekly Cashback every Friday.",

    ]
  },
  monthlyCashback: {
    title: "Monthly Cashback",
    points: [
      "The Monthly Cashback is a personalized bonus based on your recent activity.s",
      "We aim to drop Monthly Cashback every 15th of the month.",

    ]
  },
  sportsBonus: {
    title: "Sports Weekly Bonus",
    points: [
      "7d Sports Wager:",
      "$500.00-$2,499.00 = $5.00 Bonus",
      "$2,500.00-$4,999.00 = $30.00 Bonus",
      "$5,000.00-$9,999.00 = $70.00 Bonus",
      "$10,000.00-$49,999.00 = $150.00 Bonus",
      "$50,000.00-$249,999.00 = $500.00 Bonus",
      "$250,000.00+ = $1,000.00 Bonus",
      "Wager period Saturday 00:00 hrs ~ Friday 23:59hrs (7days)",
      "We aim to drop Weekly Bonus every Saturday."
    ]
  }
};

const BackButton = styled.div`
  position: absolute;
  top: 10px;
  right: 4px;
  background: transparent;
  height: 24px;
  width: 24px;
  z-index: 20;
  cursor: pointer;
`;

const ReedeemButton = styled.button`
  background: #917663;
  border: none;
  color: rgba(255, 255, 255, 0.6);
  cursor: pointer;
  font-size: 12px;
  padding: 4px 18px;
  display: flex;
  align-items: center;
  border-radius: 4px;
  gap: 4px;
  margin-top: 24px;
  &:hover {
    color: white;
  }
`;







const ScrollableContent = styled.div`
  flex: 1;
  overflow-y: scroll; /* Changed to scroll for better mobile support */
  overflow-x: hidden;
  margin-top: 56px;
  -webkit-overflow-scrolling: touch; /* Momentum scrolling for iOS */
  padding: 0 12px 120px 12px; /* Increased bottom padding */
  min-height: 0; /* Prevents flex shrinkage issues */
  max-height: calc(100vh - 267px); /* Explicit max-height */
  -ms-overflow-style: none; /* Hide scrollbar for IE/Edge */
  scrollbar-width: none; /* Hide scrollbar for Firefox */
  touch-action: pan-y; /* Enable vertical touch scrolling */
  
  &::-webkit-scrollbar {
    display: none; /* Hide scrollbar for Chrome/Safari */
  }
  
  /* iOS-specific adjustments */
  @media (max-width: 768px) {
    padding-bottom: 150px; /* Extra padding for iOS */
    max-height: calc(100vh - 267px - env(safe-area-inset-bottom)); /* Respect safe areas */
  }
`;

const TabContainer = styled.div`
  margin-left: 0.5rem;
  display: flex;
  width: 100%;
  gap: 16px;
  justify-content: center;
  padding: 16px 0;
`;

const TabButton = styled.div`
  padding: 0.1rem 0.5rem;
  font-size: 0.9rem;
  font-weight: 500;
  transition: all 0.2s;
  border-bottom: ${props => props.$active ? '2px solid #f09c06' : 'none'};
  color: ${props => props.$active ? 'white' : '#9ca3af'};
  background-color: transparent;
  cursor: pointer;
  &:hover {
    color: white;
  }
`;

const GridContainer1 = styled.div`
  display: grid;
  grid-template-columns: repeat(1, 1fr);
  gap: 20px;
  padding: 12px;
`;


const ContentWrapper = styled.div`
  flex: 1;
  width: 100%;
  position: relative;
  margin-bottom: 20px;
`;


const ButtonWrapper = styled.div`
  display: flex;
  justify-content: flex-end;
  width: 100%;
  margin-top: 24px;
`;






const ModalOverlay1 = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0, 0, 0, 0.5);
  display: ${props => props.show ? 'flex' : 'none'};
  justify-content: center;
  align-items: center;
  z-index: 1050;
  padding: 20px;
  @media (max-width: 768px) {
    padding: 0px;
  }
`;

const ModalContent1 = styled.div`
  background: rgb(18, 20, 24);
  border-radius: 12px;
  width: 100%;
  max-width: 570px;
  position: relative;
  animation: modalFadeIn 0.3s ease-out;
  min-height: 400px;
  max-height: 76vh;
  display: flex;
  flex-direction: column;
  @keyframes modalFadeIn {
    from {
      opacity: 0;
      transform: translateY(-20px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }
  @media (max-width: 768px) {
    height: 100vh;
    max-height: 76vh;
  }
`;

const ModalHeader1 = styled.div`
  display: grid;
  grid-template-columns: 24px 1fr 24px;
  align-items: center;
  padding: 16px 24px;
  border-bottom: 1px solid #2A2D35;
  flex-shrink: 0;
  background: rgb(30, 35, 40);
  border-top-left-radius: 12px;
  border-top-right-radius: 12px;
`;

const ModalTitle1 = styled.h4`
  color: white;
  margin: 0;
  font-size: 18px;
  font-weight: 600;
  text-align: center;
  grid-column: 2;
`;

const CloseButton1 = styled.button`
  background: none;
  border: none;
  color: #6F767E;
  cursor: pointer;
  padding: 4px;
  display: flex;
  align-items: center;
  justify-content: center;
  grid-column: 3;
  margin-left: auto;
  &:hover {
    color: white;
  }
`;

const ModalBody1 = styled.div`
  padding: 24px;
  color: white;
  overflow-y: auto;
  flex-grow: 1;
  &::-webkit-scrollbar {
    width: 6px;
  }
  &::-webkit-scrollbar-track {
    background: #2A2D35;
    border-radius: 3px;
  }
  &::-webkit-scrollbar-thumb {
    background: #454951;
    border-radius: 3px;
  }
  &::-webkit-scrollbar-thumb:hover {
    background: #555;
  }
  @media (max-width: 768px) {
    padding: 12px 14px;
    height: 100vh;
  }
`;

const StyledModal = styled(Modal)`
  .modal-content {
    background: rgb(18, 20, 24);
    color: white;
  }
  .modal-header {
    border-bottom: none;
  }
  .modal-title {
    color: white;
  }
  .modal-body {
    padding: 20px;
    background: rgb(18, 20, 24);
  }
`;

const InputField = styled.input`
  width: 100%;
  padding: 10px;
  border-radius: 8px;
  border: 1px solid #ccc;
  background: rgba(0, 0, 0, 0.2);
  color: white;
  margin-top: 10px;
  &::placeholder {
    color: rgba(255, 255, 255, 0.5);
  }
`;


const MobileContainer = styled.div`
  height: 100vh;
  width: 100%;
  color: white;
  background: #111418;
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  display: flex;
  flex-direction: column;
  overflow: hidden; /* Prevent container from scrolling */
`;

const MobileBackButton = styled.div`
  position: absolute;
  top: 10px;
  right: 4px;
  background: transparent;
  height: 24px;
  width: 24px;
  z-index: 20;
  cursor: pointer;
`;

const MobileInnerContainer = styled.div`
  flex-shrink: 0;
  background: #111418;
  z-index: 10;
  position: relative;
  top: 67px;
`;

const MobileBonusCard = styled.div`
  background: linear-gradient(
    274deg,
    rgba(246, 105, 44, 0) 14.01%,
    rgba(246, 105, 44, 0.6) 146.96%
  );
  padding: 24px;
  height: 200px;
  width: 100%;
  position: relative;
  overflow: hidden;
  box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
`;

const MobileBonusContent = styled.div`
  position: relative;
  z-index: 1;
  width: 60%;
`;

const MobileTotalAmount = styled.div`
  font-size: 21px;
  color: white;
  font-weight: bold;
  margin-bottom: 0px;
  margin-top: -20px;
`;

const MobileBonusType1 = styled.div`
  margin-top: -30px;
  .label {
    color: rgba(255, 255, 255, 0.6);
    font-size: 14px;
  }
  .amount {
    color: white;
    font-size: 16px;
    font-weight: bold;
  }
`;

const MobileModalContent = styled.div`
  background: rgb(18, 20, 24);
  border-radius: 12px;
  width: 100%;
  max-width: 480px;
  height: 45%;
  position: relative;
  animation: modalFadeIn 0.3s ease-out;
  display: flex;
  flex-direction: column;
  @keyframes modalFadeIn {
    from {
      opacity: 0;
      transform: translateY(-20px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }
`;

const MobileDetailsButton = styled.button`
  background: transparent;
  border: none;
  color: rgba(255, 255, 255, 0.6);
  cursor: pointer;
  font-size: 12px;
  padding: 0;
  display: flex;
  align-items: center;
  gap: 4px;
  &:hover {
    color: white;
  }
`;

const MobileReedeemButton = styled.button`
  background: #917663;
  border: none;
  color: rgba(255, 255, 255, 0.6);
  cursor: pointer;
  font-size: 12px;
  padding: 4px 18px;
  display: flex;
  align-items: center;
  border-radius: 4px;
  gap: 4px;
  margin-top: 24px;
  &:hover {
    color: white;
  }
`;

const MobileBonusCardImage = styled.img`
  position: absolute;
  top: 90px;
  right: -16px;
  transform: translateY(-50%);
  width: 80%;
  z-index: 0;
  opacity: 0.8;
  object-fit: cover;
`;

const MobileScrollableContent = styled.div`
  flex: 1;
  overflow-y: scroll; /* Changed to scroll for better mobile support */
  overflow-x: hidden;
  margin-top: 56px;
  -webkit-overflow-scrolling: touch; /* Momentum scrolling for iOS */
  padding: 0 12px 120px 12px; /* Increased bottom padding */
  min-height: 0; /* Prevents flex shrinkage issues */
  max-height: calc(100vh - 267px); /* Explicit max-height */
  -ms-overflow-style: none; /* Hide scrollbar for IE/Edge */
  scrollbar-width: none; /* Hide scrollbar for Firefox */
  touch-action: pan-y; /* Enable vertical touch scrolling */
  
  &::-webkit-scrollbar {
    display: none; /* Hide scrollbar for Chrome/Safari */
  }
  
  /* iOS-specific adjustments */
  @media (max-width: 768px) {
    padding-bottom: 150px; /* Extra padding for iOS */
    max-height: calc(100vh - 267px - env(safe-area-inset-bottom)); /* Respect safe areas */
  }
`;

const MobileTabContainer = styled.div`
  margin-left: 0.5rem;
  display: flex;
  width: 100%;
  gap: 16px;
  justify-content: center;
  padding: 16px 0;
`;

const MobileTabButton = styled.div`
  padding: 0.1rem 0.5rem;
  font-size: 0.9rem;
  font-weight: 500;
  transition: all 0.2s;
  border-bottom: ${props => props.$active ? '2px solid #f09c06' : 'none'};
  color: ${props => props.$active ? 'white' : '#9ca3af'};
  background-color: transparent;
  cursor: pointer;
  &:hover {
    color: white;
  }
`;

const MobileGridContainer1 = styled.div`
  display: grid;
  grid-template-columns: repeat(1, 1fr);
  gap: 20px;
  padding: 12px;
`;

const MobileCardBG = styled.div`
  background-color: rgb(50, 55, 56);
  border-radius: 12px;
  position: relative;
`;

const MobileCard = styled.div`
  background: ${props => props.$background || '#2b2b3d'};
  border-radius: 12px;
  padding: 16px;
  display: flex;
  align-items: center;
  position: relative;
  gap: 16px;
  min-height: 150px;
  backdrop-filter: blur(40px);
  -webkit-backdrop-filter: blur(40px);
`;

const MobileContentWrapper = styled.div`
  flex: 1;
  width: 100%;
  position: relative;
  margin-bottom: 20px;
`;

const MobileImagePlaceholder = styled.img`
  width: 100px;
  height: 100px;
  object-fit: contain;
`;

const MobileCardTitle = styled.h3`
  color: white;
  font-size: 16px;
  margin: 4px 0;
  font-weight: 600;
`;

const MobileStatRow = styled.div`
  color: #9ca3af;
  font-size: 12px;
`;

const MobileButtonWrapper = styled.div`
  display: flex;
  justify-content: flex-end;
  width: 100%;
  margin-top: 24px;
`;

const MobileInfoModalContent = styled(MobileModalContent)`
  background: rgb(18, 20, 24);
  max-width: 480px;
  border-radius: 12px;
  border: 1px solid rgba(255, 255, 255, 0.1);
`;

const MobileInfoList = styled.ul`
  list-style: none;
  padding: 0;
  margin: 0;

  li {
    padding: 12px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    color: rgba(255, 255, 255, 0.8);
    font-size: 14px;
    display: flex;
    align-items: center;
    gap: 10px;

    &:last-child {
      border-bottom: none;
    }

    &:before {
      content: "•";
      color: #D8AB59;
      font-size: 20px;
    }
  }
`;

const MobileModalOverlay = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0, 0, 0, 0.5);
  display: ${props => props.$show ? 'flex' : 'none'};
  justify-content: center;
  align-items: center;
  z-index: 99999;
  padding: 12px;
`;

const MobileModalTitle = styled.h4`
  color: white;
  margin: 0;
  font-size: 18px;
  font-weight: 600;
`;

const MobileModalHeader = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: rgb(30, 35, 40);
  padding: 16px 24px;
  border-bottom: 1px solid #2A2D35;
`;

const MobileCloseButton = styled.button`
  background: none;
  border: none;
  color: #6F767E;
  cursor: pointer;
  padding: 4px;
  display: flex;
  align-items: center;
  justify-content: center;
  &:hover {
    color: white;
  }
`;

const MobileModalBody = styled.div`
  padding: 24px;
  color: white;
  overflow-y: auto;
  flex-grow: 1;
  &::-webkit-scrollbar {
    width: 6px;
  }
  &::-webkit-scrollbar-track {
    background: rgb(18, 20, 24);
    border-radius: 3px;
  }
  &::-webkit-scrollbar-thumb {
    background: #454951;
    border-radius: 3px;
  }
  &::-webkit-scrollbar-thumb:hover {
    background: #555;
  }
  @media (max-width: 768px) {
    padding: 12px 14px;
    height: 100vh;
  }
`;

const MobileModalOverlay1 = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0, 0, 0, 0.5);
  display: ${props => props.$show ? 'flex' : 'none'};
  justify-content: center;
  align-items: center;
  z-index: 1050;
  padding: 20px;
  @media (max-width: 768px) {
    padding: 0px;
  }
`;

const MobileModalContent1 = styled.div`
  background: rgb(18, 20, 24);
  border-radius: 12px;
  width: 100%;
  max-width: 570px;
  position: relative;
  animation: modalFadeIn 0.3s ease-out;
  min-height: 400px;
  max-height: 76vh;
  display: flex;
  flex-direction: column;
  @keyframes modalFadeIn {
    from {
      opacity: 0;
      transform: translateY(-20px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }
  @media (max-width: 768px) {
    height: 100vh;
    max-height: 76vh;
  }
`;

const fillProgress = keyframes`
  from {
    width: 0%;
  }
  to {
    width: ${props => props.progressWidth || 40}%;
  }
`;

// Styled component for the progress bar container
const ProgressBarContainer = styled.div`
  width: 100%;
  height: 8px;
  background-color: #4b5563; /* Gray for unfilled portion */
  border-radius: 4px;
  overflow: hidden;
`;

// Styled component for the yellow progress bar fill
const ProgressBarFill = styled.div`
  height: 100%;
  background-color: #ffc107; /* Yellow for filled portion */
  border-radius: 3px;
  animation: ${fillProgress} 1s ease-in-out forwards;
  width: ${props => props.progressWidth || 40}%; /* Fallback width */
`;

const MobileModalHeader1 = styled.div`
  display: grid;
  grid-template-columns: 24px 1fr 24px;
  align-items: center;
  padding: 16px 24px;
  border-bottom: 1px solid #2A2D35;
  flex-shrink: 0;
  background: rgb(30, 35, 40);
  border-top-left-radius: 12px;
  border-top-right-radius: 12px;
`;

const MobileModalTitle1 = styled.h4`
  color: white;
  margin: 0;
  font-size: 18px;
  font-weight: 600;
  text-align: center;
  grid-column: 2;
`;

const MobileCloseButton1 = styled.button`
  background: none;
  border: none;
  color: #6F767E;
  cursor: pointer;
  padding: 4px;
  display: flex;
  align-items: center;
  justify-content: center;
  grid-column: 3;
  margin-left: auto;
  &:hover {
    color: white;
  }
`;

const MobileModalBody1 = styled.div`
  padding: 24px;
  color: white;
  overflow-y: auto;
  flex-grow: 1;
  &::-webkit-scrollbar {
    width: 6px;
  }
  &::-webkit-scrollbar-track {
    background: #2A2D35;
    border-radius: 3px;
  }
  &::-webkit-scrollbar-thumb {
    background: #454951;
    border-radius: 3px;
  }
  &::-webkit-scrollbar-thumb:hover {
    background: #555;
  }
  @media (max-width: 768px) {
    padding: 12px 14px;
    height: 100vh;
  }
`;

const MobileStyledModal = styled(Modal)`
  .modal-content {
    background: rgb(18, 20, 24);
    color: white;
  }
  .modal-header {
    border-bottom: none;
  }
  .modal-title {
    color: white;
  }
  .modal-body {
    padding: 20px;
    background: rgb(18, 20, 24);
  }
`;

const MobileInputField = styled.input`
  width: 100%;
  padding: 10px;
  border-radius: 8px;
  border: 1px solid #ccc;
  background: rgba(0, 0, 0, 0.2);
  color: white;
  margin-top: 10px;
  &::placeholder {
    color: rgba(255, 255, 255, 0.5);
  }
`;

const MobileInfoIconWrapper = styled.div`
  position: absolute;
  top: 16px;
  right: 16px;
  z-index: 1;
  cursor: pointer;
  transition: transform 0.2s ease;
  &:hover {
    transform: scale(1.1);
  }
`;

const MobileClaimButton = styled.button`
  width: 100%;
  padding: 12px;
  border-radius: 8px;
  background: ${({ $amount }) => ($amount > 0 ? '#f09c06' : 'rgba(255, 255, 255, 0.1)')};
  color: ${({ $amount }) => ($amount > 0 ? 'white' : 'white')};
  border: none;
  cursor: ${({ $amount }) => ($amount > 0 ? 'pointer' : 'not-allowed')};
  margin-top: 25px;

  &:hover {
    background: ${({ $amount }) => ($amount > 0 ? '#f09c06' : 'rgba(255, 255, 255, 0.1)')};
  }
`;

const MobileClaimButton2 = styled.button`
  width: 100%;
  padding: 12px;
  border-radius: 8px;
  background: ${({ $eligible, $claimable }) => {
    if (!$eligible) return 'rgba(255, 255, 255, 0.1)'; // Not eligible
    if ($eligible && !$claimable) return 'rgba(255, 255, 255, 0.1)'; // Eligible but not claimable
    return '#f09c06'; // Eligible and claimable
  }};
  color: white;
  border: none;
  cursor: ${({ $eligible, $claimable }) => ($eligible && $claimable ? 'pointer' : 'not-allowed')};
  margin-top: 25px;

  &:hover {
    background: ${({ $eligible, $claimable }) => {
    if (!$eligible) return 'rgba(255, 255, 255, 0.1)'; // Not eligible
    if ($eligible && !$claimable) return 'rgba(255, 255, 255, 0.1)'; // Eligible but not claimable
    return '#f09c06'; // Eligible and claimable
  }};
  }

  &:disabled {
    opacity: 0.5;
    cursor: not-allowed;
  }
`;

const Bonus = () => {

  const [progress] = useState(25); // Example progress

  const [token] = useState(storage.getKey("token") || null);
  const [logged, setLogged] = useState(false);
  const [amount, setAmount] = useState(0);
  const [selectedInfo, setSelectedInfo] = useState(null);
  const [showRedeemModal, setShowRedeemModal] = useState(false);
  const [walletbonus, setwalletbonus] = useState([
    {
      "bonus_type": "sports",
      "deposit_multiplier": 300,
      "wager_multiplier": 30,
      "min_deposit": 10
    },
    {
      "bonus_type": "casino",
      "deposit_multiplier": 300,
      "wager_multiplier": 30,
      "min_deposit": 10
    }
  ]);
  const [claimLoading, setClaimLoading] = useState({
    daily: false,
    weekly: false,
    monthly: false,
    sports: false,
    casino: false,
  });
  const [openDepositModal, setOpenDepositModal] = useState(false);
  const [activeTab, setActiveTab] = useState('1');
  const tabs = [
    { id: '1', label: 'General bonus' },
    { id: '2', label: 'VIP Bonus' },
  ];
  const [bonusTimers, setBonusTimers] = useState(null);
  // useEffect(() => {
  //   // Scroll to top
  //   document.body.scrollTop = 0;
  //   document.documentElement.scrollTop = 0;

  //   // Check if user is logged in
  //   if (token !== null) {
  //     setLogged(true);
  //   }


  //   // Initialize socket connections
  //   const initializeSocket = async () => {
  //     await wait(200);
  //     socket.emit(C.RAKEBACK_AMOUNT);
  //   };

  //   initializeSocket();

  //   // Socket listeners
  //   const handleRakebackAmount = (data) => {
  //     const decodedData = decode(data);
  //     if (decodedData) {
  //       console.log("rbaack",decodedData);
  //       setAmount(decodedData.amount);
  //     }
  //   };

  //   const handleAddRakeback = async (data) => {
  //     const decodedData = decode(data);
  //     await wait(1000);
  //     socket.emit(C.CREDIT);
  //     let message = decodedData.status.toString();
  //     sendNotfication(message, "info", "top-center");
  //     window.location.reload();
  //   };


  //   socket.on(C.RAKEBACK_AMOUNT, handleRakebackAmount);
  //   socket.on(C.ADD_RAKEBACK, handleAddRakeback);

  //   // Cleanup socket listeners
  //   return () => {
  //     socket.off(C.RAKEBACK_AMOUNT, handleRakebackAmount);
  //     socket.off(C.ADD_RAKEBACK, handleAddRakeback);
  //   };
  // }, [token]);
  // const addReward = () => {
  //   socket.emit(C.ADD_RAKEBACK);
  //   // Play sound when addReward is triggered
  //   const audio = new Audio('/sounds/magic-spell.mp3');
  //   audio.play().catch(error => console.error("Error playing audio:", error));
  // };
  // Define this outside your component/effect as a module-level variable
  let rakebackProcessId = null;

  // Inside your component/effect
  useEffect(() => {

    const componentId = Math.random().toString(36).substring(7); // Generate unique ID for this component instance
    console.log(`[${componentId}] Component mounted/effect running`);
    //   // Scroll to top
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;

    //   // Check if user is logged in
    if (token !== null) {
      setLogged(true);
    }

    // Initialize socket connections
    const initializeSocket = async () => {
      await wait(200);
      socket.emit(C.RAKEBACK_AMOUNT);

      console.log(`[${componentId}] Emitted RAKEBACK_AMOUNT`);
      socket.emit('getBonusTimers');
    };

    initializeSocket();
    // Add bonus timer listeners
    const handleBonusTimerUpdate = (data) => {
      // console.log('Bonus timer update:', data);
      setBonusTimers(data);
    };





    const handleBonusTimerError = (error) => {
      console.error('Bonus timer error:', error);
    };

    // Socket listeners
    const handleRakebackAmount = (data) => {
      console.log(`[${componentId}] Received RAKEBACK_AMOUNT event`);
      const decodedData = decode(data);
      if (decodedData) {
        console.log(`[${componentId}] Rakeback amount:`, decodedData.amount);
        setAmount(decodedData.amount);
      }
    };

    const handleAddRakeback = async (data) => {
      const eventId = Math.random().toString(36).substring(7);
      console.log(`[${componentId}] Received ADD_RAKEBACK event [${eventId}]`);

      // Generate a unique process ID for this rakeback claim
      const newProcessId = Date.now().toString();

      // If there's already a process ID and it's different from this one, another process is handling the claim
      if (rakebackProcessId) {
        console.log(`[${componentId}] Already processing rakeback [${rakebackProcessId}], ignoring event [${eventId}]`);
        return;
      }

      // Set our process ID to claim this rakeback process
      rakebackProcessId = newProcessId;
      console.log(`[${componentId}] Starting to process rakeback [${rakebackProcessId}]`);

      try {
        const decodedData = decode(data);
        console.log(`[${componentId}] Decoded data [${rakebackProcessId}]:`, decodedData);

        await wait(1000);
        console.log(`[${componentId}] Waited 1s, now emitting CREDIT [${rakebackProcessId}]`);
        socket.emit(C.CREDIT);

        let message = decodedData.status.toString();
        console.log(`[${componentId}] Showing notification [${rakebackProcessId}]: ${message}`);
        sendNotfication(message, "info", "top-center");

        // Force a page reload after a short delay
        console.log(`[${componentId}] Will reload page in 1s [${rakebackProcessId}]`);
        setTimeout(() => {
          console.log(`[${componentId}] Reloading page now [${rakebackProcessId}]`);
          window.location.reload();
        }, 1000);
      } catch (err) {
        console.error(`[${componentId}] Error processing rakeback [${rakebackProcessId}]:`, err);
      }
    };

    // IMPORTANT: Remove any existing listeners globally
    console.log(`[${componentId}] Removing any existing listeners`);
    socket.removeAllListeners(C.RAKEBACK_AMOUNT);
    socket.removeAllListeners(C.ADD_RAKEBACK);

    // Now add our listeners
    console.log(`[${componentId}] Adding new listeners`);
    socket.on(C.RAKEBACK_AMOUNT, handleRakebackAmount);
    socket.on(C.ADD_RAKEBACK, handleAddRakeback);
    socket.on('bonusTimerUpdate', handleBonusTimerUpdate);
    socket.on('bonusTimerError', handleBonusTimerError);
    // Cleanup socket listeners
    return () => {
      console.log(`[${componentId}] Component unmounting/effect cleaning up`);
      socket.off(C.RAKEBACK_AMOUNT, handleRakebackAmount);
      socket.off(C.ADD_RAKEBACK, handleAddRakeback);
      socket.off('bonusTimerUpdate', handleBonusTimerUpdate);
      socket.off('bonusTimerError', handleBonusTimerError);
    };
  }, [token]);
  const formatTimeRemaining = (timeObj) => {
    if (!timeObj || timeObj.expired) return 'Expired';
    const { hours, minutes, seconds } = timeObj;
    return `${hours}h ${minutes}m ${seconds}s`;
  };
  const addReward = () => {
    console.log("addReward function called, emitting ADD_RAKEBACK");
    socket.emit(C.ADD_RAKEBACK);

    // Play sound when addReward is triggered
    const audio = new Audio('/sounds/magic-spell.mp3');
    audio.play().catch(error => console.error("Error playing audio:", error));
  };

  const [openModal, setOpneModal] = useState(false);

  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);
  const [success, setSuccess] = useState(false);
  const [bonus, setBonus] = useState(null);

  const [bonususer, setBonususer] = useState(null);
  const [bonusredeemuser, setBonusredeemuser] = useState(null)
  const [progressbonus, setprogressbonus] = useState();

  const handleBonusRequest = async () => {
    setLoading(true);
    setError(null);
    setSuccess(false);

    try {
      const userId = getUID();
      const token = localStorage.getItem('token');
      const response = await fetch('https://api.boss707.com/bonus/userbonus', {
        method: 'POST',
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'application/json',
          'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        },
        body: JSON.stringify({
          userid: userId,
          role: 'user'
        })
      });

      if (!response.ok) {
        throw new Error('Request failed');
      }

      const data = await response.json();
      setSuccess(true);
      if (Array.isArray(data) && data.length > 0) {
        setBonususer(data[0]); // Extract the first object from the array
        setSuccess(true);
        console.log('User Bonus Success:', data[0]);
      } else {
        throw new Error('No data found');
      }
    } catch (err) {
      setError(err.message);
      console.error('Error:', err);
    } finally {
      setLoading(false);
    }
  };



  const handleBonusRedeemRequest = async () => {
    setLoading(true);
    setError(null);
    setSuccess(false);

    try {
      const userId = getUID();
      const token = localStorage.getItem('token');
      const response = await fetch('https://api.boss707.com/bonus/user', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'Authorization': `Bearer ${token}`,
          'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        },
        body: JSON.stringify({
          userid: userId
        })
      });

      if (!response.ok) {
        throw new Error('Request failed');
      }

      const data = await response.json();
      setSuccess(true);
      setBonusredeemuser(data);
      console.log('User Bonus Redeem:', data);
    } catch (err) {
      setError(err.message);
      console.error('Error:', err);
    } finally {
      setLoading(false);
    }
  };
  // Add this function to fetch bonus history
  const fetchBonusHistory = async () => {
    setLoading(true);
    setError(null);

    try {
      const response = await fetch(`https://api.boss707.com/Userbonus/api/bonus-history?userid=${getUID()}`, {
        method: 'GET',
        headers: {
          'Content-Type': 'application/json',
          'Authorization': `Bearer ${token}`,
          'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        }
      });

      if (!response.ok) {
        throw new Error('Failed to fetch bonus history');
      }

      const data = await response.json();
      const claimedBonuses = data.history.filter(item => item.is_claimed === true);
      setBonusHistory(claimedBonuses);
      console.log('Claimed Bonus History:', claimedBonuses);
      return claimedBonuses;
    } catch (err) {
      setError(err.message);
      console.error('Error fetching bonus history:', err);
      return [];
    } finally {
      setLoading(false);
    }
  };

  // Add state for bonus history
  const [bonusHistory, setBonusHistory] = useState([]);
  // const fetchGameDeatils = async () => {
  //   setLoading(true);
  //   setError(null);
  //   setSuccess(false);

  //   try {
  //     const userId = getUID();
  //     const response = await fetch('https://api.boss707.com/bonus/bonusgame', {
  //       method: 'POST',
  //       headers: {
  //         'Content-Type': 'application/json',
  //         'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
  //       },
  //       body: JSON.stringify({
  //         userid: userId,
  //         role: 'user'
  //       })
  //     });

  //     if (!response.ok) {
  //       throw new Error('Request failed');
  //     }

  //     const data = await response.json();
  //     setSuccess(true);
  //     if (Array.isArray(data) && data.length > 0) {
  //       setBonus(data[0]); // Extract the first object from the array
  //       setSuccess(true);
  //       console.log('Game Bonus Success:', data[0]);
  //     } else {
  //       throw new Error('No data found');
  //     }
  //   } catch (err) {
  //     setError(err.message);
  //     console.error('Error:', err);
  //   } finally {
  //     setLoading(false);
  //   }
  // };
  const fetchBonuses = async () => {
    setLoading(true);
    setError(null);
    setSuccess(false);

    try {
      const token = localStorage.getItem('token');
      const response = await fetch(`https://api.boss707.com/Userbonus/api/bonuses?userid=${getUID()}`, {
        method: 'GET',
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'application/json',
          'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        }
      });

      if (!response.ok) {
        throw new Error('Failed to fetch bonuses');
      }

      const data = await response.json();
      setBonus(data); // Store the entire bonus response
      setSuccess(true);
      console.log('Bonuses:', data);
    } catch (err) {
      setError(err.message);
      console.error('Error fetching bonuses:', err);
    } finally {
      setLoading(false);
    }
  };


  const handleClaimBonus = async (bonusType) => {
    setClaimLoading(prev => ({ ...prev, [bonusType]: true }));
    setError(null);

    try {
      const token = localStorage.getItem('token');

      const response = await fetch(`https://api.boss707.com/Userbonus/api/bonuses/claim/${bonusType}?userid=${getUID()}`, {
        method: 'POST',
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'application/json',
          'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        }
      });

      const data = await response.json();

      if (!response.ok) {
        throw new Error(data.error || 'Failed to claim bonus');
      }
      // Play sound when addReward is triggered
      const audio = new Audio('/sounds/magic-spell.mp3');
      audio.play().catch(error => console.error("Error playing audio:", error));
      sendNotfication('Bonus claimed successfully', 'success', 'top-center');
      window.location.reload(); // Refresh the page
    } catch (err) {
      setError(err.message);
      sendNotfication(err.message, 'error', 'top-center');
    } finally {
      setClaimLoading(prev => ({ ...prev, [bonusType]: false }));
    }
  };
  useEffect(() => {
    const fetchData = async () => {
      try {
        // Run all async functions concurrently using Promise.all
        const [bonusRequestResult, bonusesResult, redeemRequestResult, historyResult] = await Promise.all([
          handleBonusRequest(),
          fetchBonuses(),
          handleBonusRedeemRequest(),
          fetchBonusHistory(),
        ]);

        // Handle the results as needed
        console.log('Bonus Request:', bonusRequestResult);
        console.log('Bonuses:', bonusesResult);
        console.log('Redeem Request:', redeemRequestResult);
        console.log('Bonus History:', historyResult);
      } catch (error) {
        // Handle errors from any of the Promises
        console.error('Error fetching data:', error);
        // Optionally update state to show error to the user
      }
    };

    fetchData();
    getPublicBonusdata();
    CurrentBonuswallet();
    ProgressBonuswallet();
  }, []);
  const getAuthToken = () => {
    return localStorage.getItem('token');
  };

  const getPublicBonusdata = async () => {
    try {
      const token = getAuthToken();
      const response = await fetch('https://api.boss707.com/api/bonus/config-public', {
        method: 'GET',
        headers: {
          Authorization: `Bearer ${token}`,
          'Content-Type': 'application/json',
        },

      });
      if (!response.ok) {
        throw new Error('Request failed');
      }
      const data = await response.json();
      console.log("data1234", data);
      setwalletbonus(data);

    } catch (err) {
      setError(err.message);
      console.error('Error:', err);
    } finally {

    }
  }
  const CurrentBonuswallet = async () => {

    try {
      const userId = getUID();
      const token = localStorage.getItem('token');
      const response = await fetch(`https://api.boss707.com/api/bonus/flag/${userId}`, {
        method: 'GET',
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'application/json',
          // 'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        },


      });
      if (!response.ok) {
        throw new Error('Request failed');
      }
      const data = await response.json();
      console.log("test222", data);

      if (data.selected) {
        const val = data.bonus_type;

        setwalletbonus(prev =>
          prev.filter(item => item.bonus_type === val)
        );
      }
    } catch (err) {
      setError(err.message);
      console.error('Error:', err);
    } finally {

    }
  }
  const ProgressBonuswallet = async () => {

    try {
      const userId = getUID();
      const token = localStorage.getItem('token');
      const response = await fetch(`https://api.boss707.com/api/bonus/progress/${userId}`, {
        method: 'GET',
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'application/json',
          // 'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        },


      });
      if (!response.ok) {
        throw new Error('Request failed');
      }
      const data = await response.json();
      console.log("test222", data);
      setprogressbonus(data);

    } catch (err) {
      setError(err.message);
      console.error('Error:', err);
    } finally {

    }
  }
  const handleClaimWalletBonus = async (bonus) => {
    console.log("testing", bonus);
    setClaimLoading(prev => ({ ...prev, [bonus]: true }));
    try {
      const userId = getUID();
      const response = await fetch('https://api.boss707.com/api/bonus/claim', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          // 'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        },
        body: JSON.stringify({
          uid: userId,

        })

      });
      if (!response.ok) {
        throw new Error('Request failed');
      }
      const data = await response.json();
      console.log("test1234", data);
      setwalletbonus(data);


    } catch (err) {
      setError(err.message);
      console.error('Error:', err);
    } finally {
      setClaimLoading(prev => ({ ...prev, [bonus]: false }));
    }
  }


  const formatAmount = (amount) => `$${amount.toFixed(2)}`;
  const history = useHistory();

  const [reedemcode, setReedemCode] = useState(null)

  const handleRedeemCode = async () => {

    if (!reedemcode) return sendNotfication('Please Enter Reedeam Code !')

    const url = 'https://api.boss707.com/bonus/redeem-bonus/redeem';
    const headers = {
      'Content-Type': 'application/json',
      'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053',
    };
    const payload = {
      userid: getUID(),
      code: reedemcode, // Assuming you have a code to redeem
    };

    try {
      const token = localStorage.getItem('token');
      const response = await fetch(url, {
        method: 'POST',
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'application/json',
          'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053',
        },
        body: JSON.stringify(payload),
      });

      const data = await response.json();

      if (response.status === 200) {
        sendNotfication(data.message); // Show success notification
        // setAmount(data.amount); // Update amount if needed
        window.location.reload();
      } else if (response.status === 400) {
        sendNotfication(data.error); // Show error notification for bad request
      } else if (response.status === 404) {
        sendNotfication(data.error); // Show error notification for not found
      } else if (response.status === 500) {
        sendNotfication(data.error); // Show error notification for server error
      }
    } catch (error) {
      sendNotfication('Failed to redeem bonus'); // Handle network errors
    }
    finally {
      setReedemCode("");
    }
  };
  // Update the calculateTotalBonus function to include claimed bonus amounts
  const calculateTotalBonus = (user, bonus, bonusredeemuser, bonusHistory) => {
    if (!user && !bonus && !bonusredeemuser && !bonusHistory) return 0;

    const userBonuses =
      (user?.vipbonus || 0) +
      (user?.specialbonus || 0) +
      (user?.generalbonus || 0) +
      (user?.joiningbonus || 0);

    const additionalBonuses =
      (bonus?.bonuses?.daily?.amount || 0) +
      (bonus?.bonuses?.weekly?.amount || 0) +
      (bonus?.bonuses?.monthly?.amount || 0);

    // Add null check for bonusredeemuser
    const redeemBonusTotal = bonusredeemuser?.reduce((sum, item) => sum + (item.amount || 0), 0) || 0;

    // Calculate total from claimed bonus history
    const claimedBonusTotal = bonusHistory?.reduce((sum, item) => sum + (parseFloat(item.bonus_amount) || 0), 0) || 0;

    return userBonuses + additionalBonuses + redeemBonusTotal + claimedBonusTotal;
  };

  // Example of how to use the updated function
  const totalBonus = calculateTotalBonus(bonususer, bonus, bonusredeemuser, bonusHistory);
  useEffect(() => {
    let interval;

    if (bonusTimers && Object.keys(bonusTimers.timeUntilNextBonus || {}).length > 0) {
      interval = setInterval(() => {
        setBonusTimers(prevTimers => {
          if (!prevTimers) return prevTimers;

          const updatedTimers = { ...prevTimers };

          ['weekly', 'monthly'].forEach(type => {
            if (updatedTimers.timeUntilNextBonus[type] && !updatedTimers.timeUntilNextBonus[type].expired) {
              const currentTimer = updatedTimers.timeUntilNextBonus[type];
              let totalSeconds = currentTimer.totalSeconds - 1;

              if (totalSeconds <= 0) {
                updatedTimers.timeUntilNextBonus[type].expired = true;
                totalSeconds = 0;
              }

              const hours = Math.floor(totalSeconds / 3600);
              const minutes = Math.floor((totalSeconds % 3600) / 60);
              const seconds = totalSeconds % 60;

              updatedTimers.timeUntilNextBonus[type] = {
                ...currentTimer,
                hours,
                minutes,
                seconds,
                totalSeconds
              };
            }
          });

          return updatedTimers;
        });
      }, 1000);
    }

    return () => {
      if (interval) clearInterval(interval);
    };
  }, [bonusTimers]);
  const formatTimerDisplay = (timerData) => {
    if (!timerData || timerData.expired) return null;

    const { hours, minutes, seconds } = timerData;

    // If more than 24 hours, show days
    if (hours >= 24) {
      const days = Math.floor(hours / 24);
      const remainingHours = hours % 24;
      return `${days}d ${remainingHours}h ${minutes}m`;
    }

    // If less than 24 hours, show hours:minutes:seconds
    return `${hours}h ${minutes}m ${seconds}s`;
  };

  return (
    <>
      <ModalOverlay $show={selectedInfo !== null}>
        <InfoModalContent>
          <ModalHeader>
            <ModalTitle>{selectedInfo?.title}</ModalTitle>
            <CloseButton onClick={() => setSelectedInfo(null)}>
              <X size={20} />
            </CloseButton>
          </ModalHeader>
          <ModalBody>
            <InfoList>
              {selectedInfo?.points.map((point, index) => (
                <li key={index}>{point}</li>
              ))}
            </InfoList>
          </ModalBody>
        </InfoModalContent>
      </ModalOverlay>
      {
        isMobile() ? (

          <>
            <MobileModalOverlay $show={selectedInfo !== null}>
              <MobileInfoModalContent>
                <MobileModalHeader>
                  <MobileModalTitle>{selectedInfo?.title}</MobileModalTitle>
                  <MobileCloseButton onClick={() => setSelectedInfo(null)}>
                    <X size={20} />
                  </MobileCloseButton>
                </MobileModalHeader>
                <MobileModalBody>
                  <MobileInfoList>
                    {selectedInfo?.points.map((point, index) => (
                      <li key={index}>{point}</li>
                    ))}
                  </MobileInfoList>
                </MobileModalBody>
              </MobileInfoModalContent>
            </MobileModalOverlay>
            <MobileContainer>
              <MobileBackButton onClick={() => history.goBack()}>
                <X size={24} color="white" />
              </MobileBackButton>

              <MobileInnerContainer>
                <MobileBonusCard>
                  <MobileBonusContent>
                    <div style={{ marginTop: "24px", width: "100%", display: "flex", justifyContent: 'space-between', alignItems: 'center' }}>
                      <MobileBonusType1>
                        <div style={{ marginTop: '-26px' }} className="label">Total Bonus Claimed(USD)</div>
                      </MobileBonusType1>
                    </div>
                    <MobileTotalAmount>
                      ${(bonususer?.specialbonus + bonususer?.joiningbonus + bonususer?.actualdailybonus + bonususer?.actualweeklybonus + bonususer?.actualmonthlybonus + bonususer?.rakebonus || 0).toFixed(2)}
                    </MobileTotalAmount>
                    <MobileReedeemButton onClick={() => setShowRedeemModal(true)}>Redeem Code</MobileReedeemButton>
                  </MobileBonusContent>
                  <MobileBonusCardImage src="/assets/images/bcgames/bonus/mb1.png" alt="Banner" />
                </MobileBonusCard>
              </MobileInnerContainer>

              <MobileScrollableContent>
                <MobileTabContainer>
                  {tabs.map(tab => (
                    <MobileTabButton
                      key={tab.id}
                      $active={activeTab === tab.id}
                      onClick={() => setActiveTab(tab.id)}
                    >
                      {tab.label}
                    </MobileTabButton>
                  ))}
                </MobileTabContainer>

                <div style={{ paddingBottom: "50px" }}>
                  {activeTab === "1" && (
                    <MobileGridContainer1>
                      <MobileCardBG>
                        <MobileInfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.dailyBonus)}>
                          <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                        </MobileInfoIconWrapper>
                        <MobileCard $background="linear-gradient(to right, rgba(103, 55, 255, .6) 0%, rgba(103, 55, 255, 0) 40%)">
                          <MobileImagePlaceholder src="/assets/images/bonus/daily.png" alt="Daily Bonus" />
                          <MobileContentWrapper>
                            <MobileCardTitle>Daily Bonus</MobileCardTitle>
                            <MobileStatRow>
                              <span>{bonus?.bonuses.daily.eligible ? 'Bonus Unlocked' : 'Available at VIP 20'}</span>
                              {bonus?.bonuses.daily.eligible && bonus?.bonuses.daily.claimable && (
                                <span style={{ marginLeft: '4px' }}>${bonus.bonuses.daily.amount.toFixed(2)}</span>
                              )}
                            </MobileStatRow>
                            <MobileButtonWrapper>
                              <MobileClaimButton2
                                disabled={
                                  !bonus?.bonuses.daily.eligible ||
                                  !bonus?.bonuses.daily.claimable ||
                                  claimLoading.daily
                                }
                                $eligible={bonus?.bonuses.daily.eligible}
                                $claimable={bonus?.bonuses.daily.claimable}
                                onClick={() => handleClaimBonus('daily')}
                              >
                                {claimLoading.daily ? 'Loading...' :
                                  !bonus?.bonuses.daily.eligible ? 'Not Eligible' :
                                    bonus?.bonuses.daily.claimable ? 'Claim' : 'Not Available'}
                              </MobileClaimButton2>
                            </MobileButtonWrapper>
                          </MobileContentWrapper>
                        </MobileCard>
                      </MobileCardBG>
                      <MobileCardBG>
                        <MobileInfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.rakeback)}>
                          <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                        </MobileInfoIconWrapper>
                        <MobileCard $background="linear-gradient(to right, rgba(214, 129, 0, .6) 0%, rgba(214, 129, 0, 0) 40%)">
                          <MobileImagePlaceholder src="/assets/images/bonus/rakeback.png" alt="Rakeback" />
                          <MobileContentWrapper>
                            <MobileCardTitle>Rakeback</MobileCardTitle>
                            <MobileStatRow>
                              <div>Ready to claim:</div>
                              <span>{amount}</span>
                            </MobileStatRow>
                            <MobileButtonWrapper>
                              <MobileClaimButton disabled={amount <= 0} $amount={amount} onClick={addReward}>Claim</MobileClaimButton>
                            </MobileButtonWrapper>
                          </MobileContentWrapper>
                        </MobileCard>
                      </MobileCardBG>
                    </MobileGridContainer1>
                  )}
                  {activeTab === "2" && (
                    <MobileGridContainer1>
                      <MobileCardBG>
                        <MobileInfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.weeklyCashback)}>
                          <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                        </MobileInfoIconWrapper>
                        <MobileCard $background="linear-gradient(to right, rgba(6, 115, 217, .6) 0%, rgba(6, 115, 217, 0) 40%)">
                          <MobileImagePlaceholder src="/assets/images/bonus/weekly.png" alt="Weekly Cashback" />
                          <MobileContentWrapper>
                            <MobileCardTitle>Weekly Cashback</MobileCardTitle>
                            <MobileStatRow>
                              <span>{bonus?.bonuses.weekly.eligible ? 'Bonus Unlocked' : 'Available at VIP 25'}</span>
                              {bonus?.bonuses.weekly.eligible && bonus?.bonuses.weekly.claimable && (
                                <span style={{ marginLeft: '4px' }}>${bonus.bonuses.weekly.amount.toFixed(2)}</span>
                              )}
                            </MobileStatRow>
                            <MobileButtonWrapper>
                              <MobileClaimButton2
                                disabled={
                                  !bonus?.bonuses.weekly.eligible ||
                                  !bonus?.bonuses.weekly.claimable ||
                                  claimLoading.weekly
                                }
                                $eligible={bonus?.bonuses.weekly.eligible}
                                $claimable={bonus?.bonuses.weekly.claimable}
                                onClick={() => handleClaimBonus('weekly')}
                              >
                                {claimLoading.weekly ? 'Loading...' :
                                  !bonus?.bonuses.weekly.eligible ? 'Not Eligible' :
                                  bonus?.bonuses.weekly.claimable ? 'Claim' : 'Not Available'}
                              </MobileClaimButton2>
                            </MobileButtonWrapper>
                          </MobileContentWrapper>
                        </MobileCard>
                      </MobileCardBG>
                      <MobileCardBG>
                        <MobileInfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.monthlyCashback)}>
                          <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                        </MobileInfoIconWrapper>
                        <MobileCard $background="linear-gradient(to right, rgba(179, 9, 61, .6) 0%, rgba(179, 9, 61, 0) 40%)">
                          <MobileImagePlaceholder src="/assets/images/bonus/monthly.png" alt="Monthly Cashback" />
                          <MobileContentWrapper>
                            <MobileCardTitle>Monthly Cashback</MobileCardTitle>
                            <MobileStatRow>
                              <span>{bonus?.bonuses.monthly.eligible ? 'Bonus Unlocked' : 'Available at VIP 30'}</span>
                              {bonus?.bonuses.monthly.eligible && bonus?.bonuses.monthly.claimable && (
                                <span style={{ marginLeft: '4px' }}>${bonus.bonuses.monthly.amount.toFixed(2)}</span>
                              )}
                            </MobileStatRow>
                            <MobileButtonWrapper>
                              <MobileClaimButton2
                                disabled={!bonus?.bonuses.monthly.eligible || !bonus?.bonuses.monthly.claimable || claimLoading.monthly}
                                $eligible={bonus?.bonuses.monthly.eligible}
                                $claimable={bonus?.bonuses.monthly.claimable}
                                onClick={() => handleClaimBonus('monthly')}
                              >
                                {claimLoading.monthly ? 'Loading...' :
                                  !bonus?.bonuses.monthly.eligible ? 'Not Eligible' :
                                    bonus?.bonuses.monthly.claimable ? 'Claim' : 'Not Available'}
                              </MobileClaimButton2>
                            </MobileButtonWrapper>
                          </MobileContentWrapper>
                        </MobileCard>
                      </MobileCardBG>
                      <MobileCardBG>
                        {/* Commented out Sports Weekly Bonus section */}
                      </MobileCardBG>
                    </MobileGridContainer1>
                  )}
                </div>
              </MobileScrollableContent>

              <MobileModalOverlay $show={openModal}>
                <MobileModalContent>
                  <MobileModalHeader>
                    <div style={{ textAlign: "center", fontSize: "18px" }}>Bonus Details</div>
                    <MobileCloseButton onClick={() => setOpneModal(!openModal)}>
                      <X size={24} />
                    </MobileCloseButton>
                  </MobileModalHeader>
                  <MobileModalBody>
                    <BonusDetails data={bonus} />
                  </MobileModalBody>
                </MobileModalContent>
              </MobileModalOverlay>

              <MobileModalOverlay1 $show={openDepositModal}>
                <MobileModalContent1>
                  <MobileModalHeader1>
                    <MobileModalTitle1>Deposit</MobileModalTitle1>
                    <MobileCloseButton1 onClick={() => setOpenDepositModal(!openDepositModal)}>
                      <X size={24} />
                    </MobileCloseButton1>
                  </MobileModalHeader1>
                  <MobileModalBody1>
                    <SkylaDepositModal />
                  </MobileModalBody1>
                </MobileModalContent1>
              </MobileModalOverlay1>

              <MobileStyledModal show={showRedeemModal}>
                <MobileModalHeader1>
                  <MobileModalTitle1 style={{ color: "white", marginTop: "50px" }}>Redeem Code</MobileModalTitle1>
                  <MobileCloseButton1 onClick={() => setShowRedeemModal(false)}>
                    <X size={24} style={{ color: "white", marginTop: "50px" }} />
                  </MobileCloseButton1>
                </MobileModalHeader1>
                <MobileModalBody>
                  <label htmlFor="redeemCode">Enter your code</label>
                  <MobileInputField
                    type="text"
                    id="redeemCode"
                    placeholder="Enter code"
                    value={reedemcode}
                    onChange={(e) => setReedemCode(e.target.value)}
                  />
                  <div style={{ width: '100%', display: 'flex', justifyContent: 'center' }}>
                    <MobileReedeemButton onClick={handleRedeemCode}>Redeem</MobileReedeemButton>
                  </div>
                </MobileModalBody>
              </MobileStyledModal>
            </MobileContainer>
          </>
        ) : (
          <>
            <Container>
              <Header>
                <Title>Bonus</Title>
                <RedeemWrapper>
                  <RedeemInput onChange={(e) => setReedemCode(e.target.value)} value={reedemcode} placeholder="Redeem your bonus here." />
                  <RedeemButton onClick={handleRedeemCode}>Redeem Code</RedeemButton>
                </RedeemWrapper>
              </Header>

              <BonusCard>
                <BonusContent>
                  <BonusType1>
                    <div className="label">Total Bonus Claimed(USD)</div>
                  </BonusType1>
                  <TotalAmount>
                    ${(bonususer?.specialbonus + bonususer?.joiningbonus + bonususer?.actualdailybonus + bonususer?.actualweeklybonus + bonususer?.actualmonthlybonus + bonususer?.rakebonus || 0).toFixed(2)}
                  </TotalAmount>
                  <BonusTypes>
                    <BonusType>
                      {/* <div className="label">Total VIP Bonus</div>
  <div className="amount">
    ${(bonususer?.actualweeklybonus + bonususer?.actualmonthlybonus || 0)}
  </div> */}
                    </BonusType>
                    <BonusType>
                      {/* <div className="label">Total Special Bonus</div>
                      <div className="amount">${bonususer?.specialbonus || "0.00"}</div> */}
                    </BonusType>
                    <BonusType>
                      {/* <div className="label">Total General Bonus</div>
  <div className="amount">
    ${(bonususer?.actualdailybonus + bonususer?.rakebonus || 0)}
  </div> */}
                    </BonusType>
                  </BonusTypes>
                  {/* <DetailsButton onClick={() => setOpneModal(true)}>
                    Details →
                  </DetailsButton> */}
                </BonusContent>
                <BonusCardImage
                  src="/assets/images/bcgames/bonus/bn1.webp"
                  alt="Banner"
                />
              </BonusCard>



            </Container>
            <div style={{ padding: "10px" }}>
              <Title1>Wallet Bonus</Title1>
              <GridContainer>
                {walletbonus?.map((bonus, index) => (
                  <CardBG key={index}>
                    <InfoIconWrapper
                      onClick={() => setSelectedInfo(BONUS_INFO[`${bonus.bonus_type}`])}
                    >
                      <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                    </InfoIconWrapper>
                    <Card
                      background={`radial-gradient(71.39% 51.03% at 46.49% 7.5%, rgba(${bonus.bonus_type === 'casino' ? '111, 60, 255' : '214, 129, 0'
                        }, .6) 0%, rgba(${bonus.bonus_type === 'casino' ? '111, 60, 255' : '214, 129, 0'
                        }, 0) 98%)`}
                    >
                      <ImagePlaceholder
                        src={`/assets/images/bonus/${bonus.bonus_type}.png`}
                        alt={`${bonus.bonus_type} Bonus`}
                      />
                      <CardTitle>
                        {bonus.bonus_type.charAt(0).toUpperCase() + bonus.bonus_type.slice(1)} Bonus
                      </CardTitle>
                      <ContainerBottom>
                        <StatsContainer>
                          <span>Wagier need to claim:{progressbonus?.wager_required ?? 18}</span>
                          {progressbonus?.status === 'pending' && (
                            <StatRow>
                              <ProgressBarContainer>
                                <ProgressBarFill progressWidth={progressbonus?.progress_pct ?? 40} />
                              </ProgressBarContainer>
                              <div style={{ marginLeft: '5px' }}>
                                <Info
                                  size={14}
                                  color="rgba(255, 255, 255, 0.7)"
                                  onClick={() =>
                                    setSelectedInfo(BONUS_INFO[`${bonus.bonus_type}claim`])
                                  }
                                />
                              </div>
                            </StatRow>
                          )}
                          <span>Current Wagier :{progressbonus?.progress_pct ?? 5}</span>
                          {/* need to change with wagerprogresscjb */}
                        </StatsContainer>
                        <ClaimButton2
                          disabled={progressbonus?.status === 'pending'}
                          $eligible={bonus?.bonuses?.daily?.eligible}
                          $claimable={bonus?.bonuses?.daily?.claimable}
                          onClick={() => handleClaimWalletBonus(bonus?.bonus_type)}
                        >
                          {claimLoading[bonus?.bonus_type] ? 'Loading...' : 'Select'}
                        </ClaimButton2>
                      </ContainerBottom>
                    </Card>
                  </CardBG>
                ))}
              </GridContainer>
            </div>
            <div style={{ padding: "10px" }}>
              <Title1>General Bonus</Title1>
              <GridContainer>
                {/* Quests Card */}
                <CardBG>
                  <InfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO?.dailyBonus)}>
                    <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                  </InfoIconWrapper>
                  <Card $background="radial-gradient(71.39% 51.03% at 46.49% 7.5%, rgba(111, 60, 255, .6) 0%, rgba(111, 60, 255, 0) 98%)">
                    <ImagePlaceholder src="/assets/images/bonus/daily.png" />
                    <CardTitle>Daily Bonus</CardTitle>
                    <ContainerBottom>
                      <StatsContainer>
                        <StatRow>
                          <span>{bonus?.bonuses.daily.eligible ? 'Bonus Unlocked' : 'Available at VIP 20'}</span>
                          {bonus?.bonuses.daily.eligible && bonus?.bonuses.daily.claimable && (
                            <span style={{ marginLeft: '4px' }}>${bonus.bonuses.daily.amount.toFixed(2)}</span>
                          )}
                        </StatRow>
                      </StatsContainer>
                      <ClaimButton2
                        disabled={
                          !bonus?.bonuses.daily.eligible ||
                          !bonus?.bonuses.daily.claimable ||
                          claimLoading.daily
                        }
                        $eligible={bonus?.bonuses.daily.eligible}
                        $claimable={bonus?.bonuses.daily.claimable}
                        onClick={() => handleClaimBonus('daily')}
                      >
                        {claimLoading.daily ? 'Loading...' :
                          !bonus?.bonuses.daily.eligible ? 'Not Eligible' :
                            bonus?.bonuses.daily.claimable ? 'Claim' : 'Not Available'}
                      </ClaimButton2>
                    </ContainerBottom>
                  </Card>
                </CardBG>

                {/* Lucky Spin Card */}
                {/* <CardBG>
               <Card $background="radial-gradient(116.81% 83.5% at 46.23% 9.2%, rgba(206, 124, 0, .6) 0%, rgba(206, 124, 0, 0) 60%)">
                 <ImagePlaceholder  src="/assets/images/bcgames/bonus/bcc2.webp"  />
                 <CardTitle>Lucky Spin</CardTitle>
                <ContainerBottom>
                <StatsContainer>
                   <StatRow>
                     <span>VIP Spin:</span>
                     <span>Reach VIP 1</span>
                   </StatRow>
                   <StatRow>
                     <span>Daily Spin:</span>
                     <span>$0.00/$200.00</span>
                   </StatRow>
                 </StatsContainer>
                 <ClaimButton>Claim</ClaimButton>
                </ContainerBottom>
               </Card>
   
             </CardBG> */}
                {/* Roll Competition Card */}
                {/* <CardBG>
               <Card $background="radial-gradient(116.81% 83.5% at 46.23% 9.2%, rgba(165, 207, 0, .6) 0%, rgba(165, 207, 0, 0) 60%)">
                 <ImagePlaceholder src="/assets/images/bcgames/bonus/bcc3.webp" />
                 <CardTitle>Roll Competition</CardTitle>
                 <ContainerBottom>
                 <StatsContainer>
                   <StatRow>
                     <span>Total claimed:</span>
                     <span>$0.00</span>
                   </StatRow>
                   <Timer>Ready in 15h 21m 28s</Timer>
                 </StatsContainer>
                 <ClaimButton>Claim</ClaimButton>
                 </ContainerBottom>
               </Card>
             </CardBG> */}

                {/* Rakeback Card */}
                <CardBG>
                  <InfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.rakeback)}>
                    <Info size={20} color="rgba(255, 255, 255, 0.7)" />

                  </InfoIconWrapper>
                  <Card $background="radial-gradient(116.81% 83.5% at 46.23% 9.2%, rgba(214, 129, 0, .6) 0%, rgba(214, 129, 0, 0) 60%)">
                    <ImagePlaceholder src="/assets/images/bonus/rakeback.png" />

                    <CardTitle>Rakeback</CardTitle>

                    <ContainerBottom>
                      <StatsContainer>
                        <StatRow>
                          <span>Ready to claim:</span>
                          <span>{amount}</span>
                        </StatRow>
                      </StatsContainer>
                      <ClaimButton
                        disabled={amount <= 0}
                        amount={amount}
                        onClick={addReward}
                      >
                        Claim
                      </ClaimButton>
                    </ContainerBottom>


                  </Card>
                </CardBG>

                {/* <CardBG>
                <InfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.vaultPro)}>
                    <Info size={20} color="rgba(255, 255, 255, 0.7)" />

                  </InfoIconWrapper>
                  <Card $background="radial-gradient(116.81% 83.5% at 46.23% 9.2%, rgba(196, 44, 44, 0.45), transparent 60%)">
                    <ImagePlaceholder src="/assets/images/bcgames/bonus/bcc10.webp" />
                    <CardTitle>Vault Pro</CardTitle>
                    <ContainerBottom >
                      <StatsContainer>
                        <StatRow>
                          <span> My Holdings:</span>
                          <span>₹0.00</span>





                        </StatRow>
                      </StatsContainer>
                      <StatsContainer>
                        <StatRow>
                          <span>Total Return:</span>
                          <span>₹0.00</span>

                        </StatRow>
                      </StatsContainer>
                      <ClaimButton style={{ marginTop: '60px' }} onClick={() => history.push("/vault-pro")}>Transfer</ClaimButton>
                    </ContainerBottom>
                  </Card>
                </CardBG> */}
              </GridContainer>
            </div>
            <div style={{ padding: "10px" }}>
              <Title1>VIP Bonus</Title1>
              <GridContainer>
                {/* Quests Card */}
                {/* <CardBG>
                <InfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.welcomeBonus)}>
                    <Info size={20} color="rgba(255, 255, 255, 0.7)" />

                  </InfoIconWrapper>
                  <Card $background="radial-gradient(116.81% 83.5% at 46.23% 9.2%, rgba(188, 1, 191, .6) 0%, rgba(188, 1, 191, 0) 60%)">
                    <ImagePlaceholder src="/assets/images/bcgames/bonus/bcc5.webp" />
                    <CardTitle>Welcome Bonus</CardTitle>
                    <ContainerBottom>
                      {/* <StatsContainer> */}
                {/* <StatRow>
                        <span><LockIcon /></span>
                        <span style={{ marginLeft: "4px", marginTop: "2px" }}>Available at VIP 11</span>
                      </StatRow> */}
                {/* <StatRow>
                     <span>Weekly Quests:</span>
                     <span>0/1</span>
                   </StatRow> */}
                {/* </StatsContainer> */}
                {/* <ClaimButton >Claim</ClaimButton> */}
                {/* </ContainerBottom>
                  </Card>
                </CardBG>  */}

                {/* Lucky Spin Card */}
                {/* <CardBG>
                  <Card $background="radial-gradient(116.81% 83.5% at 46.23% 9.2%, rgba(13, 148, 111, .6) 0%, rgba(13, 148, 111, 0) 60%)">
                    <ImagePlaceholder src="/assets/images/bcgames/bonus/bcc6.webp" />
                    <CardTitle>Special Bonus</CardTitle>
                    <ContainerBottom>
                      <StatsContainer>
                       
                   <StatRow>
                     <span>contact your service provider to Claim it before</span>
                  
                   </StatRow>


                        <StatRow>
                         
                         Special Bonus Available at VIP 15
                        </StatRow>
                      </StatsContainer>
                     
                    </ContainerBottom>
                  </Card>

                </CardBG> */}
                {/* Roll Competition Card */}
                <CardBG>
                  <InfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.weeklyCashback)}>
                    <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                  </InfoIconWrapper>
                  <Card $background="radial-gradient(116.81% 83.5% at 46.23% 9.2%, rgba(6, 115, 217, .6) 0%, rgba(6, 115, 217, 0) 60%)">
                    <ImagePlaceholder src="/assets/images/bonus/weekly.png" />
                    <CardTitle>Weekly Cashback</CardTitle>
                    <ContainerBottom>
                      <StatsContainer>
                        <StatRow>
                          <span>{bonus?.bonuses.weekly.eligible ? 'Bonus Unlocked' : 'Available at VIP 25'}</span>
                          {bonus?.bonuses.weekly.eligible && bonus?.bonuses.weekly.claimable && (
                            <span style={{ marginLeft: '4px' }}>${bonus.bonuses.weekly.amount.toFixed(2)}</span>
                          )}
                        </StatRow>
                      </StatsContainer>
                      <ClaimButton2
                        disabled={
                          !bonus?.bonuses.weekly.eligible ||
                          !bonus?.bonuses.weekly.claimable ||
                          claimLoading.weekly
                        }
                        $eligible={bonus?.bonuses.weekly.eligible}
                        $claimable={bonus?.bonuses.weekly.claimable}
                        onClick={() => handleClaimBonus('weekly')}
                      >
                        {claimLoading.weekly ? 'Loading...' :
                          !bonus?.bonuses.weekly.eligible ? 'Not Eligible' :
                            bonus?.bonuses.weekly.claimable ? 'Claim' : 'Not Available'}
                      </ClaimButton2>
                    </ContainerBottom>
                  </Card>
                </CardBG>

                {/* Rakeback Card */}
                <CardBG>
                  <InfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.monthlyCashback)}>
                    <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                  </InfoIconWrapper>
                  <Card $background="radial-gradient(116.81% 83.5% at 46.23% 9.2%, rgba(179, 9, 61, .6) 0%, rgba(179, 9, 61, 0) 60%)">
                    <ImagePlaceholder src="/assets/images/bonus/monthly.png" />
                    <CardTitle>Monthly Cashback</CardTitle>
                    <ContainerBottom>
                      <StatsContainer>
                        <StatRow>
                          <span>{bonus?.bonuses.monthly.eligible ? 'Bonus Unlocked' : 'Available at VIP 30'}</span>
                          {bonus?.bonuses.monthly.eligible && bonus?.bonuses.monthly.claimable && (
                            <span style={{ marginLeft: '4px' }}>${bonus.bonuses.monthly.amount.toFixed(2)}</span>
                          )}
                        </StatRow>
                      </StatsContainer>
                      <ClaimButton2
                        disabled={
                          !bonus?.bonuses.monthly.eligible ||
                          !bonus?.bonuses.monthly.claimable ||
                          claimLoading.monthly
                        }
                        $eligible={bonus?.bonuses.monthly.eligible}
                        $claimable={bonus?.bonuses.monthly.claimable}
                        onClick={() => handleClaimBonus('monthly')}
                      >
                        {claimLoading.monthly ? 'Loading...' :
                          !bonus?.bonuses.monthly.eligible ? 'Not Eligible' :
                            bonus?.bonuses.monthly.claimable ? 'Claim' : 'Not Available'}
                      </ClaimButton2>
                    </ContainerBottom>
                  </Card>
                </CardBG>

                <ModalOverlay $show={openModal}>
                  <ModalContent>
                    <ModalHeader>
                      <ModalTitle>Bonus Details</ModalTitle>
                      <CloseButton onClick={() => setOpneModal(false)}>
                        <X size={20} />
                      </CloseButton>
                    </ModalHeader>
                    <ModalBody>
                      <BonusDetails data={bonus} />
                    </ModalBody>
                  </ModalContent>
                </ModalOverlay>
              </GridContainer>
            </div>
          </>
        )
      }
    </>
  );
};

export default Bonus;
