import React, { Component } from 'react';
import { Link } from 'react-router-dom';
import styled from 'styled-components';
import { ChevronLeft, ChevronRight } from 'lucide-react';

// Styled Components
const ProviderWrapper = styled.div`
  margin: 0px 0;
`;

const ProviderHeadingWrapper = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin: 10px 0px;
  // padding: 0 10px;
`;

const IconBg = styled.div`
  padding: 6px 8px;
  background-color: #03030F;
  border-radius: 10px;
  cursor: pointer;
  display: flex;
  align-items: center;
  &:hover {
    background-color: #4a5354;
  }
`;

const ProviderGridContainer = styled.div`
  display: flex;
  overflow-x: auto;
  overflow-y:hidden;
  gap: 10px;
  // padding: 0 10px;
  scroll-behavior: smooth;
  -webkit-overflow-scrolling: touch;
  scrollbar-width: none; /* Firefox */
  &::-webkit-scrollbar {
    display: none; /* Chrome, Safari */
  }

  @media (max-width: 768px) {
    justify-content: flex-start;
  }
`;

const ProviderGridItem = styled(Link)`
  flex: 0 0 auto;
  width: 136px;
  border-radius: 8px;
  overflow: hidden;
  text-decoration: none;
  transition: transform 0.2s ease;

  &:hover {
    transform: scale(1.05);
  }

  @media (max-width: 768px) {
    width: calc((100% - 20px) / 3); /* Adjust width to fit 3 items in a row with 10px gap */
    min-width: 100px; /* Minimum width to ensure readability */
  }
`;

const ProviderLogo = styled.img`
  width: 100%;
  height: 100%;
  object-fit: contain;
  border-radius: 8px;
`;

class GameProviders extends Component {
  constructor(props) {
    super(props);
    this.state = {
      canScrollLeft: false,
      canScrollRight: false,
    };
    this.gridRef = React.createRef();

    // Define companies array within the component
    this.companies = [
      { image: '/assets/images/Providers/evolutiongaming.png', path: '/providers/evolution-gaming' },
      // { image: '/assets/images/Providers/ezugi.png', path: '/providers/ezugi-games' },
      { image: '/assets/images/Providers/pgsoft.png', path: '/providers/pg-soft' },
      { image: '/assets/images/Providers/jili.png', path: '/providers/jili' },
      { image: '/assets/images/Providers/pgslots.png', path: '/providers/pg-slots' },
      { image: '/assets/images/Providers/netent.png', path: '/providers/netent' },
      { image: '/assets/images/Providers/microgaming.png', path: '/providers/microgaming' },
      { image: '/assets/images/Providers/pglive.png', path: '/providers/pglive' },
      { image: '/assets/images/Providers/ideal.png', path: '/providers/ideal' },
      { image: '/assets/images/Providers/spribe.png', path: '/providers/spribe' },
      { image: '/assets/images/Providers/evolutiongaming.png', path: '/providers/evolution-gaming' },
      // { image: '/assets/images/Providers/ezugi.png', path: '/providers/ezugi-games' },
      { image: '/assets/images/Providers/pgsoft.png', path: '/providers/pg-soft' },
      { image: '/assets/images/Providers/jili.png', path: '/providers/jili' },
      { image: '/assets/images/Providers/pgslots.png', path: '/providers/pg-slots' },
      { image: '/assets/images/Providers/netent.png', path: '/providers/netent' },
      { image: '/assets/images/Providers/microgaming.png', path: '/providers/microgaming' },
      { image: '/assets/images/Providers/pglive.png', path: '/providers/pglive' },
      { image: '/assets/images/Providers/ideal.png', path: '/providers/ideal' },
      { image: '/assets/images/Providers/spribe.png', path: '/providers/spribe' },
    ];
  }

  componentDidMount() {
    this.updateScrollState();
    if (this.gridRef.current) {
      this.gridRef.current.addEventListener('scroll', this.updateScrollState);
    }
  }

  componentWillUnmount() {
    if (this.gridRef.current) {
      this.gridRef.current.removeEventListener('scroll', this.updateScrollState);
    }
  }

  updateScrollState = () => {
    const grid = this.gridRef.current;
    if (!grid) return;

    const canScrollLeft = grid.scrollLeft > 0;
    const canScrollRight = grid.scrollLeft + grid.clientWidth < grid.scrollWidth;

    this.setState({ canScrollLeft, canScrollRight });
  };

  handleScroll = (direction) => {
    const grid = this.gridRef.current;
    if (!grid) return;

    const scrollAmount = 300; // Adjust as needed
    const newScrollPosition =
      direction === 'left'
        ? grid.scrollLeft - scrollAmount
        : grid.scrollLeft + scrollAmount;

    grid.scrollTo({ left: newScrollPosition, behavior: 'smooth' });
  };

  render() {
    const { canScrollLeft, canScrollRight } = this.state;

    return (
      <ProviderWrapper>
        <ProviderHeadingWrapper>
          <div style={{ fontWeight: 'bold', fontSize: '16px', fontStyle: 'italic', color: '#F99D06' }}>
            GAME PROVIDERS
          </div>
          <div style={{ display: 'flex', gap: '4px', alignItems: 'center' }}>
            <IconBg
              onClick={() => this.handleScroll('left')}
              disabled={!canScrollLeft}
              $isActive={canScrollLeft}
            >
              <ChevronLeft size={18} color="white" />
            </IconBg>
            <IconBg
              onClick={() => this.handleScroll('right')}
              disabled={!canScrollRight}
              $isActive={canScrollRight}
            >
              <ChevronRight size={18} color="white" />
            </IconBg>
          </div>
        </ProviderHeadingWrapper>
        <ProviderGridContainer ref={this.gridRef}>
          {this.companies.map((company, index) => (
            <ProviderGridItem
              key={index}
              to={company.path}
            >
              <ProviderLogo src={company.image} alt={`Provider ${index + 1}`} />
            </ProviderGridItem>
          ))}
        </ProviderGridContainer>
      </ProviderWrapper>
    );
  }
}

export default GameProviders;