import React from 'react';
import styled from 'styled-components';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import {
  faSearch,
  faTicket,
  faGift,
  faShield,
  faClock,
  faFootballBall,
  faHorse,
  faDog,
  faBullseye,
  faTableTennis,
  faChevronRight,
  faEye,
  faBasketball,
  faCircle,
  faCar,
  faFistRaised,
  faTrophy,
  faGolfBall,
  faHandRock,
  faVolleyball,
  faGamepad,
  faMotorcycle,
  faChess,
  faRunning,
  faBicycle
} from '@fortawesome/free-solid-svg-icons';

// Sport ID map for API usage
export const SPORT_ID_MAP = {
  'cricket': '4',
  'tennis': '2',
  'soccer': '1',
  'american-football': '6423',
  'baseball': '7511',
  'basketball': '7522',
  'boxing': '6',
  'darts': '3503',
  'gaelic-games': '2152880',
  'golf': '3',
  'greyhound-racing': '4339',
  'horse-racing': '7',
  'mma': '26420387',
  'motorsport': '8',
  'rugby-league': '1477',
  'rugby-union': '5',
  'snooker': '6422',
  // Optional extras if needed
  'greyhound-todays-card': '15',
  'horse-race-todays-card': '13'
};

// Constants
const POPULAR_ITEMS = [
  { id: 'my-bets', label: 'My Bets', icon: faTicket },
//   { id: 'promotions', label: 'Promotions', icon: faGift },
//   { id: 'beat-the-drop', label: 'Beat The Drop', icon: faShield },
//   { id: 'safer-gambling', label: 'Safer Gambling', icon: faShield }
];

const SPORTS_ITEMS = [
  { id: 'all-sports', label: 'All Sports', icon: faBullseye, type: 'icon' },
  { id: 'soccer', label: 'Soccer', icon: '/assets/images/sports-matches/football.svg', type: 'image' },
  { id: 'tennis', label: 'Tennis', icon: '/assets/images/sports-matches/tennis.svg', type: 'image' },
  { id: 'cricket', label: 'Cricket', icon: '/assets/images/sports-matches/cricket.svg', type: 'image' },
  { id: 'mma', label: 'Mixed Martial Arts', icon: '/assets/images/sports-matches/mma.svg', type: 'image' },
  { id: 'golf', label: 'Golf', icon: '/assets/images/sports-matches/golf.svg', type: 'image' },
  { id: 'boxing', label: 'Boxing', icon: faFistRaised, type: 'icon' },
  { id: 'american-football', label: 'American Football', icon: '/assets/images/sports-matches/american.svg', type: 'image' },
  { id: 'baseball', label: 'Baseball', icon: '/assets/images/sports-matches/baseball.svg', type: 'image' },
  { id: 'basketball', label: 'Basketball', icon: faBasketball, type: 'icon' },
  { id: 'rugby-league', label: 'Rugby League', icon: faCircle, type: 'icon' },
  { id: 'rugby-union', label: 'Rugby Union', icon: '/assets/images/sports-matches/rughbyunion.svg', type: 'image' },
  { id: 'horse-racing', label: 'Horse Racing', icon: '/assets/images/sports-matches/horse.svg', type: 'image' },
  { id: 'greyhound-racing', label: 'Greyhound Racing', icon: '/assets/images/sports-matches/grey.svg', type: 'image' },
  { id: 'motorsport', label: 'Motor Sport', icon: faCar, type: 'icon' },
  { id: 'snooker', label: 'Snooker', icon: '/assets/images/sports-matches/snooker.svg', type: 'image' },
  { id: 'darts', label: 'Darts', icon: '/assets/images/sports-matches/dart.svg', type: 'image' },
  { id: 'gaelic-games', label: 'Gaelic Games', icon: faCircle, type: 'icon' },
  // Additional special cards
  { id: 'greyhound-todays-card', label: 'Greyhound Todays Card', icon: '/assets/images/sports-matches/grey.svg', type: 'image' },
  { id: 'horse-race-todays-card', label: 'Horse Race Todays Card', icon: '/assets/images/sports-matches/horse.svg', type: 'image' }
];

// Styled Components
const Section = styled.div`
  flex: ${props => props.width};
  background-color: #000000;
  min-height: 100vh;
  overflow: hidden;
  // border-right: 1px solid rgb(240, 156, 6);
  font-family: 'Montserrat Alternates', sans-serif;
`;

const SideMenuContainer = styled.div`
  background-color: #000000;
  padding: 12px 0;
  height: 100vh;
  overflow-y: auto;
  border-right: 2px solid rgb(50, 55, 56);
  font-family: 'Montserrat Alternates', sans-serif;
  
  &::-webkit-scrollbar {
    width: 3px;
  }
  
  &::-webkit-scrollbar-thumb {
    background-color: rgb(240, 156, 6);
    border-radius: 2px;
  }
`;

const SearchContainer = styled.div`
  padding: 0 12px 16px 12px;
  border-bottom: 1px solid rgb(50, 55, 56);
  margin-bottom: 12px;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const SearchInput = styled.div`
  background-color: rgb(50, 55, 56);
  border-radius: 4px;
  padding: 8px 10px;
  display: flex;
  align-items: center;
  gap: 8px;
  cursor: pointer;
  transition: all 0.3s ease;
  border: 1px solid transparent;
  font-family: 'Montserrat Alternates', sans-serif;
  
  &:hover {
    background-color: rgb(60, 65, 66);
    border-color: rgb(240, 156, 6);
  }
  
  &:focus-within {
    border-color: rgb(240, 156, 6);
    box-shadow: 0 0 0 2px rgba(240, 156, 6, 0.2);
  }
`;

const SearchIcon = styled(FontAwesomeIcon)`
  color: rgb(240, 156, 6);
  font-size: 12px;
`;

const SearchPlaceholder = styled.span`
  color: #ffffff;
  font-size: 10px;
  font-family: 'Montserrat Alternates', sans-serif;
  flex: 1;
  opacity: 0.8;
`;

const SectionTitle = styled.h3`
  color: rgb(240, 156, 6);
  font-size: 11px;
  font-weight: bold;
  margin: 0 0 8px 12px;
  font-family: 'Montserrat Alternates', sans-serif;
  text-transform: uppercase;
  letter-spacing: 0.3px;
  position: relative;
  
  &:after {
    content: '';
    position: absolute;
    bottom: -4px;
    left: 12px;
    right: 12px;
    height: 1px;
    background: linear-gradient(90deg, rgb(240, 156, 6) 0%, transparent 100%);
  }
`;

const MenuList = styled.ul`
  list-style-type: none;
  padding: 0;
  margin: 0 0 16px 0;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const MenuItem = styled.li`
  background-color: transparent;
  margin: 0 12px 2px 12px;
  border-radius: 4px;
  cursor: pointer;
  transition: all 0.3s ease;
  border: 1px solid transparent;
  font-family: 'Montserrat Alternates', sans-serif;
  
  &:hover {
    background-color: rgb(50, 55, 56);
    // border-color: rgb(240, 156, 6);
    transform: translateX(2px);
  }
  
  &.active {
    background-color: rgb(50, 55, 56);
    // border-color: rgb(240, 156, 6);
    box-shadow: 0 1px 4px rgba(240, 156, 6, 0.2);
  }
`;

const MenuItemContent = styled.div`
  padding: 8px 12px;
  display: flex;
  align-items: center;
  justify-content: space-between;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const MenuItemLeft = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const MenuIcon = styled(FontAwesomeIcon)`
  color: rgb(240, 156, 6);
  font-size: 11px;
  width: 12px;
  text-align: center;
`;

const MenuImage = styled.img`
  width: 12px;
  height: 12px;
  object-fit: contain;
  filter: brightness(0) saturate(100%) invert(67%) sepia(89%) saturate(1234%) hue-rotate(359deg) brightness(101%) contrast(101%);
`;

const MenuLabel = styled.span`
  color: #ffffff;
  font-size: 13px;
  font-family: 'Montserrat Alternates', sans-serif;
  font-weight: 500;
`;

const ArrowIcon = styled(FontAwesomeIcon)`
  color: rgb(240, 156, 6);
  font-size: 8px;
  opacity: 0.7;
  transition: all 0.3s ease;
  
  ${MenuItem}:hover & {
    opacity: 1;
    transform: translateX(1px);
  }
`;

// SideMenu Component
const SideMenu = React.memo(({ activeTab, onTabChange }) => (
  <Section width="0 0 15%">
    <SideMenuContainer>
      {/* <SearchContainer>
        <SearchInput>
          <SearchIcon icon={faSearch} />
          <SearchPlaceholder>Search Teams or Events</SearchPlaceholder>
        </SearchInput>
      </SearchContainer> */}
{/* 
      <SectionTitle>Popular</SectionTitle>
      <MenuList>
        {POPULAR_ITEMS.map(item => (
          <MenuItem key={item.id}>
            <MenuItemContent>
              <MenuItemLeft>
                <MenuIcon icon={item.icon} />
                <MenuLabel>{item.label}</MenuLabel>
              </MenuItemLeft>
              <ArrowIcon icon={faChevronRight} />
            </MenuItemContent>
          </MenuItem>
        ))}
      </MenuList> */}

      {/* <SectionTitle>Sports</SectionTitle> */}
      <MenuList>
        {SPORTS_ITEMS.map(item => (
          <MenuItem 
            key={item.id}
            className={activeTab === item.id ? 'active' : ''}
            onClick={() => onTabChange(item.id)}
          >
            <MenuItemContent>
              <MenuItemLeft>
                {item.type === 'image' ? (
                  <MenuImage src={item.icon} alt={item.label} />
                ) : (
                  <MenuIcon icon={item.icon} />
                )}
                <MenuLabel>{item.label}</MenuLabel>
              </MenuItemLeft>
              {/* <ArrowIcon icon={faChevronRight} /> */}
            </MenuItemContent>
          </MenuItem>
        ))}
      </MenuList>
    </SideMenuContainer>
  </Section>
));

export default SideMenu; 