import React, { useState, useEffect, useLayoutEffect } from 'react';
import SportsWeb from "./SportsWeb";
import SportsMobileView from './SportsMobile';
import ComingSoonSports from './components/DisabledSports';
import CricketBetUiComponent from './components/CricketUi/CricketBetUi';
import styled, { keyframes } from 'styled-components';
import { useSiteConfig } from '../../../hooks/useSiteConfig';

// Loader animation
const spin = keyframes`
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
`;

const LoaderContainer = styled.div`
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  background-color: #1A1D1F;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const Loader = styled.div`
  width: 50px;
  height: 50px;
  border: 5px solid #2C3137;
  border-top: 5px solid #f09c06;
  border-radius: 50%;
  animation: ${spin} 1s linear infinite;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const Sports = () => {
  const [activeTab, setActiveTab] = useState('');
  const [isMobile, setIsMobile] = useState(false);
  const [sportsEnabled, setSportsEnabled] = useState(null);
  const [isLoading, setIsLoading] = useState(true);
  const { siteConfig } = useSiteConfig();

  console.log("SITTEEEE", siteConfig);

  useEffect(() => {
    const checkScreenSize = () => {
      setIsMobile(window.innerWidth <= 768);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => {
      window.removeEventListener('resize', checkScreenSize);
    };
  }, []);

  useLayoutEffect(() => {
    const fetchSportsConfig = async () => {
      try {
        const token = localStorage.getItem('token');
        const response = await fetch('https://api.boss707.com/sportsCheck', {
          headers: {
            'Authorization': `Bearer ${token}`,
            'Content-Type': 'application/json'
          }
        });

        if (!response.ok) {
          throw new Error(`HTTP error! status: ${response.status}`);
        }

        const data = await response.json();
        console.log("Sports API Response:", data);
        
        // Use the correct property name from the API response
        setSportsEnabled(data.sportsEnabled);
      } catch (error) {
        console.error('Error fetching sports configuration:', error);
        // Set to false on error to show disabled state
        setSportsEnabled(false);
      } finally {
        setIsLoading(false);
      }
    };

    fetchSportsConfig();
  }, []);

  const handleTabClick = (tab) => {
    setActiveTab(tab);
  };

  // Show loader while fetching data
  if (isLoading) {
    return (
      <LoaderContainer>
        <Loader />
      </LoaderContainer>
    );
  }

  // Render based on sports enabled status
  return (
    <>
   
        // Sports is disabled - show coming soon component
        <ComingSoonSports />

    </>
  );
};

export default Sports;