import React from 'react';
import styled from 'styled-components';


const data= [

    { level: 'VIP 22', xpAmount: 49000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 23', xpAmount: 59000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 24', xpAmount: 69000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 25', xpAmount: 79000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 26', xpAmount: 89000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 27', xpAmount: 99000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 28', xpAmount: 109000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 29', xpAmount: 119000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 30', xpAmount: 129000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 31', xpAmount: 153000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 32', xpAmount: 177000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 33', xpAmount: 201000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 34', xpAmount: 225000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 35', xpAmount: 249000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 36', xpAmount: 273000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' },
    { level: 'VIP 37', xpAmount: 297000, xpProgress: 'Not Started', star: 1, bonus: '/assets/images/box.png', iconPath: '/assets/images/goldStar.png' }
  ];

const Table = styled.table`
  width: 100%;
  color: #ffffff;
  border-collapse: collapse;
`;

const TableContainer = styled.div`
  width: 100%;
  background-color: #1E2024;
  color: #ffffff;
  padding: 12px;
  border-radius: 12px;
`;

const TableHeader = styled.th`
  text-align: left;
  padding: 10px;
  font-weight: normal;
  color: #F5F6F7;
`;

const TableRow = styled.tr`
  &:nth-child(even) {
    background-color: #282B30;
  }
`;

const TableCell = styled.td`
  padding: 10px;
  color: #F5F6F7;
`;

const LevelIcon = styled.img`
  width: 14px;
  height: 18px;
  margin-right: 5px;
  vertical-align: middle;
`;

const ProgressBar = styled.div`
  width: 50px;
  height: 4px;
  background-color: #2e2e2e;
  border-radius: 2px;
`;

const StarContainer = styled.div`
  display: flex;
`;

const Star = styled.div`
  width: 15px;
  height: 15px;
  background-color: ${props => props.active ? '#ffffff' : '#4e4e4e'};
  clip-path: polygon(50% 0%, 61% 35%, 98% 35%, 68% 57%, 79% 91%, 50% 70%, 21% 91%, 32% 57%, 2% 35%, 39% 35%);
  margin-right: 2px;
`;

const BonusIcon = styled.img`
  width: 20px;
  height: 20px;
  object-fit: contain;
`;

const GoldTable = () => {
    return (
        <div style={{margin:'10px 0'}}>
            
            <TableContainer>
                <div style={{padding:'20px'}}>
                    <div style={{ color: '#F5F6F7' }}>Gold Card</div>
                </div>
                <Table>
                    <thead>
                        <tr>
                            <TableHeader>Level</TableHeader>
                            <TableHeader>XP Amount</TableHeader>
                            <TableHeader>XP Progress Bar</TableHeader>
                            <TableHeader>Star</TableHeader>
                            <TableHeader>Bonus</TableHeader>
                        </tr>
                    </thead>
                    <tbody>
                        {data.map((row, index) => (
                            <TableRow key={index}>
                                <TableCell>
                                    <LevelIcon src={row.iconPath} alt={row.level} />
                                    {row.level}
                                </TableCell>
                                <TableCell>{row.xpAmount}</TableCell>
                                <TableCell>
                                    {row.xpProgress}
                                    <ProgressBar />
                                </TableCell>
                                <TableCell>
                                    <StarContainer>
                                        {['/assets/images/goldStar.png', '/assets/images/goldStar.png', '/assets/images/goldStar.png', '/assets/images/goldStar.png', '/assets/images/goldStar.png'].map((_, i) => (
                                            <LevelIcon key={i} src={row.iconPath} alt={row.level} />
                                        ))}
                                    </StarContainer>
                                </TableCell>
                                <TableCell>
                                    <BonusIcon src={row.bonus} alt={row.bonus} />
                                </TableCell>
                            </TableRow>
                        ))}
                    </tbody>
                </Table>
            </TableContainer>
        </div>
    );
};

export default GoldTable;