import React, { useEffect, useLayoutEffect, useState } from 'react';
import styled from 'styled-components';
import VIPClubModal from './LoggedInVip';

// Styled Components
const Container = styled.div`
  padding: 20px 10px;
  width: 100%;
  box-sizing: border-box;
`;

const Card = styled.div`
  background: linear-gradient(87deg, rgba(255, 130, 15, 0) 1.53%, rgba(255, 130, 15, 0.4) 98.57%);
  border-radius: 12px;
  padding: 40px;
  color: white;
  display: flex;
  justify-content: space-between;
  align-items: center;
  position: relative;
  overflow: hidden;
  box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
  max-width: 1200px;
  margin: 20px auto;
  min-height: 300px;

  @media (max-width: 968px) {
    padding: 30px;
    min-height: 250px;
  }

  @media (max-width: 768px) {
    flex-direction: column;
    padding: 20px;
    text-align: center;
    min-height: auto;
  }

  @media (max-width: 480px) {
    padding: 15px;
  }
`;

const Content = styled.div`
  max-width: 50%;
  z-index: 2;
  position: relative;

  @media (max-width: 968px) {
    max-width: 60%;
  }

  @media (max-width: 768px) {
    max-width: 100%;
    margin-bottom: 20px;
  }
`;

const Title = styled.h1`
  font-size: 2.5rem;
  font-weight: bold;
  margin-bottom: 20px;
  color: white;
  line-height: 1.2;
  font-family: 'Montserrat Alternates', sans-serif;
  text-transform: uppercase;

  @media (max-width: 968px) {
    font-size: 2rem;
  }

  @media (max-width: 768px) {
    font-size: 1.8rem;
  }

  @media (max-width: 480px) {
    font-size: 1.5rem;
    margin-bottom: 15px;
  }
`;

const Description = styled.p`
  font-size: 1.1rem;
  line-height: 1.6;
  color: #cccccc;
  margin-bottom: 30px;
  font-weight: 300;

  @media (max-width: 968px) {
    font-size: 1rem;
  }

  @media (max-width: 480px) {
    font-size: 0.9rem;
    margin-bottom: 20px;
  }
`;

const SignUpButton = styled.div`
  background: linear-gradient(90deg, #ffd700 0%, #ffb700 100%);
  color: black;
  text-align: center;
  padding: 12px 40px;
  width: 300px;
  border-radius: 15px;
  font-size: 1.1rem;
  font-weight: bold;
  border: none;
  cursor: pointer;
  transition: all 0.3s ease;

  &:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(255, 215, 0, 0.3);
  }

  @media (max-width: 768px) {
    width: 250px;
  }

  @media (max-width: 480px) {
    width: 200px;
    padding: 10px 20px;
    font-size: 1rem;
  }
`;

const RadialBackground = styled.div`
  position: absolute;
  right: 0;
  top: 50%;
  transform: translateY(-50%);
  width: 600px;
  height: 600px;
  background: radial-gradient(circle, rgba(255, 130, 15, 0.2) 0%, transparent 70%);
  z-index: 1;

  @media (max-width: 968px) {
    width: 400px;
    height: 400px;
  }

  @media (max-width: 768px) {
    width: 300px;
    height: 300px;
    right: 50%;
    transform: translate(50%, -50%);
  }

  @media (max-width: 480px) {
    width: 200px;
    height: 200px;
  }
`;

const ImageContainer = styled.div`
  position: absolute;
  right: 20px;
  top: 50%;
  transform: translateY(-50%);
  z-index: 3;
  width: 45%;
  display: flex;
  align-items: center;
  justify-content: center;

  @media (max-width: 968px) {
    width: 40%;
    right: 10px;
  }

  @media (max-width: 768px) {
    position: relative;
    width: 100%;
    max-width: 300px;
    right: auto;
    top: auto;
    transform: none;
    margin: 0 auto;
    height: 200px;
  }

  @media (max-width: 480px) {
    max-width: 250px;
    height: 150px;
  }
`;

const StyledImage = styled.img`
  width: 100%;
  height: 100%;
  object-fit: contain;
  filter: drop-shadow(0px 4px 8px rgba(0, 0, 0, 0.2));
`;

const Star = styled.div`
  position: absolute;
  width: 10px;
  height: 10px;
  background: #ffd700;
  clip-path: polygon(50% 0%, 61% 35%, 98% 35%, 68% 57%, 79% 91%, 50% 70%, 21% 91%, 32% 57%, 2% 35%, 39% 35%);
  animation: twinkle 1.5s infinite alternate;

  &:nth-child(1) { top: 20%; right: 15%; }
  &:nth-child(2) { top: 30%; right: 35%; }
  &:nth-child(3) { top: 60%; right: 25%; }

  @media (max-width: 768px) {
    width: 8px;
    height: 8px;
  }

  @keyframes twinkle {
    from { opacity: 0.4; }
    to { opacity: 1; }
  }
`;

const CardContainer = styled.div`
  display: grid;
  grid-template-columns: repeat(3, 1fr);
  column-gap: 20px;
  row-gap: 60px;
  padding: 40px 20px;
  max-width: 1200px;
  margin: 0 auto;

  @media (max-width: 968px) {
    grid-template-columns: repeat(2, 1fr);
    padding: 30px 15px;
  }

  @media (max-width: 480px) {
    grid-template-columns: 1fr;
    row-gap: 40px;
    padding: 20px 10px;
  }
`;

const CardB = styled.div`
  background: #323738;
  border-radius: 12px;
  padding: 20px;
  position: relative;
  text-align: center;
  min-height: 200px;
  display: flex;
  flex-direction: column;
  justify-content: flex-end;
  align-items: center;

  @media (max-width: 480px) {
    min-height: 180px;
    padding: 15px;
  }
`;

const ImageContainerB = styled.div`
  position: absolute;
  top: -60px;
  left: 50%;
  transform: translateX(-50%);
  width: 120px;
  height: 120px;
  display: flex;
  justify-content: center;
  align-items: center;

  @media (max-width: 968px) {
    width: 100px;
    height: 100px;
    top: -50px;
  }

  @media (max-width: 480px) {
    width: 90px;
    height: 90px;
    top: -45px;
  }
`;

const CardImage = styled.img`
  width: 100%;
  height: 100%;
  object-fit: contain;
`;

const TitleB = styled.h3`
  color: white;
  font-size: 24px;
  margin: 40px 0 10px;
  font-weight: 600;
  font-family: 'Montserrat Alternates', sans-serif;

  @media (max-width: 968px) {
    font-size: 20px;
    margin: 35px 0 8px;
  }

  @media (max-width: 480px) {
    font-size: 18px;
    margin: 30px 0 6px;
  }
`;

const DescriptionB = styled.p`
  color: #9fa6b2;
  font-size: 16px;
  line-height: 1.5;
  margin: 0;

  @media (max-width: 968px) {
    font-size: 14px;
  }

  @media (max-width: 480px) {
    font-size: 13px;
  }
`;

const VipClub = () => {
  const [isLoggedIn, setIsLoggedIn] = useState(false);

  useLayoutEffect(() => {
    // Check localStorage on component mount
    const loginStatus = localStorage.getItem('logged');
    setIsLoggedIn(loginStatus === 'true');

    // Add event listener for storage changes
    const handleStorageChange = () => {
      const updatedLoginStatus = localStorage.getItem('logged');
      setIsLoggedIn(updatedLoginStatus === 'true');
    };

    window.addEventListener('storage', handleStorageChange);

    // Cleanup event listener
    return () => {
      window.removeEventListener('storage', handleStorageChange);
    };
  }, []);

  const features = [
    {
      title: 'No-Fee Withdrawal',
      description: 'Reach VIP 38 for no-fee cryptocurrency withdrawals.',
      image: '/assets/images/bcgames/vip/c1.webp',
    },
    {
      title: 'Rewarding Lucky Spin',
      description: 'Spin the wheel & receive bigger prizes as you level up.',
      image: '/assets/images/bcgames/vip/c2.webp',
    },
    {
      title: 'Dedicated VIP Host',
      description: 'Selected VIPs get personalized attention from a dedicated host.',
      image: '/assets/images/bcgames/vip/c3.webp',
    },
    {
      title: 'Amazing Level Up Bonus',
      description: 'Unlock multiple surprise rewards as you level up.',
      image: '/assets/images/bcgames/vip/c4.webp',
    },
    {
      title: 'Fun Tips & Raining',
      description: 'Tip to show appreciation or try Coin Drops to win rewards.',
      image: '/assets/images/bcgames/vip/c6.webp',
    },
    {
      title: 'Exclusive Cashback',
      description: 'Earn incredible cashback rewards every week & month.',
      image: '/assets/images/bcgames/vip/c5.webp',
    },
  ];

  return (
    <>
      {isLoggedIn ? (
        <VIPClubModal />
      ) : (
        <Container>
          <Card>
            <Content>
              <Title>Exclusive VIP Benefits</Title>
              <Description>
                Join our VIP Club now and get ready to be showered with gifts, giveaways,
                and amazing features. Experience the thrill of higher cash back and exclusive
                rewards that are sure to leave you amazed.
              </Description>
              <SignUpButton>Sign Up</SignUpButton>
            </Content>
            <RadialBackground />
            <ImageContainer>
              <Star />
              <Star />
              <Star />
              <StyledImage
                src="/assets/images/bcgames/vip/v1.png"
                alt="VIP Benefits illustration"
              />
            </ImageContainer>
          </Card>

          <CardContainer>
            {features.map((feature, index) => (
              <CardB key={index}>
                <ImageContainerB>
                  <CardImage src={feature.image} alt={feature.title} />
                </ImageContainerB>
                <TitleB>{feature.title}</TitleB>
                <DescriptionB>{feature.description}</DescriptionB>
              </CardB>
            ))}
          </CardContainer>
        </Container>
      )}
    </>
  );
};

export default VipClub;