import React, { useCallback, useEffect, useState } from 'react';
import styled from 'styled-components';
import { ChevronRight, ChevronDown, Search, Info, FileQuestion } from "lucide-react";
import storage from "../../../../Storage";
import C from "../../../../Constant";
import coins from "../../../coins";
import socket from "../../../../Socket";
import { Col, Dropdown } from "react-bootstrap";
import {
  __, wait, decode, encode, forceSatoshiFormat, Event,
  isMobile,
  sendNotfication,
  getUID,
} from '../../../../Helper';
import axios from 'axios';


const WithdrawContainer = styled.div`
  margin: 0 auto;
  padding: 24px 0;
  border-top: 1px solid rgba(255, 255, 255, 0.1);
  border-bottom: 1px solid rgba(255, 255, 255, 0.1);
`;

const Row1 = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 8px 0;
`;

const Label1 = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
  
  ${props => props.isGreen && `
    color: #20EE89;
    font-size: 16px;
    font-weight: 500;
  `}
  
  ${props => props.isGray && `
    color: #9ba1a6;
    font-size: 14px;
  `}
`;

const Amount = styled.div`
${props => props.isGreen && `
    color: #20EE89;

   
  `}
  font-size: ${props => props.large ? '16px' : '14px'};
  font-weight: ${props => props.bold ? '600' : '400'};
`;

const IconButton = styled.button`
  background: none;
  border: none;
  padding: 0;
  cursor: pointer;
  width: 16px;
  height: 16px;
  display: flex;
  align-items: center;
  justify-content: center;
  opacity: 0.7;
  
  img {
    width: 100%;
    height: 100%;
    object-fit: contain;
  }
  
  &:hover {
    opacity: 1;
  }
`;



const Container = styled.div`
  padding: 8px;
  color: #ffffff;
`;
const DropdownContainer = styled.div`
  position: relative;
  margin-bottom: 16px;
  flex:1;
`;

const DropdownButton = styled.button`
  display: flex;
  align-items: center;
  justify-content: space-between;
  width: 100%;
  padding:6px 10px;
     background: rgb(30, 35, 40);
  border: 1px solid rgba(255, 255, 255, 0.05);
 
  border-radius: 8px;
  color: #ffffff;
  cursor: pointer;
  font-size: 16px;
`;

const DropdownPanel = styled.div`
  position: absolute;
  top: 100%;
  left: 0;
  right: 0;
     background: rgb(30, 35, 40);
  border: 1px solid rgba(255, 255, 255, 0.05);
  border: 1px solid rgb(58 65 66);
  border-radius: 8px;
  margin-top: 4px;
  max-height: 400px;
  overflow-y: auto;
  z-index: 900;
  padding:10px 12px;
`;

const SearchContainer = styled.div`
  position: relative;
  padding:0px;
    border-radius: 8px;
  border: 1px solid rgb(58 65 66);
  margin-top:12px;
`;

const SearchInput = styled.input`
  width: 100%;
  padding: 6px 12px 6px 40px;
  background: transparent;
  border: none;
  border-radius: 8px;
  color: #ffffff;
  font-size: 16px;
  &::placeholder {
    color: #fff;
    opacity:0.6;
  }
`;

const Input = styled.input`
width:100%;
  padding:6px 10px;
     background: rgb(30, 35, 40);
  border: 1px solid rgba(255, 255, 255, 0.05);
  margin-bottom:12px;
  // border: 1px solid rgb(58 65 66);
  border-radius: 8px;
  color: #ffffff;
  font-size: 14px;
  &::placeholder {
    color: #fff;
    opacity:0.4;
  }
`;
const DepositButton = styled.div`
  margin-top: auto;
flex:1;
padding:7px 9px;
  display:flex;
  justify-content:center;
  align-items:center;
 background:#f09c06;
  color: black !important;
  border: none;
  border-radius: 0.5rem;
  font-weight: 600;
  cursor: pointer;
  
  &:hover {
    opacity: 0.9;
  }
`;
const SearchIcon = styled.div`
  position: absolute;
  left: 14px;
  top: 49%;
  transform: translateY(-50%);
  color: #fff;
`;

const CoinOption = styled.div`
  display: flex;
  align-items: center;
  padding: 14px;
  cursor: pointer;
  border-radius:12px;
  &:hover {
    background: rgba(0, 0, 0, 0.25);
    border-color: rgba(255, 255, 255, 0.1);
  }
  ${props => props.isSelected && `
       background: rgba(0, 0, 0, 0.25);
    border-color: rgba(255, 255, 255, 0.1)  
  `}
`;

const CoinImage = styled.img`
  width: 24px;
  height: 24px;
  border-radius: 50%;
  margin-right: 12px;
`;

const CoinName = styled.div`
  font-size: 16px;
  font-weight: bold;
 
`;

const CoinBalance = styled.span`
  margin-left: auto;
  color: #8E9293;
   display:none;
`;


// const CoinName = styled.span`
//   font-size: 16px;
//   font-weight: 500;
// `;

const TokenListContainer = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
  margin-top: 16px;
`;

const TokenButton = styled.button`
  display: flex;
  align-items: center;
  gap: 8px;
  padding: 8px 16px;
  background: #394142;
  border-radius: 100px;
  border: none;
  cursor: pointer;
  color: #ffffff;
  transition: background 0.2s ease;
  &:hover {
    background: #363A3B;
  }
`;

const TokenIcon = styled.img`
  width: 24px;
  height: 24px;
  border-radius: 50%;
`;

const TokenName = styled.div`
  font-size: 14px;
  font-weight: 500;
`;

const MoreButton = styled(TokenButton)`
  padding: 8px 12px;
`;

const FooterText = styled.div`
  color: #ffffff;
  margin: 18px 0;
`;

const AddLink = styled.span`
  color: #20EE89;
  cursor: pointer;
`;

const QRCodeContainer = styled.div`
  width: 120px;
  height: 120px;
  background-color: #fff;
  border-radius: 4px;
  overflow: hidden;
  
  img {
    width: 100%;
    height: 100%;
    object-fit: contain;
  }
`;

const ContentContainer = styled.div`
  flex: 1;
  display: flex;
  flex-direction: column;
  gap: 10px;
`;

const Label = styled.div`
  color: #9ba1a6;
  font-size: 14px;
`;

const AddressContainer = styled.div`
  background-color: #2c3235;
  padding: 12px 16px;
  border-radius: 6px;
  color: #fff;
  font-family: monospace;
  font-size: 14px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  gap: 10px;
  
  span {
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
  }
`;

const CopyButton = styled.button`
  background-color: #3c4246;
  color: #fff;
  border: none;
  padding: 8px 16px;
  border-radius: 4px;
  cursor: pointer;
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 14px;
  transition: background-color 0.2s;
  white-space: nowrap;
  
  &:hover {
    background-color: #4c5256;
  }
`;

const CopyIcon = styled.span`
  display: inline-block;
  width: 16px;
  height: 16px;
  background-color: currentColor;
  mask: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24' stroke='currentColor'%3E%3Cpath stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z' /%3E%3C/svg%3E");
  mask-size: contain;
  mask-repeat: no-repeat;
  mask-position: center;
`;



const CodeContainer = styled.div`
  border-radius: 8px;
  display: flex;
  gap: 20px;
  align-items: center;
  margin: 12px auto;
`;
const WarningContainer = styled.div`
  background-color: rgba(52, 199, 89, 0.1);
  border-radius: 8px;
  padding: 12px 16px;
  display: flex;
  align-items: center;
  gap: 12px;
  margin: 16px auto;
  margin-bottom: 16px;
`;

const IconWrapper = styled.div`
  width: 20px;
  height: 20px;
  
  img {
    width: 100%;
    height: 100%;
    object-fit: contain;
  }
`;

const WarningText = styled.span`
  color: #fff;
  font-size: 13px;
  font-weight: 500;
`;

const WarningTextGreen = styled.span`
color: #34C759;
font-size: 14px;
font-weight: 500;
`;
const BonusContainer = styled.div`
  background-color: rgba(180, 155, 100, 0.2);
  border-radius: 8px;
  padding: 12px 16px;
  display: flex;
  align-items: center;
  gap: 12px;
  margin: 18px auto;
  margin-bottom: 16px;
`;

const IconWrapper1 = styled.div`
  width: 28px;
  height: 28px;
  
  img {
    width: 100%;
    height: 100%;
    object-fit: contain;
  }
`;

const TextContainer = styled.div`
  display: flex;
  align-items: center;
  gap: 4px;
  flex-wrap: wrap;
`;

const BaseText = styled.span`
  color: #ffffff;
  font-size: 15px;
  font-weight: 600;
`;

const HighlightedText = styled(BaseText)`
  color: #FFA500;
`;


const cryptoOptions = [
  { id: 'dot', name: 'DOT', iconClass: 'dot' },
  { id: 'link', name: 'LINK', iconClass: 'link' },
  { id: 'dai', name: 'DAI', iconClass: 'dai' },
  { id: 'usdc', name: 'USDC', iconClass: 'usdc' },
  { id: 'xmr', name: 'XMR', iconClass: 'xmr' },
];

const tokens = [
  { id: 'eth', name: 'ETH', icon: '/assets/images/ETH.png' },
  { id: 'btc', name: 'BTC', icon: '/assets/images/BTC.png' },
  { id: 'usdt', name: 'USDT', icon: '/assets/images/USDT.png' },
  { id: 'usdc', name: 'USDC', icon: '/assets/images/USDC.png' },
  { id: 'doge', name: 'DOGE', icon: '/assets/images/DOGE.png' },
];

const SkylaWithdraw = () => {
  const [isOpen, setIsOpen] = useState(false);
  const [isOpenNetwork, setIsOpenNetwork] = useState(false);
  const [searchTerm, setSearchTerm] = useState("");
  const [selectedNetwork, setSelectedNetwork] = useState("ETherum")
  const [password, setPassword] = useState("");
  const [passwordError, setPasswordError] = useState("");
  const [chainName, setChainName] = useState("");
  // Coin and credit state
  const [credits, setCredits] = useState({});
  const [selectedCoin, setSelectedCoin] = useState(storage.getKey('coin') || "INR");
  const [activeCoins, setActiveCoins] = useState(
    storage.getKey('active_coins')?.split(',').map(String) || ['1']
  );
  const [bankName, setBankName] = useState("");
  const [accountNumber, setAccountNumber] = useState("");
  const [accountHolderName, setAccountHolderName] = useState("");
  const [ifscCode, setIfscCode] = useState("");
  const [upiId, setUpiId] = useState("");
  const [inrWithdrawalType, setInrWithdrawalType] = useState("upi"); 
  // Main component state
  const [state, setState] = useState({
    currentCoin: storage.getKey('coin') || "MVR",
    credits: {},
    list: [],
    content: [],
    wallet: "btc",
    deposit: true,
    slide: false,
    height: 573,
    margin: "mt-1",
    amount: "",
    coinId: "",
    networks: [],
    selectedNetwork: "",
    qrString: "",
    coinName: "",
    logoUrl: "",
    isLoading: false,
    isCopied: false,
    depositAddress: "",
    depositAmount: "",
    showDepositDetails: false
  });
  const [copied, setCopied] = React.useState(false);
  const address = "0x5e6E82fc1117AE06c8b1230164284Ec5d0141Df";

  const [withdrawAddress, setWithdrawAddress] = useState("");
  const [withdrawAddressError, setWithdrawAddressError] = useState("");
  const [error3, setError3] = useState("");
  const [final, setFinal] = useState(false);
  const [loading, setLoading] = useState(false);
  const [placeholder, setPlaceholder] = useState("")
  const [showTwoFactorInput, setShowTwoFactorInput] = useState(false);
  const [twoFactorCode, setTwoFactorCode] = useState('');
  const [is2FAEnabled, setIs2FAEnabled] = useState(false);

  // New function to check 2FA status
  const check2FAStatus = async () => {
    try {
      const response = await axios.get(`https://api.boss707.com/2fa/status/${getUID()}`);
      return response.data.isEnabled;
    } catch (error) {
      console.error('Error checking 2FA status:', error);
      return false;
    }
  };



  const isFiatCurrency = () => {
    const fiatCurrencies = ['INR', 'MVR', 'PKR', 'NPR', 'AED', 'SC'];
    return fiatCurrencies.includes(selectedCoin);
  };

  const getbankImage = (i) => {
    if (i === "Bank Of Maldives") {
      return "/assets/images/bom.png"
    }
    else {
      return "/assets/images/CBM.jpg"
    }
  }


  const handleCopy = () => {
    navigator.clipboard.writeText(address);
    setCopied(true);
    setTimeout(() => setCopied(false), 2000);
  };

  // Utility Functions
  const getCoinNameByNetwork = useCallback((network, coinInfo, defaultCoin) => {
    if (networkCoinMap[network]) {
      return networkCoinMap[network];
    }
    if (coinInfo && coinInfo.id) {
      return coinInfo.id;
    }
    return defaultCoin.toLowerCase();
  }, []);

  // Socket and Credit Management
  const getCreditAndCoins = useCallback((data) => {
    const { credit } = data;
    setState(prev => ({ ...prev, credits: credit }));
    setUpCoins();
  }, []);

  const setUpCoins = useCallback(() => {
    if (isMobile()) {
      setState(prev => ({ ...prev, height: 685, margin: "mt-1" }));
    }

    const newList = coins.reduce((acc, item, i) => {
      if (item.preffix === "NC") return acc;

      const credit = forceSatoshiFormat(
        state.credits[__.lowerCase(item.preffix)]
      );

      const listItem = (
        <Dropdown.Item
          key={__.toString(i)}
          as="button"
          className="animated fadeIn"
          onClick={() => loadCoinId(item.preffix)}
        >
          <span>
            <img
              src={`/assets/images/${item.image}`}
              className="img-fluid mini-coin mr-1"
              alt="Coin"
            />
            {item.preffix}
          </span>
        </Dropdown.Item>
      );

      return [...acc, listItem];
    }, []);

    setState(prev => ({ ...prev, list: newList }));
  }, [state.credits, isMobile]);

  // Archive Management
  const showArchive = useCallback(() => {
    if (state.slide) Event.emit("deposit_archive_back");

    setState(prev => ({ ...prev, slide: !prev.slide }));

    wait(300).then(() => {
      setState(prev => ({ ...prev, deposit: !prev.deposit }));
    });

    wait(300).then(() => {
      loadCoinId("BTC");
    });
  }, [state.slide]);

  // Coin Loading and Management
  const loadCoinId = useCallback(async (coin) => {
    if (coin.toUpperCase() === 'INR' || coin.toUpperCase() === 'MVR' || coin.toUpperCase() === 'PKR' || coin.toUpperCase() === 'AED') {
      console.log("Coin is skipping loadCoinId process.");
      return;
    }

    setState(prev => ({
      ...prev,
      currentCoin: coin,
      coinId: "",
      networks: [],
      selectedNetwork: "",
      isLoading: true,
      coinName: "",
      logoUrl: ""
    }));

    console.log("coin", coin)

    try {
      const token = storage.getKey('token');
      
      // Check if token exists before making the API call
      if (!token) {
        console.log('🔐 No token found, skipping coin details fetch');
        setState(prev => ({ ...prev, isLoading: false }));
        return;
      }

      console.log('🔐 Fetching coin details with token:', !!token);

      const response = await axios.post('https://api.boss707.com/getCoinDetails', 
        { symbol: coin.toUpperCase() },
        {
          headers: {
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${token}`
          }
        }
      );


      console.log("infor", response)

      const { coinId, networks, coinFullName, logoUrl } = response.data;
      let networksList = Object.keys(networks);

      const coinInfo = coinsList.find(item => item.symbol === coin.toUpperCase());
      let selectedNetwork = networksList[0] || "";
      let coinName = coinInfo ? coinInfo.id : coin.toLowerCase();

      if (coin.toUpperCase() === 'USDT') {
        networksList = ['ETH', 'TRX', 'BSC'];
      }

      coinName = getCoinNameByNetwork(selectedNetwork, coinInfo, coin);

      setState(prev => ({
        ...prev,
        coinId,
        networks: networksList,
        selectedNetwork,
        isLoading: false,
        coinName,
        logoUrl
      }));
    } catch (error) {
      console.error("Error fetching coin details:", error);
      
      if (error.response?.status === 401) {
        console.log('🔐 401 Unauthorized for coin details');
        // Handle unauthorized access gracefully
        setState(prev => ({ ...prev, isLoading: false }));
        return;
      }
      
      // sendNotfication("Error fetching coin information", "error", "top-right");
      setState(prev => ({ ...prev, isLoading: false }));
    }
  }, [getCoinNameByNetwork]);

  const processFiatWithdrawal = async () => {
    if (!state.amount || parseFloat(state.amount) <= 0) {
      sendNotfication("Please enter a valid amount", "error", "top-right");
      return;
    }

    if (!accountHolderName) {
      sendNotfication("Account holder name is required", "error", "top-right");
      return;
    }

    // Validation for INR withdrawals
    if (selectedCoin === 'INR') {
      if (inrWithdrawalType === "upi" && !upiId) {
        sendNotfication("UPI ID is required for UPI withdrawals", "error", "top-right");
        return;
      } else if (inrWithdrawalType === "bank" && (!bankName || !accountNumber || !ifscCode)) {
        sendNotfication("Bank details are required for bank transfers", "error", "top-right");
        return;
      }
    } 
  

    // Validation for non-INR fiat withdrawals
    if (selectedCoin !== 'INR' && (!bankName || !accountNumber || !ifscCode)) {
      sendNotfication("Bank details are required for withdrawals", "error", "top-right");
      return;
    }

    setState(prev => ({ ...prev, isLoading: true }));

    const payload = {
      uid: getUID().toString(),
      amount: state.amount,
      currency: selectedCoin,
      withdrawal_type: selectedCoin === 'INR' ? inrWithdrawalType : 'bank',
      bank_name: bankName,
      account_number: accountNumber,
      account_holder_name: accountHolderName,
      ifsc_code: ifscCode,
      upi_id: upiId
    };

    console.log("Withdrawal payload", payload);

    try {
      const response = await axios.post('https://api.boss707.com/createFiatWithdrawal', payload);
      
      if (response.data) {
        sendNotfication("Withdrawal request submitted successfully", "success", "top-right");
        // Reset form
        setState(prev => ({ ...prev, amount: "" }));
        setBankName("");
        setAccountNumber("");
        setAccountHolderName("");
        setIfscCode("");
        setUpiId("");
        setTimeout(() => {
          window.location.reload();
        }, 2000);
      } else {
        sendNotfication("Failed to submit withdrawal request", "error", "top-right");
      }
    } catch (error) {
      console.error("Error processing fiat withdrawal:", error);
      sendNotfication(error.response?.data?.error || "Error processing withdrawal", "error", "top-right");
    } finally {
      setState(prev => ({ ...prev, isLoading: false }));
    }
  };

  // const handleSubmit = () => {
  //   // Don't proceed if there's an error
  //   if (error3) {
  //     return;
  //   }
    
  //   if (isFiatCurrency()) {
  //     processFiatWithdrawal();
  //   } else {
  //     submitFormCrypto();
  //   }
  // };
  const handleSubmit = async () => {
    // Don't proceed if there's an error
    if (error3) {
      return;
    }
    
    // Check 2FA status first
    const twoFactorStatus = await check2FAStatus();
    setIs2FAEnabled(twoFactorStatus);

    if (twoFactorStatus) {
      // If 2FA is enabled, show 2FA input
      setShowTwoFactorInput(true);
    } else {
      // If 2FA is not enabled, proceed with normal withdrawal
      if (isFiatCurrency()) {
        processFiatWithdrawal();
      } else {
        submitFormCrypto();
      }
    }
  };

    // New function to handle 2FA verification
    const handleTwoFactorVerification = async () => {
      if (!twoFactorCode.trim()) {
        sendNotfication('Please enter verification code', 'error', 'top-right');
        return;
      }
  
      try {
        const response = await axios.post('https://api.boss707.com/2fa/verify', {
          uid: getUID(),
          token: twoFactorCode
        });
  
        if (response.data.success) {
          // 2FA verified, proceed with withdrawal
          setShowTwoFactorInput(false);
          setTwoFactorCode('');
  
          if (isFiatCurrency()) {
            processFiatWithdrawal();
          } else {
            submitFormCrypto();
          }
        } else {
          sendNotfication('Invalid verification code', 'error', 'top-right');
        }
      } catch (error) {
        sendNotfication('Failed to verify code', 'error', 'top-right');
      }
    };
  
    // Render 2FA modal
    const render2FAModal = () => {
      if (!showTwoFactorInput) return null;
  
      return (
        <div style={{
          position: 'fixed',
          top: 0,
          left: 0,
          right: 0,
          bottom: 0,
          backgroundColor: 'rgba(0,0,0,0.7)',
          display: 'flex',
          justifyContent: 'center',
          alignItems: 'center',
          zIndex: 1000
        }}>
          <div style={{
            backgroundColor: '#1E2329',
            padding: '24px',
            borderRadius: '8px',
            maxWidth: '500px',
            width: '90%'
          }}>
            <h3 style={{ color: 'white', marginBottom: '16px' }}>Two-Factor Authentication</h3>
            
            <div style={{ marginBottom: '16px' }}>
              <span style={{ color: '#B3BEC1', display: 'block', marginBottom: '8px' }}>
                Enter your 2FA verification code
              </span>
              <input
                type="text"
                value={twoFactorCode}
                onChange={(e) => setTwoFactorCode(e.target.value)}
                placeholder="Enter verification code"
                style={{
                  width: '100%',
                  backgroundColor: '#2B3139',
                  border: '1px solid #424B52',
                  padding: '10px 12px',
                  borderRadius: '4px',
                  color: 'white'
                }}
              />
            </div>
  
            <div style={{ display: 'flex', gap: '12px', justifyContent: 'flex-end' }}>
              <button
                onClick={() => setShowTwoFactorInput(false)}
                style={{
                  backgroundColor: 'transparent',
                  border: '1px solid #B3BEC1',
                  color: '#B3BEC1',
                  padding: '8px 16px',
                  borderRadius: '4px',
                  cursor: 'pointer'
                }}
              >
                Cancel
              </button>
              <button
                onClick={handleTwoFactorVerification}
                style={{
                  backgroundColor: '#0ECB81',
                  border: 'none',
                  color: 'white',
                  padding: '8px 16px',
                  borderRadius: '4px',
                  cursor: 'pointer'
                }}
              >
                Verify
              </button>
            </div>
          </div>
        </div>
      );
    };
  const handleConfirmWithdraw = () => {
    if (!password.trim()) {
      setPasswordError("Password is required");
      return;
    }
    submitFormCrypto();
  };

  // Update the submitFormCrypto function to include the password
  const submitFormCrypto = (e) => {
    if (e) e.preventDefault();
    console.log('Submit form called');

    // Check if withdrawAddress is empty
    if (!withdrawAddress.trim()) {
      setWithdrawAddressError('Withdraw address is required');
      return;
    } else {
      setWithdrawAddressError('');
    }
    if (!chainName.trim()) {
      sendNotfication("Chain required", "error", "top-right");
      return;
    }
    // Validation checks
    if (!state.amount || parseFloat(state.amount) <= 0) {
      setError3("Please enter a valid amount");
      return;
    }

    const fee = 0.01 * parseFloat(state.amount); // 1% fee
    const finalAmount = parseFloat(state.amount) - fee;
    console.log('Fee:', fee);
    console.log('Calculated finalAmount:', finalAmount);

    if (finalAmount <= 0) {
      setError3("Amount after fee must be greater than 0");
      return;
    }

    // Check minimum withdrawal amount
    const coin_info = coins.find(item =>
      item.preffix.toLowerCase() === selectedCoin.toLowerCase()
    );
    console.log('Found coin_info:', coin_info);

    if (coin_info && finalAmount < Number(coin_info.min)) {
      setError3(`Minimum withdrawal amount is ${coin_info.min} ${selectedCoin}`);
      return;
    }

    // For preview mode, just set final to true
    if (!final) {
      setFinal(true);
      return;
    }

    // For final submit
    console.log("Proceeding with final withdrawal");
    setLoading(true);

    setTimeout(() => {
      socket.emit(
        C.SUBMIT_NEW_WITHDRAWL,
        encode({
          coin: selectedCoin,
          wallet: withdrawAddress,
          amount: state.amount,
          immed: fee,
          password: password,
          chain: chainName,
          network: state.selectedNetwork
        })
      );

      // Reset form after submission
      setState(prev => ({ ...prev, amount: "" }));
      setWithdrawAddress("");
      setPassword("");
      setPasswordError("");
      setFinal(false);
      setLoading(false);

      // Show success notification
      sendNotfication("Withdrawal request submitted successfully", "success", "top-right");
      setTimeout(() => {
        window.location.reload();
      }, 2000);
    }, 500);
  };


  const handleCancelWithdraw = () => {
    setFinal(false);
  };

  // UI component for crypto address input
  const renderCryptoForm = () => {
    return (
      <div style={{ width: "100%", marginTop: "16px" }}>
        <div style={{ color: "#B3BEC1", margin: "4px 0" }}>
          Withdrawal Address ({selectedCoin})
        </div>
        <Input
          value={withdrawAddress}
          onChange={(e) => setWithdrawAddress(e.target.value)}
          placeholder={`Enter your ${selectedCoin} wallet address`}
        />
        {withdrawAddressError && (
          <div style={{ color: "red", fontSize: "12px", marginTop: "4px" }}>
            {withdrawAddressError}
          </div>
        )}
        {error3 && (
          <div style={{ color: "red", fontSize: "12px", marginTop: "4px" }}>
            {error3}
          </div>
        )}
        <div style={{ color: "#B3BEC1", margin: "4px 0" }}>
          Chain Name
        </div>
        <Input
          value={chainName}
          onChange={(e) => setChainName(e.target.value)}
          placeholder={`Enter your ${selectedCoin} chain / network name`}
        />
      </div>
    );
  };
  const handleAmountChange = (e) => {
    setState(prev => ({ ...prev, amount: e.target.value }));
  };

  const handleChainNameChange = (e) => {
    setState(prev => ({ ...prev, chainName: e.target.value }));
  };

  const handleNetworkChange = (e) => {
    setState(prev => ({ ...prev, selectedNetwork: e.target.value }));
  };

  // Socket Connection Effect
  useEffect(() => {
    const token = storage.getKey('token');

    if (token) {
      socket.emit(C.CREDIT, encode({ coin: selectedCoin }));
    }

    const handleCreditData = (data) => {
      const decodedData = decode(data);
      const { credit } = decodedData;
      setCredits(credit);

      const currentCoin = __.lowerCase(selectedCoin);
      const currentCredit = forceSatoshiFormat(credit[currentCoin]);
      storage.setKey('credit', currentCredit);
    };

    const handleCreditUpdate = (data) => {
      const decodedData = decode(data);
      const { value, coin: updatedCoin } = decodedData;
      const formattedValue = forceSatoshiFormat(value);

      setCredits(prev => ({
        ...prev,
        [__.lowerCase(updatedCoin)]: value
      }));

      if (__.lowerCase(updatedCoin) === __.lowerCase(selectedCoin)) {
        storage.setKey('credit', formattedValue);
      }
    };

    socket.on(C.CREDIT, handleCreditData);
    socket.on(C.UPDATE_CREDIT, handleCreditUpdate);

    return () => {
      socket.off(C.CREDIT, handleCreditData);
      socket.off(C.UPDATE_CREDIT, handleCreditUpdate);
    };
  }, [selectedCoin]);
  useEffect(() => {
    if (selectedCoin === "MVR") {
      setPlaceholder("Enter Withdraw Amount (Minmim 500MVR and Maximum 50,000MVR)")
    }
    else {
      setPlaceholder("Enter Withdraw Amount")
    }
  }, [selectedCoin])


  // Initial Setup Effect
  useEffect(() => {
    socket.emit(C.CREDIT, encode({ coin: storage.getKey('coin') || "INR" }));
    socket.on(C.CREDIT, (data) => getCreditAndCoins(decode(data)));

    Event.on("deposit_archive", showArchive);

    wait(400).then(() => {
      loadCoinId(storage.getKey('coin') || "INR");
    });

    return () => {
      socket.off(C.CREDIT);
    };
  }, [storage.getKey('coin') || "INR", getCreditAndCoins, loadCoinId, showArchive]);

  // Active Coins Initialization Effect
  useEffect(() => {
    if (!storage.getKey('active_coins')) {
      const defaultActiveCoins = ['1', '2', '3', '4', '5', '6', '7'];
      storage.setKey('active_coins', defaultActiveCoins.join(','));
      setActiveCoins(defaultActiveCoins);
    }
  }, []);
  // Click Outside Handler Effect
  useEffect(() => {
    const handleClickOutside = (event) => {
      if (isOpen && !event.target.closest('.dropdown-container')) {
        setIsOpen(false);
      }
    };

    document.addEventListener('click', handleClickOutside);
    return () => {
      document.removeEventListener('click', handleClickOutside);
    };
  }, [isOpen]);

  // Coin Selection Handler
  const handleCoinSelect = async (coinName) => {
    if (storage.getKey('coin') === coinName) {
      setIsOpen(false);
      return;
    }

    storage.setKey('coin', coinName);
    const credit = forceSatoshiFormat(credits[__.lowerCase(coinName)] || 0);
    storage.setKey('credit', credit);

    setSelectedCoin(coinName);
    setIsOpen(false);

    try {
      await wait(200);
      Event.emit('coin_changed', coinName);
    } catch (error) {
      console.error('Error during coin selection:', error);
    }
  };

  // Filtered Coins Logic
  const filteredCoins = coins
    .filter(coin => {
      if (!activeCoins.includes(coin.id.toString())) return false;
      return coin.preffix.toLowerCase().includes(searchTerm.toLowerCase());
    })
    .sort((a, b) => {
      if (a.preffix === 'BTC') return -1;
      if (b.preffix === 'BTC') return 1;
      return 0;
    });

  const selectedCoinData = coins.find(coin => coin.preffix === selectedCoin);
  //statically netwrosk added later will remove it
  const networkDetails = [
    "Etherum", "BEP20"
  ]
  const renderINROptions = () => {
    return (
      <div style={{ marginTop: "16px", marginBottom: "16px" }}>
        <div style={{ color: "#B3BEC1", margin: "4px 0" }}>Select Withdrawal Method</div>
        <div style={{ display: "flex", gap: "10px" }}>
          <button
            onClick={() => setInrWithdrawalType("upi")}
            style={{
              backgroundColor: inrWithdrawalType === "upi" ? "#f09c06" : "#2B3139",
              border: "none",
              padding: "8px 16px",
              borderRadius: "4px",
              color: "white",
              cursor: "pointer"
            }}
          >
            UPI
          </button>
          <button
            onClick={() => setInrWithdrawalType("bank")}
            style={{
              backgroundColor: inrWithdrawalType === "bank" ? "#f09c06" : "#2B3139",
              border: "none",
              padding: "8px 16px",
              borderRadius: "4px",
              color: "white",
              cursor: "pointer"
            }}
          >
            Bank Transfer
          </button>
        </div>
      </div>
    );
  };
  const renderBankForm = () => {
    if (selectedCoin === 'INR') {
      return (
        <div style={{ marginTop: "20px" }}>
          {renderINROptions()}
          
          <div style={{ color: "#B3BEC1", margin: "4px 0" }}>Account Holder Name</div>
          <Input
            value={accountHolderName}
            onChange={(e) => setAccountHolderName(e.target.value)}
            placeholder="Enter Account Holder Name"
          />
  
          {inrWithdrawalType === "upi" ? (
            <>
              <div style={{ color: "#B3BEC1", margin: "10px 0 4px 0" }}>UPI ID</div>
              <Input
                value={upiId}
                onChange={(e) => setUpiId(e.target.value)}
                placeholder="Enter UPI ID (example@upi)"
              />
            </>
          ) : (
            <>
              <div style={{ color: "#B3BEC1", margin: "10px 0 4px 0" }}>Bank Name</div>
              <Input
                value={bankName}
                onChange={(e) => setBankName(e.target.value)}
                placeholder="Enter Bank Name"
              />
  
              <div style={{ color: "#B3BEC1", margin: "10px 0 4px 0" }}>Account Number</div>
              <Input
                value={accountNumber}
                onChange={(e) => setAccountNumber(e.target.value)}
                placeholder="Enter Account Number"
              />
  
              <div style={{ color: "#B3BEC1", margin: "10px 0 4px 0" }}>IFSC Code</div>
              <Input
                value={ifscCode}
                onChange={(e) => setIfscCode(e.target.value)}
                placeholder="Enter IFSC Code"
              />
            </>
          )}
        </div>
      );
    }else {
      return (
        <div style={{ marginTop: "20px" }}>
          <div style={{ color: "#B3BEC1", margin: "4px 0" }}>Account Holder Name</div>
          <Input
            value={accountHolderName}
            onChange={(e) => setAccountHolderName(e.target.value)}
            placeholder="Enter Account Holder Name"
          />

          <div style={{ color: "#B3BEC1", margin: "10px 0 4px 0" }}>Bank Name</div>
          <Input
            value={bankName}
            onChange={(e) => setBankName(e.target.value)}
            placeholder="Enter Bank Name"
          />

          <div style={{ color: "#B3BEC1", margin: "10px 0 4px 0" }}>Account Number</div>
          <Input
            value={accountNumber}
            onChange={(e) => setAccountNumber(e.target.value)}
            placeholder="Enter Account Number"
          />

          <div style={{ color: "#B3BEC1", margin: "10px 0 4px 0" }}>IFSC Code</div>
          <Input
            value={ifscCode}
            onChange={(e) => setIfscCode(e.target.value)}
            placeholder="Enter IFSC Code"
          />
        </div>
      );
    }
  };

  return (
    <Container>

      <div style={{ display: "flex", gap: "5px", width: "100%" }}>
        <div style={{ flex: '1' }}>
          <div style={{ color: "#B3BEC1", margin: "4px 0" }}>Deposit Currency</div>
          <DropdownContainer>
            <DropdownButton onClick={(e) => {
              e.stopPropagation();
              setIsOpen(!isOpen);
            }}>
              <div style={{ display: 'flex', alignItems: 'center', gap: '12px' }}>
                <CoinImage
                  src={`/assets/images/${selectedCoinData?.image}`}
                  alt={selectedCoin}
                />
                <CoinName>{selectedCoin}</CoinName>
              </div>
              <ChevronDown size={20} />
            </DropdownButton>

            {isOpen && (
              <DropdownPanel onClick={e => e.stopPropagation()}>
                <SearchContainer>
                  <SearchIcon>
                    <Search size={20} />
                  </SearchIcon>
                  <SearchInput
                    placeholder="Search coins..."
                    value={searchTerm}
                    onChange={(e) => setSearchTerm(e.target.value)}
                    autoFocus
                  />
                </SearchContainer>

                {filteredCoins.map((coin) => (
                  <CoinOption
                    key={coin.id}
                    onClick={() => handleCoinSelect(coin.preffix)}
                    isSelected={selectedCoin === coin.preffix}
                  >
                    <CoinImage src={`/assets/images/${coin.image}`} alt={coin.preffix} />
                    <CoinName>{coin.preffix}</CoinName>
                    <CoinBalance>
                      {forceSatoshiFormat(credits[__.lowerCase(coin.preffix)] || 0)}
                    </CoinBalance>
                  </CoinOption>
                ))}
              </DropdownPanel>
            )}
          </DropdownContainer>
        </div>


      </div>
      <div style={{ flex: "1", width: "100%" }}>
        <div style={{ width: "100%", display: "flex", alignItems: "center", justifyContent: "space-between" }}>

          <div style={{ color: "#B3BEC1", margin: "4px 0" }}>
            Withdrawl Amount
          </div>

        </div>

      </div>
      <div style={{ width: "100%" }}>
        <Input
          value={state.amount}
          onChange={(e) => {
            const newAmount = e.target.value;
            setState((prev) => ({ ...prev, amount: newAmount }));
            
            // Clear error first
            setError3("");
            
            // Add validation specifically for MVR
            if (selectedCoin === "MVR") {
              const amount = parseFloat(newAmount);
              if (newAmount && !isNaN(amount)) {
                if (amount < 500) {
                  setError3("Minimum withdrawal amount for MVR is 500");
                } else if (amount > 50000) {
                  setError3("Maximum withdrawal amount for MVR is 50,000");
                }
              }
            }
          }}
          placeholder={placeholder}
        />
        {error3 && (
          <div style={{ color: "red", fontSize: "12px", marginTop: "4px", marginBottom: "8px" }}>
            {error3}
          </div>
        )}
      </div>
      {!isFiatCurrency() && renderCryptoForm()}
      {isFiatCurrency() && renderBankForm()}

      <WithdrawContainer>
        <Row1>
          <Label1 isGreen>Withdraw amount</Label1>
          <Amount isGreen large bold>
            {parseFloat(state.amount || 0).toFixed(
              isFiatCurrency() ? 2 : 8
            )} {selectedCoin}
          </Amount>
        </Row1>
        {!isFiatCurrency() && (
          <Row1>
            <Label1 isGray>
              Fee (1%):
              <IconButton>
                <FileQuestion />
              </IconButton>
            </Label1>
            <Amount>
              {(parseFloat(state.amount || 0) * 0.01).toFixed(8)} {selectedCoin}
            </Amount>
          </Row1>
        )}
        <Row1>
          <Label1 isGray>Total Withdraw amount</Label1>
          <Amount>
            {isFiatCurrency()
              ? (parseFloat(state.amount || 0)).toFixed(2)
              : (parseFloat(state.amount || 0) * 0.99).toFixed(8)
            } {selectedCoin}
          </Amount>
        </Row1>
      </WithdrawContainer>

      <DepositButton
        onClick={handleSubmit}
        disabled={loading}
      >
        {loading ? (
          <div>Processing...</div>
        ) : isFiatCurrency() ? (
          "Withdraw"
        ) : final ? (
          "Confirm Withdrawal"
        ) : (
          "Preview"
        )}
      </DepositButton>

      {/* Confirmation Modal for Crypto Withdrawals */}
      {final && !isFiatCurrency() && (
        <div style={{
          position: 'fixed',
          top: 0,
          left: 0,
          right: 0,
          bottom: 0,
          backgroundColor: 'rgba(0,0,0,0.7)',
          display: 'flex',
          justifyContent: 'center',
          alignItems: 'center',
          zIndex: 1000
        }}>
          <div style={{
            backgroundColor: '#1E2329',
            padding: '24px',
            borderRadius: '8px',
            maxWidth: '500px',
            width: '90%'
          }}>
            <h3 style={{ color: 'white', marginBottom: '16px' }}>Confirm Withdrawal</h3>

            <div style={{ marginBottom: '16px' }}>
              <div style={{ display: 'flex', justifyContent: 'space-between', marginBottom: '8px' }}>
                <span style={{ color: '#B3BEC1' }}>Address:</span>
                <span style={{ color: 'white', wordBreak: 'break-all' }}>{withdrawAddress}</span>
              </div>

              <div style={{ display: 'flex', justifyContent: 'space-between', marginBottom: '8px' }}>
                <span style={{ color: '#B3BEC1' }}>Network:</span>
                <span style={{ color: 'white' }}>{selectedCoin}</span>
              </div>
              <div style={{ display: 'flex', justifyContent: 'space-between', marginBottom: '8px' }}>
                <span style={{ color: '#B3BEC1' }}>Chain:</span>
                <span style={{ color: 'white' }}>{chainName}</span>
              </div>

              <div style={{ display: 'flex', justifyContent: 'space-between', marginBottom: '8px' }}>
                <span style={{ color: '#B3BEC1' }}>Amount:</span>
                <span style={{ color: 'white' }}>{parseFloat(state.amount).toFixed(8)} {selectedCoin}</span>
              </div>

              <div style={{ display: 'flex', justifyContent: 'space-between', marginBottom: '8px' }}>
                <span style={{ color: '#B3BEC1' }}>Fee (1%):</span>
                <span style={{ color: 'white' }}>{(parseFloat(state.amount) * 0.01).toFixed(8)} {selectedCoin}</span>
              </div>

              <div style={{ display: 'flex', justifyContent: 'space-between', marginBottom: '8px' }}>
                <span style={{ color: '#B3BEC1' }}>You will receive:</span>
                <span style={{ color: '#0ECB81' }}>{(parseFloat(state.amount) * 0.99).toFixed(8)} {selectedCoin}</span>
              </div>

              {/* Password field */}
              <div style={{ marginTop: '16px' }}>
                <span style={{ color: '#B3BEC1', display: 'block', marginBottom: '8px' }}>
                  Enter your password to confirm withdrawal
                </span>
                <input
                  type="password"
                  value={password}
                  onChange={(e) => setPassword(e.target.value)}
                  placeholder="Enter your password"
                  style={{
                    width: '100%',
                    backgroundColor: '#2B3139',
                    border: '1px solid #424B52',
                    padding: '10px 12px',
                    borderRadius: '4px',
                    color: 'white'
                  }}
                />
                {passwordError && (
                  <div style={{ color: 'red', fontSize: '12px', marginTop: '4px' }}>
                    {passwordError}
                  </div>
                )}
              </div>
            </div>

            <div style={{ display: 'flex', gap: '12px', justifyContent: 'flex-end' }}>
              <button
                onClick={handleCancelWithdraw}
                style={{
                  backgroundColor: 'transparent',
                  border: '1px solid #B3BEC1',
                  color: '#B3BEC1',
                  padding: '8px 16px',
                  borderRadius: '4px',
                  cursor: 'pointer'
                }}
              >
                Cancel
              </button>
              <button
                onClick={handleConfirmWithdraw}
                style={{
                  backgroundColor: '#0ECB81',
                  border: 'none',
                  color: 'white',
                  padding: '8px 16px',
                  borderRadius: '4px',
                  cursor: 'pointer'
                }}
              >
                Confirm
              </button>
            </div>
          </div>
        </div>
      )}
      {render2FAModal()}
 {
            selectedCoin==="MVR" &&( <WarningTextGreen>
              Note:Total 2 withdrawals per day,Unlimited withdrawal players can swap MVR to Crypto

            </WarningTextGreen>)
           }

      <WarningContainer>
        <WarningText>
          {isFiatCurrency()
            ? "For security purposes, large or suspicious withdrawal may take 1-6 hours for audit process. We appreciate your patience!"
            : `Please ensure you're using the correct ${state.selectedNetwork} network for your ${selectedCoin} withdrawal. Sending to an incorrect network may result in permanent loss of funds.`
          }
        </WarningText>
      </WarningContainer>
    </Container>
  );
};

export default SkylaWithdraw;