import React from "react";
import { Link } from "react-router-dom";
import { Row, Col, Card } from "react-bootstrap";
import C from "../../Constant";
import socket from "../../Socket";
import { __, encode, decode, wait, Event } from "../../Helper";

class Table extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            results: []
        }
    }

    componentDidMount() {
        wait(100).then(() => {
            socket.emit(C.SPORT_GAME, encode({ game: this.props.game }))
        })

        socket.on(C.SPORT_GAME, (data) => this.game(decode(data)));
    }

    game(data) {
        data.results.forEach((game, i) => {
            this.setState(state => ({ results: [game, ...state.results] }));
        })
    }

    render() {
        const results = this.state.results.map((item, i) =>
            <>
                <GameTable item={item} />
            </>
        );

        return <>
            <Card className="sport-card">
                <Card.Body>
                    {results}
                </Card.Body>
            </Card>
        </>
    }
}


class GameTable extends React.Component {
    add() {
        alert()
    }
    render() {
        const { league, home, away, id } = this.props.item
        return (
            <div className="sports-table">
                <div className="head">{league.name}</div>
                <Row>
                    <Col md="4">
                        <div className="live">Live</div>
                        <Link to={id}>
                            <div className="teams">{home.name}</div>
                            <div className="teams">{away.name}</div>
                        </Link>
                    </Col>
                    <Col md="8">
                        <Row>
                            <Col md="6" className="">
                                <button className="add btn btn-block btn-sport" onClick={this.add}>
                                    San Diego Lamirea
                                    <br />
                                    <span>1.55</span>
                                </button>
                            </Col>
                            <Col md="6" className="">
                                <button className="add btn btn-block btn-sport" onClick={this.add}>
                                    Lanas Bermos
                                    <br />
                                    <span>2.19</span>
                                </button>
                            </Col>
                        </Row>
                    </Col>
                </Row>
            </div>
        );
    }
}

export default Table;
