import * as React from 'react';
import Tabs from '@mui/material/Tabs';
import Tab from '@mui/material/Tab';
import Box from '@mui/material/Box';
import Typography from '@mui/material/Typography';
import Table from "./Table";

function TabPanel(props) {
  const { children, value, index, ...other } = props;

  return (
    <div
      role="tabpanel"
      hidden={value !== index}
      id={`full-width-tabpanel-${index}`}
      aria-labelledby={`full-width-tab-${index}`}
      {...other}
    >
      {value === index && (
        <Box p={0}>
          <Typography component={'span'}>{children}</Typography>
        </Box>
      )}
    </div>
  );
}

export default function IconTabs() {
  const [value, setValue] = React.useState(0);

  const handleChange = (event, newValue) => {
    setValue(newValue);
  };

  return (
    <Box sx={{ width: '100%' }}>
      <Box sx={{ borderBottom: 1, borderColor: 'divider' }}>
        <Tabs
          value={value}
          onChange={handleChange}
          aria-label="sports bet"
          className="sport-tabs"
        >
          <Tab icon={<i className="mdi mdi-soccer" />} iconPosition="top" label="Soccer" />
          <Tab icon={<i className="mdi mdi-basketball" />} iconPosition="top" label="Basketball" />
          <Tab icon={<i className="mdi mdi-volleyball" />} iconPosition="top" label="Volleyball" />
          <Tab icon={<i className="mdi mdi-hockey-sticks" />} iconPosition="top" label="Ice Hockey" />
          <Tab icon={<i className="mdi mdi-football" />} iconPosition="top" label="American Football" />
        </Tabs>
      </Box>
      <TabPanel value={value} index={0}>
        <Table game="soccer" />
      </TabPanel>
      <TabPanel value={value} index={1}>
        <Table game="basketball" />
      </TabPanel>
      <TabPanel value={value} index={2}>
        <Table game="volleyball" />
      </TabPanel>
      <TabPanel value={value} index={3}>
        <Table game="ice-hockey" />
      </TabPanel>
      <TabPanel value={value} index={4}>
        <Table game="american-football" />
      </TabPanel>
    </Box>
  );
}
