// import { Component } from "react"
// import styled from "styled-components"

// const Container = styled.div`
// //   background: #1a1a1a;
//   min-height: 100vh;
// //   padding: 20px;
// `

// const Header = styled.header`
//   display: flex;
//   align-items: center;
//   justify-content: space-between;
//   margin-bottom: 30px;
// `

// const Logo = styled.div`
//   img {
//     height: 40px;
//   }
// `

// const Navigation = styled.div`
//   display: flex;
//   gap: 10px;
// `

// const NavButton = styled.button`
//   background: ${(props) => (props.active ? "#333" : "transparent")};
//   color: white;
//   border: none;
//   padding: 8px 20px;
//   border-radius: 20px;
//   cursor: pointer;
//   transition: background 0.3s;

//   &:hover {
//     background: #333;
//   }
// `

// const GamesGrid = styled.div`
//   display: grid;
//   grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
//   gap: 20px;

//   @media (max-width: 768px) {
//     grid-template-columns: 1fr;
//   }
// `

// const GameCard = styled.div`
//   position: relative;
//   border-radius: 12px;
//   overflow: hidden;
//   cursor: pointer;
//   transition: transform 0.3s;

//   &:hover {
//     transform: translateY(-5px);
//   }

//   img {
//     width: 100%;
//     height: 200px;
//     object-fit: cover;
//   }
// `

// const GameTitle = styled.div`
//   position: absolute;
//   bottom: 0;
//   left: 0;
//   right: 0;
//   padding: 15px;
//   background: linear-gradient(transparent, rgba(0,0,0,0.8));
//   color: white;
//   font-size: 18px;
// `

// class BGamingProviders extends Component {
//   constructor(props) {
//     super(props)
//     this.state = {
//       isLogged: localStorage.getItem("logged") === "true",
//      displayEvoplayGaming: [
//         { id: 1, title: "Bac Bo", image: "path/to/bacbo.jpg" },
//         { id: 2, title: "Blackjack Silver C", image: "path/to/blackjack.jpg" },
//         { id: 3, title: "Casino Hold'em", image: "path/to/holdem.jpg" },
//         { id: 4, title: "VIP Gold", image: "path/to/vip-gold.jpg" },
//         { id: 5, title: "VIP Diamond", image: "path/to/vip-diamond.jpg" },
//         { id: 6, title: "Crazy Time", image: "path/to/crazy-time.jpg" },
//         { id: 7, title: "Lightning Roulette", image: "path/to/lightning.jpg" },
//         { id: 8, title: "VIP Platinum", image: "path/to/vip-platinum.jpg" },
//       ],
//       activeTab: "all",
//     }
//   }

//   render() {
//     const {displayEvoplayGaming, activeTab } = this.state

//     return (
//       <Container>
//         <Header>
//           <Logo>
//             <img src="/assets/images/evolutiongaming.webp" alt="Evolution Gaming" />
//           </Logo>
//           {/* <Navigation>
//             <NavButton active={activeTab === "all"} onClick={() => this.setState({ activeTab: "all" })}>
//               All
//             </NavButton>
//             <NavButton active={activeTab === "hot"} onClick={() => this.setState({ activeTab: "hot" })}>
//               HOT
//             </NavButton>
//           </Navigation> */}
//         </Header>

//         <GamesGrid>
//           {displayGamesCrashXgaming.map((game) => (
//             <GameCard key={game.id}>
//               <img src={game.image || "/placeholder.svg"} alt={game.title} />
//               <GameTitle>{game.title}</GameTitle>
//             </GameCard>
//           ))}
//         </GamesGrid>
//       </Container>
//     )
//   }
// }

// export default BGamingProviders;

import React, { Component } from 'react';
import styled from 'styled-components';
import { Play } from 'lucide-react';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faArrowLeft, faSpinner } from '@fortawesome/free-solid-svg-icons';
import { getUID } from '../../../Helper';

const Grid = styled.div`
  display: grid;
  grid-template-columns: repeat(2, 1fr);
  gap: 1rem;
  
  @media (min-width: 768px) {
    grid-template-columns: repeat(4, 1fr);
  }
  
  @media (min-width: 1024px) {
    grid-template-columns: repeat(5, 1fr);
  }
`;

const GameOverlay = styled.div`
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-color: rgba(0, 0, 0, 0.4);
  backdrop-filter: blur(5px);
  border-radius: 8px;
  display: flex;
  justify-content: center;
  align-items: center;
  opacity: 0;
  transition: opacity 0.2s ease;
`;

const PlayIconContainer = styled.div`
  width: 50px;
  height: 50px;
  border-radius: 50%;
  background-color: rgba(255, 255, 255, 0.3);
  display: flex;
  justify-content: center;
  align-items: center;
`;

const FullScreenContainer = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  z-index: 999;
  background-color: #1b2336;
`;

const FullScreenIframe = styled.iframe`
  width: 100%;
  height: 100%;
  border: none;
  display: ${(props) => (props.loading ? 'none' : 'block')};
`;

const PlayIcon = styled(Play)`
  color: #fff;
  font-size: 24px;
`;


const Header = styled.header`
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 30px;
`

const Logo = styled.div`
  img {
    height: 40px;
  }
`
const BackButton = styled.button`
  position: absolute;
  top: 10px;
  left: 10px;
  z-index: 1000;
  background: none;
  border: none;
  color: #fff;
  font-size: 24px;
  cursor: pointer;
  padding: 8px;
  
  &:hover {
    opacity: 0.8;
  }
`;

const GridWrapper = styled.div`
  display: grid;
  gap: 12px;
//   padding: 12px;
  width: 100%;
  
  /* Mobile - 3 items per row */
  grid-template-columns: repeat(3, 1fr);
  
  /* Tablet - 4 items per row */
  @media (min-width: 640px) {
    grid-template-columns: repeat(4, 1fr);
  }
  
  /* Desktop - 6 items per row */
  @media (min-width: 1024px) {
    grid-template-columns: repeat(6, 1fr);
    gap: 16px;
    // padding: 16px;
  }
  
  /* Large Desktop - 8 items per row */
  @media (min-width: 1280px) {
    grid-template-columns: repeat(8, 1fr);
    gap: 20px;
    // padding: 20px;
  }
`;

const LotteryGameCard = styled.div`
  width: 100%;
  aspect-ratio: 1.32;
  border-radius: 8px;
  position: relative;
  cursor: pointer;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  transition: transform 0.2s ease;

  &:hover {
    ${GameOverlay} {
      opacity: 1;
    }
    transform: translateY(-5px);
  }
`;

const LotteryGameImage = styled.img`
  width: 100%;
  height: 100%;
  object-fit: cover;
  border-radius: 8px;
`;

class BGamingProviders extends Component {
    constructor(props) {
        super(props);
        this.state = {
            isLogged: localStorage.getItem('logged') === 'true',
           displayEvoplayGaming: [],
            message: null,
            iframeUrl: '',
            showIframe: false,
            iframeLoading: false
        };
    }

    componentDidMount() {
        this.fetchGames();
    }

    handleIframeLoad = () => {
        this.setState({ iframeLoading: false });
    };

    handleBackButton = () => {
        this.setState({ showIframe: false, iframeUrl: '', iframeLoading: true });
    };

    fetchGames = async () => {
        const token = localStorage.getItem('token');
        try {
            const response = await fetch('https://api.boss707.com/api/games/list', {
                headers: {
                    'Authorization': `Bearer ${token}`,
                },
            });
            const result = await response.json();
        

            const evolutionVendors = ["bgaming"];
            const evolutionList = evolutionVendors.reduce((acc, vendor) => {
                if (result[vendor]) {
                  acc.push(...result[vendor]);
                }
                return acc;
              }, []);
            this.setState({displayEvoplayGaming: evolutionList });
        } catch (error) {
            this.setState({ message: { type: 'error', text: error.message } });
        }
    };

    handleGameLaunchXGaming = async (game) => {
        if (!this.state.isLogged) {
            this.setState({ message: { type: 'error', text: "Please login to play live game" } });
            return;
        }

        try {
            const token = localStorage.getItem('token');
            const response = await fetch('https://api.boss707.com/api/casino/gamerun', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': `Bearer ${token}`,
                },
                body: JSON.stringify({
                    game_id: game.id,
                    currency: "USD",
                    mode: "real",
                    language: "en",
                    home_url: "https://api.boss707.com",
                    device: "desktop",
                    user_id: getUID,
                    vendor: game.vendor,
                    title: game.title,
                    coin: "usdt"
                }),
            });

            const result = await response.json();
            if (result.gameRunUrl) {
                this.setState({ iframeUrl: result.gameRunUrl, showIframe: true, iframeLoading: true });
            } else {
                throw new Error("Failed to launch game");
            }
        } catch (error) {
            this.setState({ message: { type: 'error', text: error.message } });
        }
    };

    render() {
        const {displayEvoplayGaming, showIframe, iframeUrl, iframeLoading } = this.state;

        const imageStyle = {
            position: 'absolute',
            top: '50%',
            left: '50%',
            transform: 'translate(-50%, -50%)',
            width: '250px',
            animation: 'fadeinout 2s infinite',
        };

        const animationStyle = `
            @keyframes fadeinout {
                0%, 100% { opacity: 0; }
                50% { opacity: 1; }
            }
        `;

        if (showIframe) {
            return (
                <FullScreenContainer>
                    <style>{animationStyle}</style>
                    {iframeLoading && (
                        <img src="./assets/boss707.png" alt="Loading" style={imageStyle} />
                    )}
                    <FullScreenIframe
                        src={iframeUrl}
                        title="Game Iframe"
                        onLoad={this.handleIframeLoad}
                        loading={iframeLoading}
                    />
                    <BackButton onClick={this.handleBackButton}>
                        <FontAwesomeIcon icon={faArrowLeft} />
                    </BackButton>
                </FullScreenContainer>
            );
        }

        return (

            <>
                <Header>
                    <Logo>
                        <img src="/assets/images/Providers/BGamingProviders.webp" alt="NetEnt" />
                    </Logo>

                </Header>
                <GridWrapper>
                    {displayEvoplayGaming?.map((game, index) => (
                        <LotteryGameCard
                            key={game.id}
                            onClick={() => this.handleGameLaunchXGaming(game)}
                        >
                            <LotteryGameImage src={game.details_thumbnails_300x300} alt={`Game ${index}`} />
                            <GameOverlay>
                                <PlayIconContainer>
                                    <PlayIcon />
                                </PlayIconContainer>
                            </GameOverlay>
                        </LotteryGameCard>
                    ))}
                </GridWrapper>
            </>

        );
    }
}

export default BGamingProviders;