import React from 'react';
import styled from 'styled-components';

const StyledSVG = styled.svg`
  width: ${props => props.size || '25px'};
  height: ${props => props.size || '25px'};
  flex-none: 1;
`;

const Path = styled.path`
  fill: white;
  d: path("M16.3549 4C17.73 4 18.8448 5.10608 18.8448 6.47062C18.8448 6.48947 18.8448 6.50833 18.8439 6.52718C19.7462 6.7927 20.5964 7.18392 21.3731 7.67804C21.8145 7.28211 22.4 7.04016 23.0419 7.04016C24.4171 7.04016 25.5319 8.14624 25.5319 9.51078C25.5319 10.2131 25.2365 10.847 24.7619 11.2972C25.1998 12.0992 25.5293 12.9696 25.7307 13.8872C27.047 13.9516 28.0935 15.031 28.0935 16.3531C28.0935 17.7176 26.9787 18.8237 25.6036 18.8237C25.5839 18.8237 25.5652 18.8237 25.5464 18.8229C25.315 19.5999 24.9873 20.3383 24.5793 21.0233C24.9941 21.4624 25.2485 22.0555 25.2485 22.7068C25.2485 24.0713 24.1337 25.1774 22.7585 25.1774C22.1021 25.1774 21.5054 24.926 21.0607 24.5144C20.3719 24.9189 19.6275 25.2434 18.8431 25.4751L18.8448 25.5309C18.8448 26.8954 17.73 28.0015 16.3549 28.0015C14.9797 28.0015 13.8649 26.8954 13.8649 25.5309L13.8692 25.6574C12.9447 25.4578 12.0681 25.1303 11.2597 24.6951C10.8073 25.1664 10.168 25.4602 9.46036 25.4602C8.08521 25.4602 6.97042 24.3541 6.97042 22.9896C6.97042 22.3525 7.21369 21.7712 7.61317 21.3328C7.11467 20.563 6.72117 19.7193 6.45228 18.8221L6.39595 18.8245C5.0208 18.8245 3.90601 17.7184 3.90601 16.3539C3.90601 14.9893 5.0208 13.8833 6.39595 13.8833L6.26876 13.888C6.49752 12.8471 6.89103 11.8675 7.42111 10.9774C7.00541 10.5375 6.7519 9.9452 6.7519 9.29396C6.7519 7.92942 7.86669 6.82334 9.24183 6.82334C9.89825 6.82334 10.4949 7.07551 10.9405 7.48715C11.8351 6.9616 12.8218 6.57039 13.8709 6.34414C13.9366 5.03774 15.0249 4 16.3566 4H16.3549ZM14.0169 7.32375L13.9656 7.33396C13.0958 7.53821 12.2747 7.86972 11.5226 8.30885C11.6567 8.61051 11.7301 8.94359 11.7301 9.29396C11.7301 10.6585 10.6153 11.7646 9.24013 11.7646C8.9004 11.7646 8.57603 11.697 8.28069 11.5745C7.84364 12.3373 7.51416 13.1731 7.31783 14.0592C8.2363 14.4222 8.88503 15.3122 8.88503 16.3531C8.88503 17.3303 8.31398 18.1748 7.48428 18.5755C7.71475 19.3398 8.04509 20.0618 8.46165 20.7248C8.76809 20.5912 9.10526 20.5174 9.4595 20.5174C10.8346 20.5174 11.9494 21.6235 11.9494 22.988C11.9494 23.2889 11.8957 23.5772 11.7958 23.8435C12.4864 24.2159 13.2324 24.4987 14.0177 24.6786C14.3668 23.7327 15.281 23.0595 16.3549 23.0595C17.3612 23.0595 18.2285 23.6526 18.6211 24.505C19.275 24.3046 19.8956 24.0297 20.4752 23.6911C20.3411 23.3894 20.2677 23.0564 20.2677 22.706C20.2677 21.3415 21.3825 20.2354 22.7577 20.2354C23.0974 20.2354 23.4218 20.3029 23.7171 20.4255C24.0483 19.8481 24.318 19.2267 24.5144 18.5739C23.6847 18.174 23.1128 17.3296 23.1128 16.3531C23.1128 15.3122 23.7607 14.4222 24.6783 14.0577C24.505 13.2752 24.2284 12.5313 23.8631 11.8416C23.6061 11.9327 23.3296 11.9814 23.0411 11.9814C21.6659 11.9814 20.5511 10.8753 20.5511 9.51078C20.5511 9.14706 20.6305 8.80219 20.7722 8.49111C20.1107 8.06768 19.3877 7.72989 18.6211 7.49265C18.2285 8.34656 17.3612 8.93967 16.354 8.93967C15.281 8.93967 14.3668 8.26643 14.016 7.32218L14.0169 7.32375Z");
`;

const AffilateIcon = ({ size }) => {
  return (
    <StyledSVG viewBox="0 0 32 32">
      <Path />
    </StyledSVG>
  );
};

export default AffilateIcon;