import React from 'react';
import styled from 'styled-components';

const StyledSVG = styled.svg`
  width: ${props => props.size || '32px'};
  height: ${props => props.size || '32px'};
  flex-none: 1;
  fill: white;
`;

const Path1 = styled.path`
  d: path("M23.5427 5.55078C26.0335 5.55078 28.0525 7.54608 28.0525 10.0075V19.4521C28.0525 21.9136 26.0335 23.9089 23.5427 23.9089L16.9904 23.9081L9.92846 28.4007L9.9276 23.9081L8.50985 23.9089C6.01906 23.9089 4 21.9136 4 19.4521V10.0075C4 7.54608 6.01906 5.55078 8.50985 5.55078H23.5418H23.5427ZM10.0131 13.1999C9.18287 13.1999 8.50985 13.8846 8.50985 14.7298C8.50985 15.5751 9.18287 16.2598 10.0131 16.2598C10.8434 16.2598 11.5164 15.5751 11.5164 14.7298C11.5164 13.8846 10.8434 13.1999 10.0131 13.1999ZM22.0394 13.1999C21.2091 13.1999 20.5361 13.8846 20.5361 14.7298C20.5361 15.5751 21.2091 16.2598 22.0394 16.2598C22.8697 16.2598 23.5427 15.5751 23.5427 14.7298C23.5427 13.8846 22.8697 13.1999 22.0394 13.1999ZM16.0263 13.1999C15.196 13.1999 14.523 13.8846 14.523 14.7298C14.523 15.5751 15.196 16.2598 16.0263 16.2598C16.8565 16.2598 17.5295 15.5751 17.5295 14.7298C17.5295 13.8846 16.8565 13.1999 16.0263 13.1999");
`;

const ChatSkylaIcon = ({ size }) => {
  return (
    <StyledSVG viewBox="0 0 32 32" size={size}>
      <Path1 />
    </StyledSVG>
  );
};

export default ChatSkylaIcon;