// src/contexts/LoginSuccessContext.jsx
import React, { createContext, useState, useContext } from 'react';

// Create the context
const LoginSuccessContext = createContext();

// Create a provider component
export const LoginSuccessProvider = ({ children }) => {
  const [isLoginSuccessModalOpen, setIsLoginSuccessModalOpen] = useState(false);
  console.log("is login sciss" , isLoginSuccessModalOpen)

  const openLoginSuccessModal = () => {
    setIsLoginSuccessModalOpen(true);
  };

  const closeLoginSuccessModal = () => {
    setIsLoginSuccessModalOpen(false);
  };

  return (
    <LoginSuccessContext.Provider 
      value={{ 
        isLoginSuccessModalOpen, 
        openLoginSuccessModal, 
        closeLoginSuccessModal 
      }}
    >
      {children}
      {isLoginSuccessModalOpen && <LoginSuccessModal />}
    </LoginSuccessContext.Provider>
  );
};

// Custom hook for using the context
export const useLoginSuccess = () => {
  const context = useContext(LoginSuccessContext);
  if (!context) {
    throw new Error('useLoginSuccess must be used within a LoginSuccessProvider');
  }
  return context;
};

// Login Success Modal Component
const LoginSuccessModal = () => {
  const { closeLoginSuccessModal } = useLoginSuccess();

  return (
    <div className="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-[9999]">
      <div className="bg-white p-6 rounded-lg max-w-sm w-full">
        <h2 className="text-2xl font-bold mb-4">Login Successful!</h2>
        <p className="mb-4">You have been successfully logged in.</p>
        <button 
          onClick={closeLoginSuccessModal}
          className="w-full bg-green-500 text-white py-2 rounded hover:bg-green-600"
        >
          Continue
        </button>
      </div>
    </div>
  );
};