import { useEffect } from "react";
import socket from "./Socket";

export function useConfigSocket(onGlobal, onUser) {
  useEffect(() => {
    console.log("🔌 useConfigSocket - setting up socket listeners");
    
    socket.on("siteConfigUpdated", (data) => {
      console.log("🌍 useConfigSocket - received siteConfigUpdated:", data);
      onGlobal(data);
    });
    
    socket.on("userConfigUpdated", (data) => {
      console.log("👤 useConfigSocket - received userConfigUpdated:", data);
      onUser(data);
    });

    console.log("📡 useConfigSocket - emitting config requests");
    socket.emit("requestSiteConfig");
    socket.emit("requestUserConfig");

    return () => {
      console.log("🔌 useConfigSocket - cleaning up socket listeners");
      socket.off("siteConfigUpdated", onGlobal);
      socket.off("userConfigUpdated", onUser);
    };
  }, [onGlobal, onUser]);
}