import apiService from './apiService';

// Get token from localStorage
const getAuthToken = () => {
  return localStorage.getItem('token');
};

export const notificationService = {
  // Register Firebase token
  registerFirebase: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/firebase/register', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get unread notification count
 getUnreadCount: async (userId) => {
  const token = getAuthToken();

  if (!token) {
    return {
      success: false,
      message: 'Authorization token not found'
    };
  }
else{
  try {
    return await apiService.get(`/firebase/unread-count/${userId}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  } catch (error) {
    return {
      success: false,
      message: 'Failed to fetch unread count',
      error: error.response?.data || error.message
    };
  }
}
},

 getNotificationHistory: async (userId) => {
  const token = getAuthToken();

  if (!token) {
    return {
      success: false,
      message: 'Authorization token not found'
    };
  }

  try {
    return await apiService.get(`/firebase/history/${userId}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  } catch (error) {
    return {
      success: false,
      message: 'Failed to fetch unread count',
      error: error.response?.data || error.message
    };
  }
},


  // Get notification history
getUnreadCount: async (userId) => {
  const token = getAuthToken();

  if (!token) {
    return {
      success: false,
      message: 'Authorization token not found'
    };
  }
  else{

  try {
    return await apiService.get(`/firebase/unread-count/${userId}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  } catch (error) {
    return {
      success: false,
      message: 'Failed to fetch unread count',
      error: error.response?.data || error.message
    };
  }
}
},

  // Mark notification as read
  markAsRead: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/firebase/mark-as-read', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Mark multiple notifications as read
  markMultipleAsRead: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/firebase/mark-as-read', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },
};

export default notificationService; 