import apiService from './apiService';

// Get token from localStorage
const getAuthToken = () => {
  return localStorage.getItem('token');
};

export const uiService = {
  // Get all banner images
  getAllBannerImages: async () => {
    const token = getAuthToken();
    return await apiService.get('/api/banners/getAllImagesBinary', {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get image
  getImage: async (imagePath) => {
    const token = getAuthToken();
    return await apiService.get(imagePath, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },
};

export default uiService; 